# Plain

Plain is a web framework for building products with Python.

With the core `plain` package you can build an app that:

- Matches [URL patterns](./urls) to Python [views](./views)
- Handles [HTTP requests and responses](./http)
- Renders [HTML templates](./templates) with Jinja
- Processes user input via [forms](./forms)
- Has a [CLI interface](./cli)
- Serves static [assets](./assets) (CSS, JS, images)
- Can be modified with [middleware](./middleware)
- Integrates first-party and third-party [packages](./packages)
- Has a [preflight check system](./preflight)

With the official Plain ecosystem packages you can:

- Integrate a full-featured [database ORM](https://plainframework.com/docs/plain-models/)
- Use a built-in [user authentication](https://plainframework.com/docs/plain-auth/) system
- [Lint and format code](https://plainframework.com/docs/plain-code/)
- Run a [database-backed cache](https://plainframework.com/docs/plain-cache/)
- [Send emails](https://plainframework.com/docs/plain-mail/)
- Streamline [local development](https://plainframework.com/docs/plain-dev/)
- Manage [feature flags](https://plainframework.com/docs/plain-flags/)
- Integrate [HTMX](https://plainframework.com/docs/plain-htmx/)
- Style with [Tailwind CSS](https://plainframework.com/docs/plain-tailwind/)
- Add [OAuth login](https://plainframework.com/docs/plain-oauth/) and API access
- Run tests with [pytest](https://plainframework.com/docs/plain-test/)
- Run a [background job worker](https://plainframework.com/docs/plain-worker/)
- Build [staff tooling and admin dashboards](https://plainframework.com/docs/plain-staff/)

Learn more at [plainframework.com](https://plainframework.com).
