"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.captureStackTrace = void 0;
// tslint:disable-next-line:ban-types
function captureStackTrace(below) {
    if (process.env.CDK_DISABLE_STACK_TRACE) {
        return ['stack traces disabled'];
    }
    below = below || captureStackTrace; // hide myself if nothing else
    const object = { stack: '' };
    const previousLimit = Error.stackTraceLimit;
    try {
        Error.stackTraceLimit = Number.MAX_SAFE_INTEGER;
        Error.captureStackTrace(object, below);
    }
    finally {
        Error.stackTraceLimit = previousLimit;
    }
    if (!object.stack) {
        return [];
    }
    return object.stack.split('\n').slice(1).map(s => s.replace(/^\s*at\s+/, ''));
}
exports.captureStackTrace = captureStackTrace;
//# sourceMappingURL=data:application/json;base64,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