import { CfnCreationPolicy, CfnDeletionPolicy, CfnUpdatePolicy } from './cfn-resource-policy';
import { CfnTag } from './cfn-tag';
import { ICfnFinder } from './from-cfn';
import { IResolvable } from './resolvable';
/**
 * This class contains static methods called when going from
 * translated values received from {@link CfnParser.parseValue}
 * to the actual L1 properties -
 * things like changing IResolvable to the appropriate type
 * (string, string array, or number), etc.
 *
 * While this file not exported from the module
 * (to not make it part of the public API),
 * it is directly referenced in the generated L1 code.
 *
 * @experimental
 */
export declare class FromCloudFormation {
    static getAny(value: any): any;
    static getBoolean(value: any): boolean | IResolvable;
    static getDate(value: any): Date | IResolvable;
    static getString(value: any): string;
    static getNumber(value: any): number;
    static getStringArray(value: any): string[];
    static getArray<T>(value: any, mapper: (arg: any) => T): T[];
    static getMap<T>(value: any, mapper: (arg: any) => T): {
        [key: string]: T;
    };
    static getCfnTag(tag: any): CfnTag;
}
/**
 * The options for {@link FromCloudFormation.parseValue}.
 */
export interface ParseCfnOptions {
    /**
     * The finder interface used to resolve references in the template.
     */
    readonly finder: ICfnFinder;
}
/**
 * This class contains methods for translating from a pure CFN value
 * (like a JS object { "Ref": "Bucket" })
 * to a form CDK understands
 * (like Fn.ref('Bucket')).
 *
 * While this file not exported from the module
 * (to not make it part of the public API),
 * it is directly referenced in the generated L1 code,
 * so any renames of it need to be reflected in cfn2ts/codegen.ts as well.
 *
 * @experimental
 */
export declare class CfnParser {
    private readonly options;
    constructor(options: ParseCfnOptions);
    parseCreationPolicy(policy: any): CfnCreationPolicy | undefined;
    parseUpdatePolicy(policy: any): CfnUpdatePolicy | undefined;
    parseDeletionPolicy(policy: any): CfnDeletionPolicy | undefined;
    parseValue(cfnValue: any): any;
    private parseIfCfnIntrinsic;
}
