"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// Copyright 2012-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// tslint:disable:max-line-length | This is generated code - line lengths are difficult to control
const cloudwatch = require("../../aws-cloudwatch"); // Automatically re-written from '@aws-cdk/aws-cloudwatch'
const queue_base_1 = require("./queue-base");
queue_base_1.QueueBase.prototype.metric = function (metricName, props) {
    return new cloudwatch.Metric({
        namespace: 'AWS/SQS',
        metricName,
        dimensions: { QueueName: this.queueName },
        ...props
    }).attachTo(this);
};
queue_base_1.QueueBase.prototype.metricApproximateAgeOfOldestMessage = function (props) {
    return this.metric('ApproximateAgeOfOldestMessage', { statistic: 'Maximum', ...props });
};
queue_base_1.QueueBase.prototype.metricApproximateNumberOfMessagesDelayed = function (props) {
    return this.metric('ApproximateNumberOfMessagesDelayed', { statistic: 'Maximum', ...props });
};
queue_base_1.QueueBase.prototype.metricApproximateNumberOfMessagesNotVisible = function (props) {
    return this.metric('ApproximateNumberOfMessagesNotVisible', { statistic: 'Maximum', ...props });
};
queue_base_1.QueueBase.prototype.metricApproximateNumberOfMessagesVisible = function (props) {
    return this.metric('ApproximateNumberOfMessagesVisible', { statistic: 'Maximum', ...props });
};
queue_base_1.QueueBase.prototype.metricNumberOfEmptyReceives = function (props) {
    return this.metric('NumberOfEmptyReceives', { statistic: 'Sum', ...props });
};
queue_base_1.QueueBase.prototype.metricNumberOfMessagesDeleted = function (props) {
    return this.metric('NumberOfMessagesDeleted', { statistic: 'Sum', ...props });
};
queue_base_1.QueueBase.prototype.metricNumberOfMessagesReceived = function (props) {
    return this.metric('NumberOfMessagesReceived', { statistic: 'Sum', ...props });
};
queue_base_1.QueueBase.prototype.metricNumberOfMessagesSent = function (props) {
    return this.metric('NumberOfMessagesSent', { statistic: 'Sum', ...props });
};
queue_base_1.QueueBase.prototype.metricSentMessageSize = function (props) {
    return this.metric('SentMessageSize', { statistic: 'Average', ...props });
};
//# sourceMappingURL=data:application/json;base64,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