"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AddHeader = void 0;
/**
 * Adds a header to the received email
 */
class AddHeader {
    constructor(props) {
        if (!/^[a-zA-Z0-9-]{1,50}$/.test(props.name)) {
            // tslint:disable:max-line-length
            throw new Error('Header `name` must be between 1 and 50 characters, inclusive, and consist of alphanumeric (a-z, A-Z, 0-9) characters and dashes only.');
            // tslint:enable:max-line-length
        }
        if (!/^[^\n\r]{0,2047}$/.test(props.value)) {
            throw new Error('Header `value` must be less than 2048 characters, and must not contain newline characters ("\r" or "\n").');
        }
        this.name = props.name;
        this.value = props.value;
    }
    bind(_rule) {
        return {
            addHeaderAction: {
                headerName: this.name,
                headerValue: this.value,
            },
        };
    }
}
exports.AddHeader = AddHeader;
//# sourceMappingURL=data:application/json;base64,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