import * as lambda from "../../aws-lambda";
import * as cdk from "../../core";
import { ParcelBaseOptions } from './bundling';
/**
 * Properties for a NodejsFunction
 */
export interface NodejsFunctionProps extends lambda.FunctionOptions, ParcelBaseOptions {
    /**
     * Path to the entry file (JavaScript or TypeScript).
     *
     * @default - Derived from the name of the defining file and the construct's id.
     * If the `NodejsFunction` is defined in `stack.ts` with `my-handler` as id
     * (`new NodejsFunction(this, 'my-handler')`), the construct will look at `stack.my-handler.ts`
     * and `stack.my-handler.js`.
     */
    readonly entry?: string;
    /**
     * The name of the exported handler in the entry file.
     *
     * @default handler
     */
    readonly handler?: string;
    /**
     * The runtime environment. Only runtimes of the Node.js family are
     * supported.
     *
     * @default - `NODEJS_12_X` if `process.versions.node` >= '12.0.0',
     * `NODEJS_10_X` otherwise.
     */
    readonly runtime?: lambda.Runtime;
}
/**
 * A Node.js Lambda function bundled using Parcel
 */
export declare class NodejsFunction extends lambda.Function {
    constructor(scope: cdk.Construct, id: string, props?: NodejsFunctionProps);
}
