"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SqsDlq = void 0;
/**
 * An SQS dead letter queue destination configuration for a Lambda event source
 */
class SqsDlq {
    constructor(queue) {
        this.queue = queue;
    }
    /**
     * Returns a destination configuration for the DLQ
     */
    bind(_target, targetHandler) {
        this.queue.grantSendMessages(targetHandler);
        return {
            destination: this.queue.queueArn,
        };
    }
}
exports.SqsDlq = SqsDlq;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3FzLWRscS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInNxcy1kbHEudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBRUE7O0dBRUc7QUFDSCxNQUFhLE1BQU07SUFDZixZQUE2QixLQUFpQjtRQUFqQixVQUFLLEdBQUwsS0FBSyxDQUFZO0lBQzlDLENBQUM7SUFDRDs7T0FFRztJQUNJLElBQUksQ0FBQyxPQUE0QixFQUFFLGFBQXdCO1FBQzlELElBQUksQ0FBQyxLQUFLLENBQUMsaUJBQWlCLENBQUMsYUFBYSxDQUFDLENBQUM7UUFDNUMsT0FBTztZQUNILFdBQVcsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFFBQVE7U0FDbkMsQ0FBQztJQUNOLENBQUM7Q0FDSjtBQVpELHdCQVlDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgRGxxRGVzdGluYXRpb25Db25maWcsIElFdmVudFNvdXJjZURscSwgSUV2ZW50U291cmNlTWFwcGluZywgSUZ1bmN0aW9uIH0gZnJvbSBcIi4uLy4uL2F3cy1sYW1iZGFcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2F3cy1sYW1iZGEnXG5pbXBvcnQgKiBhcyBzcXMgZnJvbSBcIi4uLy4uL2F3cy1zcXNcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2F3cy1zcXMnXG4vKipcbiAqIEFuIFNRUyBkZWFkIGxldHRlciBxdWV1ZSBkZXN0aW5hdGlvbiBjb25maWd1cmF0aW9uIGZvciBhIExhbWJkYSBldmVudCBzb3VyY2VcbiAqL1xuZXhwb3J0IGNsYXNzIFNxc0RscSBpbXBsZW1lbnRzIElFdmVudFNvdXJjZURscSB7XG4gICAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBxdWV1ZTogc3FzLklRdWV1ZSkge1xuICAgIH1cbiAgICAvKipcbiAgICAgKiBSZXR1cm5zIGEgZGVzdGluYXRpb24gY29uZmlndXJhdGlvbiBmb3IgdGhlIERMUVxuICAgICAqL1xuICAgIHB1YmxpYyBiaW5kKF90YXJnZXQ6IElFdmVudFNvdXJjZU1hcHBpbmcsIHRhcmdldEhhbmRsZXI6IElGdW5jdGlvbik6IERscURlc3RpbmF0aW9uQ29uZmlnIHtcbiAgICAgICAgdGhpcy5xdWV1ZS5ncmFudFNlbmRNZXNzYWdlcyh0YXJnZXRIYW5kbGVyKTtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIGRlc3RpbmF0aW9uOiB0aGlzLnF1ZXVlLnF1ZXVlQXJuLFxuICAgICAgICB9O1xuICAgIH1cbn1cbiJdfQ==