"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
// tslint:disable:no-console
// eslint-disable-next-line import/no-extraneous-dependencies
const AWS = require("aws-sdk");
async function handler(event) {
    console.log('Event: %j', event);
    console.log('AWS SDK VERSION: ' + AWS.VERSION);
    const awsService = new AWS[event.service](event.apiVersion && { apiVersion: event.apiVersion });
    try {
        const response = await awsService[event.action](event.parameters).promise();
        console.log('Response: %j', response);
    }
    catch (e) {
        console.log(e);
        if (!event.catchErrorPattern || !new RegExp(event.catchErrorPattern).test(e.code)) {
            throw e;
        }
    }
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,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