"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HelmChart = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * Represents a helm chart within the Kubernetes system.
 *
 * Applies/deletes the resources using `kubectl` in sync with the resource.
 */
class HelmChart extends core_1.Construct {
    constructor(scope, id, props) {
        var _a, _b, _c, _d, _e;
        super(scope, id);
        const stack = core_1.Stack.of(this);
        const provider = props.cluster._kubectlProvider;
        const timeout = (_a = props.timeout) === null || _a === void 0 ? void 0 : _a.toSeconds();
        if (timeout && timeout > 900) {
            throw new Error('Helm chart timeout cannot be higher than 15 minutes.');
        }
        // default not to wait
        const wait = (_b = props.wait) !== null && _b !== void 0 ? _b : false;
        // default to create new namespace
        const createNamespace = (_c = props.createNamespace) !== null && _c !== void 0 ? _c : true;
        new core_1.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            resourceType: HelmChart.RESOURCE_TYPE,
            properties: {
                ClusterName: props.cluster.clusterName,
                RoleArn: props.cluster._kubectlCreationRole.roleArn,
                Release: (_d = props.release) !== null && _d !== void 0 ? _d : this.node.uniqueId.slice(-53).toLowerCase(),
                Chart: props.chart,
                Version: props.version,
                Wait: wait || undefined,
                Timeout: timeout ? `${timeout.toString()}s` : undefined,
                Values: (props.values ? stack.toJsonString(props.values) : undefined),
                Namespace: (_e = props.namespace) !== null && _e !== void 0 ? _e : 'default',
                Repository: props.repository,
                CreateNamespace: createNamespace || undefined,
            },
        });
    }
}
exports.HelmChart = HelmChart;
/**
 * The CloudFormation resource type.
 */
HelmChart.RESOURCE_TYPE = 'Custom::AWSCDK-EKS-HelmChart';
//# sourceMappingURL=data:application/json;base64,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