import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::AppMesh::Mesh`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-mesh.html
 */
export interface CfnMeshProps {
    /**
     * `AWS::AppMesh::Mesh.MeshName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-mesh.html#cfn-appmesh-mesh-meshname
     */
    readonly meshName: string;
    /**
     * `AWS::AppMesh::Mesh.Spec`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-mesh.html#cfn-appmesh-mesh-spec
     */
    readonly spec?: CfnMesh.MeshSpecProperty | cdk.IResolvable;
    /**
     * `AWS::AppMesh::Mesh.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-mesh.html#cfn-appmesh-mesh-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::AppMesh::Mesh`
 *
 * @cloudformationResource AWS::AppMesh::Mesh
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-mesh.html
 */
export declare class CfnMesh extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppMesh::Mesh";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnMesh;
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @cloudformationAttribute MeshName
     */
    readonly attrMeshName: string;
    /**
     * @cloudformationAttribute MeshOwner
     */
    readonly attrMeshOwner: string;
    /**
     * @cloudformationAttribute ResourceOwner
     */
    readonly attrResourceOwner: string;
    /**
     * @cloudformationAttribute Uid
     */
    readonly attrUid: string;
    /**
     * `AWS::AppMesh::Mesh.MeshName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-mesh.html#cfn-appmesh-mesh-meshname
     */
    meshName: string;
    /**
     * `AWS::AppMesh::Mesh.Spec`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-mesh.html#cfn-appmesh-mesh-spec
     */
    spec: CfnMesh.MeshSpecProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AppMesh::Mesh.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-mesh.html#cfn-appmesh-mesh-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::AppMesh::Mesh`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnMeshProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnMesh {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-mesh-egressfilter.html
     */
    interface EgressFilterProperty {
        /**
         * `CfnMesh.EgressFilterProperty.Type`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-mesh-egressfilter.html#cfn-appmesh-mesh-egressfilter-type
         */
        readonly type: string;
    }
}
export declare namespace CfnMesh {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-mesh-meshspec.html
     */
    interface MeshSpecProperty {
        /**
         * `CfnMesh.MeshSpecProperty.EgressFilter`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-mesh-meshspec.html#cfn-appmesh-mesh-meshspec-egressfilter
         */
        readonly egressFilter?: CfnMesh.EgressFilterProperty | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::AppMesh::Route`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 */
export interface CfnRouteProps {
    /**
     * `AWS::AppMesh::Route.MeshName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-meshname
     */
    readonly meshName: string;
    /**
     * `AWS::AppMesh::Route.RouteName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-routename
     */
    readonly routeName: string;
    /**
     * `AWS::AppMesh::Route.Spec`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-spec
     */
    readonly spec: CfnRoute.RouteSpecProperty | cdk.IResolvable;
    /**
     * `AWS::AppMesh::Route.VirtualRouterName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-virtualroutername
     */
    readonly virtualRouterName: string;
    /**
     * `AWS::AppMesh::Route.MeshOwner`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-meshowner
     */
    readonly meshOwner?: string;
    /**
     * `AWS::AppMesh::Route.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::AppMesh::Route`
 *
 * @cloudformationResource AWS::AppMesh::Route
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html
 */
export declare class CfnRoute extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppMesh::Route";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnRoute;
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @cloudformationAttribute MeshName
     */
    readonly attrMeshName: string;
    /**
     * @cloudformationAttribute MeshOwner
     */
    readonly attrMeshOwner: string;
    /**
     * @cloudformationAttribute ResourceOwner
     */
    readonly attrResourceOwner: string;
    /**
     * @cloudformationAttribute RouteName
     */
    readonly attrRouteName: string;
    /**
     * @cloudformationAttribute Uid
     */
    readonly attrUid: string;
    /**
     * @cloudformationAttribute VirtualRouterName
     */
    readonly attrVirtualRouterName: string;
    /**
     * `AWS::AppMesh::Route.MeshName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-meshname
     */
    meshName: string;
    /**
     * `AWS::AppMesh::Route.RouteName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-routename
     */
    routeName: string;
    /**
     * `AWS::AppMesh::Route.Spec`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-spec
     */
    spec: CfnRoute.RouteSpecProperty | cdk.IResolvable;
    /**
     * `AWS::AppMesh::Route.VirtualRouterName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-virtualroutername
     */
    virtualRouterName: string;
    /**
     * `AWS::AppMesh::Route.MeshOwner`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-meshowner
     */
    meshOwner: string | undefined;
    /**
     * `AWS::AppMesh::Route.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::AppMesh::Route`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnRouteProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnRoute {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-duration.html
     */
    interface DurationProperty {
        /**
         * `CfnRoute.DurationProperty.Unit`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-duration.html#cfn-appmesh-route-duration-unit
         */
        readonly unit: string;
        /**
         * `CfnRoute.DurationProperty.Value`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-duration.html#cfn-appmesh-route-duration-value
         */
        readonly value: number;
    }
}
export declare namespace CfnRoute {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcretrypolicy.html
     */
    interface GrpcRetryPolicyProperty {
        /**
         * `CfnRoute.GrpcRetryPolicyProperty.GrpcRetryEvents`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcretrypolicy.html#cfn-appmesh-route-grpcretrypolicy-grpcretryevents
         */
        readonly grpcRetryEvents?: string[];
        /**
         * `CfnRoute.GrpcRetryPolicyProperty.HttpRetryEvents`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcretrypolicy.html#cfn-appmesh-route-grpcretrypolicy-httpretryevents
         */
        readonly httpRetryEvents?: string[];
        /**
         * `CfnRoute.GrpcRetryPolicyProperty.MaxRetries`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcretrypolicy.html#cfn-appmesh-route-grpcretrypolicy-maxretries
         */
        readonly maxRetries: number;
        /**
         * `CfnRoute.GrpcRetryPolicyProperty.PerRetryTimeout`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcretrypolicy.html#cfn-appmesh-route-grpcretrypolicy-perretrytimeout
         */
        readonly perRetryTimeout: CfnRoute.DurationProperty | cdk.IResolvable;
        /**
         * `CfnRoute.GrpcRetryPolicyProperty.TcpRetryEvents`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcretrypolicy.html#cfn-appmesh-route-grpcretrypolicy-tcpretryevents
         */
        readonly tcpRetryEvents?: string[];
    }
}
export declare namespace CfnRoute {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroute.html
     */
    interface GrpcRouteProperty {
        /**
         * `CfnRoute.GrpcRouteProperty.Action`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroute.html#cfn-appmesh-route-grpcroute-action
         */
        readonly action: CfnRoute.GrpcRouteActionProperty | cdk.IResolvable;
        /**
         * `CfnRoute.GrpcRouteProperty.Match`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroute.html#cfn-appmesh-route-grpcroute-match
         */
        readonly match: CfnRoute.GrpcRouteMatchProperty | cdk.IResolvable;
        /**
         * `CfnRoute.GrpcRouteProperty.RetryPolicy`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroute.html#cfn-appmesh-route-grpcroute-retrypolicy
         */
        readonly retryPolicy?: CfnRoute.GrpcRetryPolicyProperty | cdk.IResolvable;
        /**
         * `CfnRoute.GrpcRouteProperty.Timeout`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroute.html#cfn-appmesh-route-grpcroute-timeout
         */
        readonly timeout?: CfnRoute.GrpcTimeoutProperty | cdk.IResolvable;
    }
}
export declare namespace CfnRoute {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcrouteaction.html
     */
    interface GrpcRouteActionProperty {
        /**
         * `CfnRoute.GrpcRouteActionProperty.WeightedTargets`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcrouteaction.html#cfn-appmesh-route-grpcrouteaction-weightedtargets
         */
        readonly weightedTargets: Array<CfnRoute.WeightedTargetProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnRoute {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutematch.html
     */
    interface GrpcRouteMatchProperty {
        /**
         * `CfnRoute.GrpcRouteMatchProperty.Metadata`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutematch.html#cfn-appmesh-route-grpcroutematch-metadata
         */
        readonly metadata?: Array<CfnRoute.GrpcRouteMetadataProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnRoute.GrpcRouteMatchProperty.MethodName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutematch.html#cfn-appmesh-route-grpcroutematch-methodname
         */
        readonly methodName?: string;
        /**
         * `CfnRoute.GrpcRouteMatchProperty.ServiceName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutematch.html#cfn-appmesh-route-grpcroutematch-servicename
         */
        readonly serviceName?: string;
    }
}
export declare namespace CfnRoute {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadata.html
     */
    interface GrpcRouteMetadataProperty {
        /**
         * `CfnRoute.GrpcRouteMetadataProperty.Invert`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadata.html#cfn-appmesh-route-grpcroutemetadata-invert
         */
        readonly invert?: boolean | cdk.IResolvable;
        /**
         * `CfnRoute.GrpcRouteMetadataProperty.Match`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadata.html#cfn-appmesh-route-grpcroutemetadata-match
         */
        readonly match?: CfnRoute.GrpcRouteMetadataMatchMethodProperty | cdk.IResolvable;
        /**
         * `CfnRoute.GrpcRouteMetadataProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadata.html#cfn-appmesh-route-grpcroutemetadata-name
         */
        readonly name: string;
    }
}
export declare namespace CfnRoute {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadatamatchmethod.html
     */
    interface GrpcRouteMetadataMatchMethodProperty {
        /**
         * `CfnRoute.GrpcRouteMetadataMatchMethodProperty.Exact`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadatamatchmethod.html#cfn-appmesh-route-grpcroutemetadatamatchmethod-exact
         */
        readonly exact?: string;
        /**
         * `CfnRoute.GrpcRouteMetadataMatchMethodProperty.Prefix`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadatamatchmethod.html#cfn-appmesh-route-grpcroutemetadatamatchmethod-prefix
         */
        readonly prefix?: string;
        /**
         * `CfnRoute.GrpcRouteMetadataMatchMethodProperty.Range`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadatamatchmethod.html#cfn-appmesh-route-grpcroutemetadatamatchmethod-range
         */
        readonly range?: CfnRoute.MatchRangeProperty | cdk.IResolvable;
        /**
         * `CfnRoute.GrpcRouteMetadataMatchMethodProperty.Regex`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadatamatchmethod.html#cfn-appmesh-route-grpcroutemetadatamatchmethod-regex
         */
        readonly regex?: string;
        /**
         * `CfnRoute.GrpcRouteMetadataMatchMethodProperty.Suffix`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadatamatchmethod.html#cfn-appmesh-route-grpcroutemetadatamatchmethod-suffix
         */
        readonly suffix?: string;
    }
}
export declare namespace CfnRoute {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpctimeout.html
     */
    interface GrpcTimeoutProperty {
        /**
         * `CfnRoute.GrpcTimeoutProperty.Idle`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpctimeout.html#cfn-appmesh-route-grpctimeout-idle
         */
        readonly idle?: CfnRoute.DurationProperty | cdk.IResolvable;
        /**
         * `CfnRoute.GrpcTimeoutProperty.PerRequest`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpctimeout.html#cfn-appmesh-route-grpctimeout-perrequest
         */
        readonly perRequest?: CfnRoute.DurationProperty | cdk.IResolvable;
    }
}
export declare namespace CfnRoute {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-headermatchmethod.html
     */
    interface HeaderMatchMethodProperty {
        /**
         * `CfnRoute.HeaderMatchMethodProperty.Exact`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-headermatchmethod.html#cfn-appmesh-route-headermatchmethod-exact
         */
        readonly exact?: string;
        /**
         * `CfnRoute.HeaderMatchMethodProperty.Prefix`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-headermatchmethod.html#cfn-appmesh-route-headermatchmethod-prefix
         */
        readonly prefix?: string;
        /**
         * `CfnRoute.HeaderMatchMethodProperty.Range`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-headermatchmethod.html#cfn-appmesh-route-headermatchmethod-range
         */
        readonly range?: CfnRoute.MatchRangeProperty | cdk.IResolvable;
        /**
         * `CfnRoute.HeaderMatchMethodProperty.Regex`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-headermatchmethod.html#cfn-appmesh-route-headermatchmethod-regex
         */
        readonly regex?: string;
        /**
         * `CfnRoute.HeaderMatchMethodProperty.Suffix`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-headermatchmethod.html#cfn-appmesh-route-headermatchmethod-suffix
         */
        readonly suffix?: string;
    }
}
export declare namespace CfnRoute {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httpretrypolicy.html
     */
    interface HttpRetryPolicyProperty {
        /**
         * `CfnRoute.HttpRetryPolicyProperty.HttpRetryEvents`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httpretrypolicy.html#cfn-appmesh-route-httpretrypolicy-httpretryevents
         */
        readonly httpRetryEvents?: string[];
        /**
         * `CfnRoute.HttpRetryPolicyProperty.MaxRetries`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httpretrypolicy.html#cfn-appmesh-route-httpretrypolicy-maxretries
         */
        readonly maxRetries: number;
        /**
         * `CfnRoute.HttpRetryPolicyProperty.PerRetryTimeout`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httpretrypolicy.html#cfn-appmesh-route-httpretrypolicy-perretrytimeout
         */
        readonly perRetryTimeout: CfnRoute.DurationProperty | cdk.IResolvable;
        /**
         * `CfnRoute.HttpRetryPolicyProperty.TcpRetryEvents`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httpretrypolicy.html#cfn-appmesh-route-httpretrypolicy-tcpretryevents
         */
        readonly tcpRetryEvents?: string[];
    }
}
export declare namespace CfnRoute {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproute.html
     */
    interface HttpRouteProperty {
        /**
         * `CfnRoute.HttpRouteProperty.Action`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproute.html#cfn-appmesh-route-httproute-action
         */
        readonly action: CfnRoute.HttpRouteActionProperty | cdk.IResolvable;
        /**
         * `CfnRoute.HttpRouteProperty.Match`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproute.html#cfn-appmesh-route-httproute-match
         */
        readonly match: CfnRoute.HttpRouteMatchProperty | cdk.IResolvable;
        /**
         * `CfnRoute.HttpRouteProperty.RetryPolicy`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproute.html#cfn-appmesh-route-httproute-retrypolicy
         */
        readonly retryPolicy?: CfnRoute.HttpRetryPolicyProperty | cdk.IResolvable;
        /**
         * `CfnRoute.HttpRouteProperty.Timeout`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproute.html#cfn-appmesh-route-httproute-timeout
         */
        readonly timeout?: CfnRoute.HttpTimeoutProperty | cdk.IResolvable;
    }
}
export declare namespace CfnRoute {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httprouteaction.html
     */
    interface HttpRouteActionProperty {
        /**
         * `CfnRoute.HttpRouteActionProperty.WeightedTargets`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httprouteaction.html#cfn-appmesh-route-httprouteaction-weightedtargets
         */
        readonly weightedTargets: Array<CfnRoute.WeightedTargetProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnRoute {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httprouteheader.html
     */
    interface HttpRouteHeaderProperty {
        /**
         * `CfnRoute.HttpRouteHeaderProperty.Invert`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httprouteheader.html#cfn-appmesh-route-httprouteheader-invert
         */
        readonly invert?: boolean | cdk.IResolvable;
        /**
         * `CfnRoute.HttpRouteHeaderProperty.Match`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httprouteheader.html#cfn-appmesh-route-httprouteheader-match
         */
        readonly match?: CfnRoute.HeaderMatchMethodProperty | cdk.IResolvable;
        /**
         * `CfnRoute.HttpRouteHeaderProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httprouteheader.html#cfn-appmesh-route-httprouteheader-name
         */
        readonly name: string;
    }
}
export declare namespace CfnRoute {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproutematch.html
     */
    interface HttpRouteMatchProperty {
        /**
         * `CfnRoute.HttpRouteMatchProperty.Headers`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproutematch.html#cfn-appmesh-route-httproutematch-headers
         */
        readonly headers?: Array<CfnRoute.HttpRouteHeaderProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnRoute.HttpRouteMatchProperty.Method`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproutematch.html#cfn-appmesh-route-httproutematch-method
         */
        readonly method?: string;
        /**
         * `CfnRoute.HttpRouteMatchProperty.Prefix`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproutematch.html#cfn-appmesh-route-httproutematch-prefix
         */
        readonly prefix: string;
        /**
         * `CfnRoute.HttpRouteMatchProperty.Scheme`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproutematch.html#cfn-appmesh-route-httproutematch-scheme
         */
        readonly scheme?: string;
    }
}
export declare namespace CfnRoute {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httptimeout.html
     */
    interface HttpTimeoutProperty {
        /**
         * `CfnRoute.HttpTimeoutProperty.Idle`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httptimeout.html#cfn-appmesh-route-httptimeout-idle
         */
        readonly idle?: CfnRoute.DurationProperty | cdk.IResolvable;
        /**
         * `CfnRoute.HttpTimeoutProperty.PerRequest`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httptimeout.html#cfn-appmesh-route-httptimeout-perrequest
         */
        readonly perRequest?: CfnRoute.DurationProperty | cdk.IResolvable;
    }
}
export declare namespace CfnRoute {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-matchrange.html
     */
    interface MatchRangeProperty {
        /**
         * `CfnRoute.MatchRangeProperty.End`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-matchrange.html#cfn-appmesh-route-matchrange-end
         */
        readonly end: number;
        /**
         * `CfnRoute.MatchRangeProperty.Start`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-matchrange.html#cfn-appmesh-route-matchrange-start
         */
        readonly start: number;
    }
}
export declare namespace CfnRoute {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-routespec.html
     */
    interface RouteSpecProperty {
        /**
         * `CfnRoute.RouteSpecProperty.GrpcRoute`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-routespec.html#cfn-appmesh-route-routespec-grpcroute
         */
        readonly grpcRoute?: CfnRoute.GrpcRouteProperty | cdk.IResolvable;
        /**
         * `CfnRoute.RouteSpecProperty.Http2Route`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-routespec.html#cfn-appmesh-route-routespec-http2route
         */
        readonly http2Route?: CfnRoute.HttpRouteProperty | cdk.IResolvable;
        /**
         * `CfnRoute.RouteSpecProperty.HttpRoute`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-routespec.html#cfn-appmesh-route-routespec-httproute
         */
        readonly httpRoute?: CfnRoute.HttpRouteProperty | cdk.IResolvable;
        /**
         * `CfnRoute.RouteSpecProperty.Priority`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-routespec.html#cfn-appmesh-route-routespec-priority
         */
        readonly priority?: number;
        /**
         * `CfnRoute.RouteSpecProperty.TcpRoute`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-routespec.html#cfn-appmesh-route-routespec-tcproute
         */
        readonly tcpRoute?: CfnRoute.TcpRouteProperty | cdk.IResolvable;
    }
}
export declare namespace CfnRoute {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-tcproute.html
     */
    interface TcpRouteProperty {
        /**
         * `CfnRoute.TcpRouteProperty.Action`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-tcproute.html#cfn-appmesh-route-tcproute-action
         */
        readonly action: CfnRoute.TcpRouteActionProperty | cdk.IResolvable;
        /**
         * `CfnRoute.TcpRouteProperty.Timeout`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-tcproute.html#cfn-appmesh-route-tcproute-timeout
         */
        readonly timeout?: CfnRoute.TcpTimeoutProperty | cdk.IResolvable;
    }
}
export declare namespace CfnRoute {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-tcprouteaction.html
     */
    interface TcpRouteActionProperty {
        /**
         * `CfnRoute.TcpRouteActionProperty.WeightedTargets`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-tcprouteaction.html#cfn-appmesh-route-tcprouteaction-weightedtargets
         */
        readonly weightedTargets: Array<CfnRoute.WeightedTargetProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnRoute {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-tcptimeout.html
     */
    interface TcpTimeoutProperty {
        /**
         * `CfnRoute.TcpTimeoutProperty.Idle`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-tcptimeout.html#cfn-appmesh-route-tcptimeout-idle
         */
        readonly idle?: CfnRoute.DurationProperty | cdk.IResolvable;
    }
}
export declare namespace CfnRoute {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-weightedtarget.html
     */
    interface WeightedTargetProperty {
        /**
         * `CfnRoute.WeightedTargetProperty.VirtualNode`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-weightedtarget.html#cfn-appmesh-route-weightedtarget-virtualnode
         */
        readonly virtualNode: string;
        /**
         * `CfnRoute.WeightedTargetProperty.Weight`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-weightedtarget.html#cfn-appmesh-route-weightedtarget-weight
         */
        readonly weight: number;
    }
}
/**
 * Properties for defining a `AWS::AppMesh::VirtualNode`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 */
export interface CfnVirtualNodeProps {
    /**
     * `AWS::AppMesh::VirtualNode.MeshName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html#cfn-appmesh-virtualnode-meshname
     */
    readonly meshName: string;
    /**
     * `AWS::AppMesh::VirtualNode.Spec`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html#cfn-appmesh-virtualnode-spec
     */
    readonly spec: CfnVirtualNode.VirtualNodeSpecProperty | cdk.IResolvable;
    /**
     * `AWS::AppMesh::VirtualNode.VirtualNodeName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html#cfn-appmesh-virtualnode-virtualnodename
     */
    readonly virtualNodeName: string;
    /**
     * `AWS::AppMesh::VirtualNode.MeshOwner`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html#cfn-appmesh-virtualnode-meshowner
     */
    readonly meshOwner?: string;
    /**
     * `AWS::AppMesh::VirtualNode.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html#cfn-appmesh-virtualnode-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualNode`
 *
 * @cloudformationResource AWS::AppMesh::VirtualNode
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html
 */
export declare class CfnVirtualNode extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppMesh::VirtualNode";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnVirtualNode;
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @cloudformationAttribute MeshName
     */
    readonly attrMeshName: string;
    /**
     * @cloudformationAttribute MeshOwner
     */
    readonly attrMeshOwner: string;
    /**
     * @cloudformationAttribute ResourceOwner
     */
    readonly attrResourceOwner: string;
    /**
     * @cloudformationAttribute Uid
     */
    readonly attrUid: string;
    /**
     * @cloudformationAttribute VirtualNodeName
     */
    readonly attrVirtualNodeName: string;
    /**
     * `AWS::AppMesh::VirtualNode.MeshName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html#cfn-appmesh-virtualnode-meshname
     */
    meshName: string;
    /**
     * `AWS::AppMesh::VirtualNode.Spec`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html#cfn-appmesh-virtualnode-spec
     */
    spec: CfnVirtualNode.VirtualNodeSpecProperty | cdk.IResolvable;
    /**
     * `AWS::AppMesh::VirtualNode.VirtualNodeName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html#cfn-appmesh-virtualnode-virtualnodename
     */
    virtualNodeName: string;
    /**
     * `AWS::AppMesh::VirtualNode.MeshOwner`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html#cfn-appmesh-virtualnode-meshowner
     */
    meshOwner: string | undefined;
    /**
     * `AWS::AppMesh::VirtualNode.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualnode.html#cfn-appmesh-virtualnode-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::AppMesh::VirtualNode`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVirtualNodeProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnVirtualNode {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-accesslog.html
     */
    interface AccessLogProperty {
        /**
         * `CfnVirtualNode.AccessLogProperty.File`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-accesslog.html#cfn-appmesh-virtualnode-accesslog-file
         */
        readonly file?: CfnVirtualNode.FileAccessLogProperty | cdk.IResolvable;
    }
}
export declare namespace CfnVirtualNode {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-awscloudmapinstanceattribute.html
     */
    interface AwsCloudMapInstanceAttributeProperty {
        /**
         * `CfnVirtualNode.AwsCloudMapInstanceAttributeProperty.Key`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-awscloudmapinstanceattribute.html#cfn-appmesh-virtualnode-awscloudmapinstanceattribute-key
         */
        readonly key: string;
        /**
         * `CfnVirtualNode.AwsCloudMapInstanceAttributeProperty.Value`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-awscloudmapinstanceattribute.html#cfn-appmesh-virtualnode-awscloudmapinstanceattribute-value
         */
        readonly value: string;
    }
}
export declare namespace CfnVirtualNode {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-awscloudmapservicediscovery.html
     */
    interface AwsCloudMapServiceDiscoveryProperty {
        /**
         * `CfnVirtualNode.AwsCloudMapServiceDiscoveryProperty.Attributes`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-awscloudmapservicediscovery.html#cfn-appmesh-virtualnode-awscloudmapservicediscovery-attributes
         */
        readonly attributes?: Array<CfnVirtualNode.AwsCloudMapInstanceAttributeProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnVirtualNode.AwsCloudMapServiceDiscoveryProperty.NamespaceName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-awscloudmapservicediscovery.html#cfn-appmesh-virtualnode-awscloudmapservicediscovery-namespacename
         */
        readonly namespaceName: string;
        /**
         * `CfnVirtualNode.AwsCloudMapServiceDiscoveryProperty.ServiceName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-awscloudmapservicediscovery.html#cfn-appmesh-virtualnode-awscloudmapservicediscovery-servicename
         */
        readonly serviceName: string;
    }
}
export declare namespace CfnVirtualNode {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-backend.html
     */
    interface BackendProperty {
        /**
         * `CfnVirtualNode.BackendProperty.VirtualService`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-backend.html#cfn-appmesh-virtualnode-backend-virtualservice
         */
        readonly virtualService?: CfnVirtualNode.VirtualServiceBackendProperty | cdk.IResolvable;
    }
}
export declare namespace CfnVirtualNode {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-backenddefaults.html
     */
    interface BackendDefaultsProperty {
        /**
         * `CfnVirtualNode.BackendDefaultsProperty.ClientPolicy`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-backenddefaults.html#cfn-appmesh-virtualnode-backenddefaults-clientpolicy
         */
        readonly clientPolicy?: CfnVirtualNode.ClientPolicyProperty | cdk.IResolvable;
    }
}
export declare namespace CfnVirtualNode {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-clientpolicy.html
     */
    interface ClientPolicyProperty {
        /**
         * `CfnVirtualNode.ClientPolicyProperty.TLS`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-clientpolicy.html#cfn-appmesh-virtualnode-clientpolicy-tls
         */
        readonly tls?: CfnVirtualNode.ClientPolicyTlsProperty | cdk.IResolvable;
    }
}
export declare namespace CfnVirtualNode {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-clientpolicytls.html
     */
    interface ClientPolicyTlsProperty {
        /**
         * `CfnVirtualNode.ClientPolicyTlsProperty.Enforce`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-clientpolicytls.html#cfn-appmesh-virtualnode-clientpolicytls-enforce
         */
        readonly enforce?: boolean | cdk.IResolvable;
        /**
         * `CfnVirtualNode.ClientPolicyTlsProperty.Ports`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-clientpolicytls.html#cfn-appmesh-virtualnode-clientpolicytls-ports
         */
        readonly ports?: number[] | cdk.IResolvable;
        /**
         * `CfnVirtualNode.ClientPolicyTlsProperty.Validation`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-clientpolicytls.html#cfn-appmesh-virtualnode-clientpolicytls-validation
         */
        readonly validation: CfnVirtualNode.TlsValidationContextProperty | cdk.IResolvable;
    }
}
export declare namespace CfnVirtualNode {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-dnsservicediscovery.html
     */
    interface DnsServiceDiscoveryProperty {
        /**
         * `CfnVirtualNode.DnsServiceDiscoveryProperty.Hostname`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-dnsservicediscovery.html#cfn-appmesh-virtualnode-dnsservicediscovery-hostname
         */
        readonly hostname: string;
    }
}
export declare namespace CfnVirtualNode {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-duration.html
     */
    interface DurationProperty {
        /**
         * `CfnVirtualNode.DurationProperty.Unit`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-duration.html#cfn-appmesh-virtualnode-duration-unit
         */
        readonly unit: string;
        /**
         * `CfnVirtualNode.DurationProperty.Value`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-duration.html#cfn-appmesh-virtualnode-duration-value
         */
        readonly value: number;
    }
}
export declare namespace CfnVirtualNode {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-fileaccesslog.html
     */
    interface FileAccessLogProperty {
        /**
         * `CfnVirtualNode.FileAccessLogProperty.Path`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-fileaccesslog.html#cfn-appmesh-virtualnode-fileaccesslog-path
         */
        readonly path: string;
    }
}
export declare namespace CfnVirtualNode {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-grpctimeout.html
     */
    interface GrpcTimeoutProperty {
        /**
         * `CfnVirtualNode.GrpcTimeoutProperty.Idle`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-grpctimeout.html#cfn-appmesh-virtualnode-grpctimeout-idle
         */
        readonly idle?: CfnVirtualNode.DurationProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.GrpcTimeoutProperty.PerRequest`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-grpctimeout.html#cfn-appmesh-virtualnode-grpctimeout-perrequest
         */
        readonly perRequest?: CfnVirtualNode.DurationProperty | cdk.IResolvable;
    }
}
export declare namespace CfnVirtualNode {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-healthcheck.html
     */
    interface HealthCheckProperty {
        /**
         * `CfnVirtualNode.HealthCheckProperty.HealthyThreshold`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-healthcheck.html#cfn-appmesh-virtualnode-healthcheck-healthythreshold
         */
        readonly healthyThreshold: number;
        /**
         * `CfnVirtualNode.HealthCheckProperty.IntervalMillis`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-healthcheck.html#cfn-appmesh-virtualnode-healthcheck-intervalmillis
         */
        readonly intervalMillis: number;
        /**
         * `CfnVirtualNode.HealthCheckProperty.Path`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-healthcheck.html#cfn-appmesh-virtualnode-healthcheck-path
         */
        readonly path?: string;
        /**
         * `CfnVirtualNode.HealthCheckProperty.Port`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-healthcheck.html#cfn-appmesh-virtualnode-healthcheck-port
         */
        readonly port?: number;
        /**
         * `CfnVirtualNode.HealthCheckProperty.Protocol`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-healthcheck.html#cfn-appmesh-virtualnode-healthcheck-protocol
         */
        readonly protocol: string;
        /**
         * `CfnVirtualNode.HealthCheckProperty.TimeoutMillis`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-healthcheck.html#cfn-appmesh-virtualnode-healthcheck-timeoutmillis
         */
        readonly timeoutMillis: number;
        /**
         * `CfnVirtualNode.HealthCheckProperty.UnhealthyThreshold`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-healthcheck.html#cfn-appmesh-virtualnode-healthcheck-unhealthythreshold
         */
        readonly unhealthyThreshold: number;
    }
}
export declare namespace CfnVirtualNode {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-httptimeout.html
     */
    interface HttpTimeoutProperty {
        /**
         * `CfnVirtualNode.HttpTimeoutProperty.Idle`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-httptimeout.html#cfn-appmesh-virtualnode-httptimeout-idle
         */
        readonly idle?: CfnVirtualNode.DurationProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.HttpTimeoutProperty.PerRequest`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-httptimeout.html#cfn-appmesh-virtualnode-httptimeout-perrequest
         */
        readonly perRequest?: CfnVirtualNode.DurationProperty | cdk.IResolvable;
    }
}
export declare namespace CfnVirtualNode {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listener.html
     */
    interface ListenerProperty {
        /**
         * `CfnVirtualNode.ListenerProperty.HealthCheck`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listener.html#cfn-appmesh-virtualnode-listener-healthcheck
         */
        readonly healthCheck?: CfnVirtualNode.HealthCheckProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.ListenerProperty.PortMapping`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listener.html#cfn-appmesh-virtualnode-listener-portmapping
         */
        readonly portMapping: CfnVirtualNode.PortMappingProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.ListenerProperty.TLS`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listener.html#cfn-appmesh-virtualnode-listener-tls
         */
        readonly tls?: CfnVirtualNode.ListenerTlsProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.ListenerProperty.Timeout`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listener.html#cfn-appmesh-virtualnode-listener-timeout
         */
        readonly timeout?: CfnVirtualNode.ListenerTimeoutProperty | cdk.IResolvable;
    }
}
export declare namespace CfnVirtualNode {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertimeout.html
     */
    interface ListenerTimeoutProperty {
        /**
         * `CfnVirtualNode.ListenerTimeoutProperty.GRPC`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertimeout.html#cfn-appmesh-virtualnode-listenertimeout-grpc
         */
        readonly grpc?: CfnVirtualNode.GrpcTimeoutProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.ListenerTimeoutProperty.HTTP`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertimeout.html#cfn-appmesh-virtualnode-listenertimeout-http
         */
        readonly http?: CfnVirtualNode.HttpTimeoutProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.ListenerTimeoutProperty.HTTP2`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertimeout.html#cfn-appmesh-virtualnode-listenertimeout-http2
         */
        readonly http2?: CfnVirtualNode.HttpTimeoutProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.ListenerTimeoutProperty.TCP`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertimeout.html#cfn-appmesh-virtualnode-listenertimeout-tcp
         */
        readonly tcp?: CfnVirtualNode.TcpTimeoutProperty | cdk.IResolvable;
    }
}
export declare namespace CfnVirtualNode {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertls.html
     */
    interface ListenerTlsProperty {
        /**
         * `CfnVirtualNode.ListenerTlsProperty.Certificate`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertls.html#cfn-appmesh-virtualnode-listenertls-certificate
         */
        readonly certificate: CfnVirtualNode.ListenerTlsCertificateProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.ListenerTlsProperty.Mode`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertls.html#cfn-appmesh-virtualnode-listenertls-mode
         */
        readonly mode: string;
    }
}
export declare namespace CfnVirtualNode {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertlsacmcertificate.html
     */
    interface ListenerTlsAcmCertificateProperty {
        /**
         * `CfnVirtualNode.ListenerTlsAcmCertificateProperty.CertificateArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertlsacmcertificate.html#cfn-appmesh-virtualnode-listenertlsacmcertificate-certificatearn
         */
        readonly certificateArn: string;
    }
}
export declare namespace CfnVirtualNode {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertlscertificate.html
     */
    interface ListenerTlsCertificateProperty {
        /**
         * `CfnVirtualNode.ListenerTlsCertificateProperty.ACM`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertlscertificate.html#cfn-appmesh-virtualnode-listenertlscertificate-acm
         */
        readonly acm?: CfnVirtualNode.ListenerTlsAcmCertificateProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.ListenerTlsCertificateProperty.File`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertlscertificate.html#cfn-appmesh-virtualnode-listenertlscertificate-file
         */
        readonly file?: CfnVirtualNode.ListenerTlsFileCertificateProperty | cdk.IResolvable;
    }
}
export declare namespace CfnVirtualNode {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertlsfilecertificate.html
     */
    interface ListenerTlsFileCertificateProperty {
        /**
         * `CfnVirtualNode.ListenerTlsFileCertificateProperty.CertificateChain`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertlsfilecertificate.html#cfn-appmesh-virtualnode-listenertlsfilecertificate-certificatechain
         */
        readonly certificateChain: string;
        /**
         * `CfnVirtualNode.ListenerTlsFileCertificateProperty.PrivateKey`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-listenertlsfilecertificate.html#cfn-appmesh-virtualnode-listenertlsfilecertificate-privatekey
         */
        readonly privateKey: string;
    }
}
export declare namespace CfnVirtualNode {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-logging.html
     */
    interface LoggingProperty {
        /**
         * `CfnVirtualNode.LoggingProperty.AccessLog`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-logging.html#cfn-appmesh-virtualnode-logging-accesslog
         */
        readonly accessLog?: CfnVirtualNode.AccessLogProperty | cdk.IResolvable;
    }
}
export declare namespace CfnVirtualNode {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-portmapping.html
     */
    interface PortMappingProperty {
        /**
         * `CfnVirtualNode.PortMappingProperty.Port`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-portmapping.html#cfn-appmesh-virtualnode-portmapping-port
         */
        readonly port: number;
        /**
         * `CfnVirtualNode.PortMappingProperty.Protocol`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-portmapping.html#cfn-appmesh-virtualnode-portmapping-protocol
         */
        readonly protocol: string;
    }
}
export declare namespace CfnVirtualNode {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-servicediscovery.html
     */
    interface ServiceDiscoveryProperty {
        /**
         * `CfnVirtualNode.ServiceDiscoveryProperty.AWSCloudMap`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-servicediscovery.html#cfn-appmesh-virtualnode-servicediscovery-awscloudmap
         */
        readonly awsCloudMap?: CfnVirtualNode.AwsCloudMapServiceDiscoveryProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.ServiceDiscoveryProperty.DNS`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-servicediscovery.html#cfn-appmesh-virtualnode-servicediscovery-dns
         */
        readonly dns?: CfnVirtualNode.DnsServiceDiscoveryProperty | cdk.IResolvable;
    }
}
export declare namespace CfnVirtualNode {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-tcptimeout.html
     */
    interface TcpTimeoutProperty {
        /**
         * `CfnVirtualNode.TcpTimeoutProperty.Idle`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-tcptimeout.html#cfn-appmesh-virtualnode-tcptimeout-idle
         */
        readonly idle?: CfnVirtualNode.DurationProperty | cdk.IResolvable;
    }
}
export declare namespace CfnVirtualNode {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-tlsvalidationcontext.html
     */
    interface TlsValidationContextProperty {
        /**
         * `CfnVirtualNode.TlsValidationContextProperty.Trust`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-tlsvalidationcontext.html#cfn-appmesh-virtualnode-tlsvalidationcontext-trust
         */
        readonly trust: CfnVirtualNode.TlsValidationContextTrustProperty | cdk.IResolvable;
    }
}
export declare namespace CfnVirtualNode {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-tlsvalidationcontextacmtrust.html
     */
    interface TlsValidationContextAcmTrustProperty {
        /**
         * `CfnVirtualNode.TlsValidationContextAcmTrustProperty.CertificateAuthorityArns`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-tlsvalidationcontextacmtrust.html#cfn-appmesh-virtualnode-tlsvalidationcontextacmtrust-certificateauthorityarns
         */
        readonly certificateAuthorityArns: string[];
    }
}
export declare namespace CfnVirtualNode {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-tlsvalidationcontextfiletrust.html
     */
    interface TlsValidationContextFileTrustProperty {
        /**
         * `CfnVirtualNode.TlsValidationContextFileTrustProperty.CertificateChain`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-tlsvalidationcontextfiletrust.html#cfn-appmesh-virtualnode-tlsvalidationcontextfiletrust-certificatechain
         */
        readonly certificateChain: string;
    }
}
export declare namespace CfnVirtualNode {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-tlsvalidationcontexttrust.html
     */
    interface TlsValidationContextTrustProperty {
        /**
         * `CfnVirtualNode.TlsValidationContextTrustProperty.ACM`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-tlsvalidationcontexttrust.html#cfn-appmesh-virtualnode-tlsvalidationcontexttrust-acm
         */
        readonly acm?: CfnVirtualNode.TlsValidationContextAcmTrustProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.TlsValidationContextTrustProperty.File`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-tlsvalidationcontexttrust.html#cfn-appmesh-virtualnode-tlsvalidationcontexttrust-file
         */
        readonly file?: CfnVirtualNode.TlsValidationContextFileTrustProperty | cdk.IResolvable;
    }
}
export declare namespace CfnVirtualNode {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-virtualnodespec.html
     */
    interface VirtualNodeSpecProperty {
        /**
         * `CfnVirtualNode.VirtualNodeSpecProperty.BackendDefaults`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-virtualnodespec.html#cfn-appmesh-virtualnode-virtualnodespec-backenddefaults
         */
        readonly backendDefaults?: CfnVirtualNode.BackendDefaultsProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.VirtualNodeSpecProperty.Backends`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-virtualnodespec.html#cfn-appmesh-virtualnode-virtualnodespec-backends
         */
        readonly backends?: Array<CfnVirtualNode.BackendProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnVirtualNode.VirtualNodeSpecProperty.Listeners`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-virtualnodespec.html#cfn-appmesh-virtualnode-virtualnodespec-listeners
         */
        readonly listeners?: Array<CfnVirtualNode.ListenerProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnVirtualNode.VirtualNodeSpecProperty.Logging`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-virtualnodespec.html#cfn-appmesh-virtualnode-virtualnodespec-logging
         */
        readonly logging?: CfnVirtualNode.LoggingProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.VirtualNodeSpecProperty.ServiceDiscovery`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-virtualnodespec.html#cfn-appmesh-virtualnode-virtualnodespec-servicediscovery
         */
        readonly serviceDiscovery?: CfnVirtualNode.ServiceDiscoveryProperty | cdk.IResolvable;
    }
}
export declare namespace CfnVirtualNode {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-virtualservicebackend.html
     */
    interface VirtualServiceBackendProperty {
        /**
         * `CfnVirtualNode.VirtualServiceBackendProperty.ClientPolicy`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-virtualservicebackend.html#cfn-appmesh-virtualnode-virtualservicebackend-clientpolicy
         */
        readonly clientPolicy?: CfnVirtualNode.ClientPolicyProperty | cdk.IResolvable;
        /**
         * `CfnVirtualNode.VirtualServiceBackendProperty.VirtualServiceName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualnode-virtualservicebackend.html#cfn-appmesh-virtualnode-virtualservicebackend-virtualservicename
         */
        readonly virtualServiceName: string;
    }
}
/**
 * Properties for defining a `AWS::AppMesh::VirtualRouter`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualrouter.html
 */
export interface CfnVirtualRouterProps {
    /**
     * `AWS::AppMesh::VirtualRouter.MeshName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualrouter.html#cfn-appmesh-virtualrouter-meshname
     */
    readonly meshName: string;
    /**
     * `AWS::AppMesh::VirtualRouter.Spec`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualrouter.html#cfn-appmesh-virtualrouter-spec
     */
    readonly spec: CfnVirtualRouter.VirtualRouterSpecProperty | cdk.IResolvable;
    /**
     * `AWS::AppMesh::VirtualRouter.VirtualRouterName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualrouter.html#cfn-appmesh-virtualrouter-virtualroutername
     */
    readonly virtualRouterName: string;
    /**
     * `AWS::AppMesh::VirtualRouter.MeshOwner`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualrouter.html#cfn-appmesh-virtualrouter-meshowner
     */
    readonly meshOwner?: string;
    /**
     * `AWS::AppMesh::VirtualRouter.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualrouter.html#cfn-appmesh-virtualrouter-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualRouter`
 *
 * @cloudformationResource AWS::AppMesh::VirtualRouter
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualrouter.html
 */
export declare class CfnVirtualRouter extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppMesh::VirtualRouter";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnVirtualRouter;
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @cloudformationAttribute MeshName
     */
    readonly attrMeshName: string;
    /**
     * @cloudformationAttribute MeshOwner
     */
    readonly attrMeshOwner: string;
    /**
     * @cloudformationAttribute ResourceOwner
     */
    readonly attrResourceOwner: string;
    /**
     * @cloudformationAttribute Uid
     */
    readonly attrUid: string;
    /**
     * @cloudformationAttribute VirtualRouterName
     */
    readonly attrVirtualRouterName: string;
    /**
     * `AWS::AppMesh::VirtualRouter.MeshName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualrouter.html#cfn-appmesh-virtualrouter-meshname
     */
    meshName: string;
    /**
     * `AWS::AppMesh::VirtualRouter.Spec`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualrouter.html#cfn-appmesh-virtualrouter-spec
     */
    spec: CfnVirtualRouter.VirtualRouterSpecProperty | cdk.IResolvable;
    /**
     * `AWS::AppMesh::VirtualRouter.VirtualRouterName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualrouter.html#cfn-appmesh-virtualrouter-virtualroutername
     */
    virtualRouterName: string;
    /**
     * `AWS::AppMesh::VirtualRouter.MeshOwner`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualrouter.html#cfn-appmesh-virtualrouter-meshowner
     */
    meshOwner: string | undefined;
    /**
     * `AWS::AppMesh::VirtualRouter.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualrouter.html#cfn-appmesh-virtualrouter-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::AppMesh::VirtualRouter`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVirtualRouterProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnVirtualRouter {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualrouter-portmapping.html
     */
    interface PortMappingProperty {
        /**
         * `CfnVirtualRouter.PortMappingProperty.Port`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualrouter-portmapping.html#cfn-appmesh-virtualrouter-portmapping-port
         */
        readonly port: number;
        /**
         * `CfnVirtualRouter.PortMappingProperty.Protocol`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualrouter-portmapping.html#cfn-appmesh-virtualrouter-portmapping-protocol
         */
        readonly protocol: string;
    }
}
export declare namespace CfnVirtualRouter {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualrouter-virtualrouterlistener.html
     */
    interface VirtualRouterListenerProperty {
        /**
         * `CfnVirtualRouter.VirtualRouterListenerProperty.PortMapping`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualrouter-virtualrouterlistener.html#cfn-appmesh-virtualrouter-virtualrouterlistener-portmapping
         */
        readonly portMapping: CfnVirtualRouter.PortMappingProperty | cdk.IResolvable;
    }
}
export declare namespace CfnVirtualRouter {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualrouter-virtualrouterspec.html
     */
    interface VirtualRouterSpecProperty {
        /**
         * `CfnVirtualRouter.VirtualRouterSpecProperty.Listeners`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualrouter-virtualrouterspec.html#cfn-appmesh-virtualrouter-virtualrouterspec-listeners
         */
        readonly listeners: Array<CfnVirtualRouter.VirtualRouterListenerProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::AppMesh::VirtualService`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualservice.html
 */
export interface CfnVirtualServiceProps {
    /**
     * `AWS::AppMesh::VirtualService.MeshName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualservice.html#cfn-appmesh-virtualservice-meshname
     */
    readonly meshName: string;
    /**
     * `AWS::AppMesh::VirtualService.Spec`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualservice.html#cfn-appmesh-virtualservice-spec
     */
    readonly spec: CfnVirtualService.VirtualServiceSpecProperty | cdk.IResolvable;
    /**
     * `AWS::AppMesh::VirtualService.VirtualServiceName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualservice.html#cfn-appmesh-virtualservice-virtualservicename
     */
    readonly virtualServiceName: string;
    /**
     * `AWS::AppMesh::VirtualService.MeshOwner`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualservice.html#cfn-appmesh-virtualservice-meshowner
     */
    readonly meshOwner?: string;
    /**
     * `AWS::AppMesh::VirtualService.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualservice.html#cfn-appmesh-virtualservice-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::AppMesh::VirtualService`
 *
 * @cloudformationResource AWS::AppMesh::VirtualService
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualservice.html
 */
export declare class CfnVirtualService extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppMesh::VirtualService";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnVirtualService;
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @cloudformationAttribute MeshName
     */
    readonly attrMeshName: string;
    /**
     * @cloudformationAttribute MeshOwner
     */
    readonly attrMeshOwner: string;
    /**
     * @cloudformationAttribute ResourceOwner
     */
    readonly attrResourceOwner: string;
    /**
     * @cloudformationAttribute Uid
     */
    readonly attrUid: string;
    /**
     * @cloudformationAttribute VirtualServiceName
     */
    readonly attrVirtualServiceName: string;
    /**
     * `AWS::AppMesh::VirtualService.MeshName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualservice.html#cfn-appmesh-virtualservice-meshname
     */
    meshName: string;
    /**
     * `AWS::AppMesh::VirtualService.Spec`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualservice.html#cfn-appmesh-virtualservice-spec
     */
    spec: CfnVirtualService.VirtualServiceSpecProperty | cdk.IResolvable;
    /**
     * `AWS::AppMesh::VirtualService.VirtualServiceName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualservice.html#cfn-appmesh-virtualservice-virtualservicename
     */
    virtualServiceName: string;
    /**
     * `AWS::AppMesh::VirtualService.MeshOwner`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualservice.html#cfn-appmesh-virtualservice-meshowner
     */
    meshOwner: string | undefined;
    /**
     * `AWS::AppMesh::VirtualService.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-virtualservice.html#cfn-appmesh-virtualservice-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::AppMesh::VirtualService`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVirtualServiceProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnVirtualService {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualservice-virtualnodeserviceprovider.html
     */
    interface VirtualNodeServiceProviderProperty {
        /**
         * `CfnVirtualService.VirtualNodeServiceProviderProperty.VirtualNodeName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualservice-virtualnodeserviceprovider.html#cfn-appmesh-virtualservice-virtualnodeserviceprovider-virtualnodename
         */
        readonly virtualNodeName: string;
    }
}
export declare namespace CfnVirtualService {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualservice-virtualrouterserviceprovider.html
     */
    interface VirtualRouterServiceProviderProperty {
        /**
         * `CfnVirtualService.VirtualRouterServiceProviderProperty.VirtualRouterName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualservice-virtualrouterserviceprovider.html#cfn-appmesh-virtualservice-virtualrouterserviceprovider-virtualroutername
         */
        readonly virtualRouterName: string;
    }
}
export declare namespace CfnVirtualService {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualservice-virtualserviceprovider.html
     */
    interface VirtualServiceProviderProperty {
        /**
         * `CfnVirtualService.VirtualServiceProviderProperty.VirtualNode`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualservice-virtualserviceprovider.html#cfn-appmesh-virtualservice-virtualserviceprovider-virtualnode
         */
        readonly virtualNode?: CfnVirtualService.VirtualNodeServiceProviderProperty | cdk.IResolvable;
        /**
         * `CfnVirtualService.VirtualServiceProviderProperty.VirtualRouter`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualservice-virtualserviceprovider.html#cfn-appmesh-virtualservice-virtualserviceprovider-virtualrouter
         */
        readonly virtualRouter?: CfnVirtualService.VirtualRouterServiceProviderProperty | cdk.IResolvable;
    }
}
export declare namespace CfnVirtualService {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualservice-virtualservicespec.html
     */
    interface VirtualServiceSpecProperty {
        /**
         * `CfnVirtualService.VirtualServiceSpecProperty.Provider`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-virtualservice-virtualservicespec.html#cfn-appmesh-virtualservice-virtualservicespec-provider
         */
        readonly provider?: CfnVirtualService.VirtualServiceProviderProperty | cdk.IResolvable;
    }
}
