# -----------------------------------------------------------------------------
#
# Project: EOxServer <http://eoxserver.org>
# Authors: Stephan Krause <stephan.krause@eox.at>
#          Stephan Meissl <stephan.meissl@eox.at>
#
# -----------------------------------------------------------------------------
# Copyright (C) 2012 EOX IT Services GmbH
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies of this Software or works derived from this Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
# -----------------------------------------------------------------------------

"""
URLs config for EOxServer's {{ project_name }} instance.

"""
try:
    from django.conf.urls import include, url as re_path
except ImportError:
    from django.urls import include, re_path

from django.contrib import admin
import django_prometheus.exports

from eoxserver.views import index


admin.autodiscover()


urlpatterns = [
    re_path(r'^$', index),
    re_path(r'^ows', include("eoxserver.services.urls")),
    re_path(r'^opensearch/', include('eoxserver.services.opensearch.urls')),

    # enable the coverage URLs
    re_path(r'^coverages/', include('eoxserver.resources.coverages.urls')),

    # enable the client
    re_path(r'^client/', include('eoxserver.webclient.urls')),

    # Enable admin documentation:
    re_path(r'^admin/doc/', include('django.contrib.admindocs.urls')),
    # Enable the admin:
    re_path(r'^admin/', admin.site.urls),
    re_path(
        r'^metrics$',
        django_prometheus.exports.ExportToDjangoView,
        name="prometheus-django-metrics",
    ),
]
