"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Instance = exports.InstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const elasticsearch_generated_1 = require("./elasticsearch.generated");
Object.defineProperty(exports, "InstanceProperty", { enumerable: true, get: function () { return elasticsearch_generated_1.RosInstance; } });
/**
 * A ROS resource type:  `ALIYUN::ElasticSearch::Instance`
 */
class Instance extends ros.Resource {
    /**
     * Create a new `ALIYUN::ElasticSearch::Instance`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosInstance = new elasticsearch_generated_1.RosInstance(this, id, {
            masterNode: props.masterNode,
            description: props.description,
            kibanaNode: props.kibanaNode,
            zoneId: props.zoneId,
            resourceGroupId: props.resourceGroupId,
            enableKibanaPrivate: props.enableKibanaPrivate,
            publicWhitelist: props.publicWhitelist,
            enableKibanaPublic: props.enableKibanaPublic,
            instanceChargeType: props.instanceChargeType === undefined || props.instanceChargeType === null ? 'PostPaid' : props.instanceChargeType,
            vSwitchId: props.vSwitchId,
            period: props.period === undefined || props.period === null ? 1 : props.period,
            enablePublic: props.enablePublic,
            privateWhitelist: props.privateWhitelist,
            version: props.version,
            dataNode: props.dataNode,
            kibanaWhitelist: props.kibanaWhitelist,
            ymlConfig: props.ymlConfig,
            tags: props.tags,
            zoneCount: props.zoneCount,
            password: props.password,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosInstance;
        this.attrDomain = rosInstance.attrDomain;
        this.attrInstanceChargeType = rosInstance.attrInstanceChargeType;
        this.attrInstanceId = rosInstance.attrInstanceId;
        this.attrKibanaDomain = rosInstance.attrKibanaDomain;
        this.attrKibanaPort = rosInstance.attrKibanaPort;
        this.attrPort = rosInstance.attrPort;
        this.attrPublicDomain = rosInstance.attrPublicDomain;
        this.attrStatus = rosInstance.attrStatus;
        this.attrVSwitchId = rosInstance.attrVSwitchId;
        this.attrVersion = rosInstance.attrVersion;
    }
}
exports.Instance = Instance;
//# sourceMappingURL=data:application/json;base64,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