/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Calendar;
import oracle.pgx.api.PgxPreparedStatement;
import oracle.pgx.api.PgxSession;
import oracle.pgx.jdbc.ResultSetWrapper;
import oracle.pgx.jdbc.StatementWrapper;
import oracle.pgx.jdbc.Util;
import oracle.pgx.jdbc.compat.CompatMode;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPTZ;

public class PreparedStatementWrapper
extends StatementWrapper
implements PreparedStatement {
    private final PgxPreparedStatement ps;
    private ResultSet resultSet;
    private boolean closed = false;

    PreparedStatementWrapper(Connection connection, PgxSession session, PgxPreparedStatement ps, CompatMode compat) {
        super(connection, session, compat);
        this.ps = ps;
    }

    private void setResultSet(ResultSet newResultSet) throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.close();
        }
        this.resultSet = newResultSet;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        throw new SQLFeatureNotSupportedException("use ResultSet#getMetaData instead");
    }

    @Override
    public boolean execute() throws SQLException {
        return Util.invokePgxApi(() -> this.ps.execute());
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        ResultSet resultSet = Util.invokePgxApi(() -> new ResultSetWrapper(this, this.compat, this.ps.getResultSet()));
        this.setResultSet(resultSet);
        return resultSet;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        ResultSet resultSet = Util.invokePgxApi(() -> new ResultSetWrapper(this, this.compat, this.ps.executeQuery()));
        this.setResultSet(resultSet);
        return resultSet;
    }

    @Override
    public int executeUpdate() throws SQLException {
        throw new SQLFeatureNotSupportedException("use execute() instead");
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        Util.invokePgxApi(() -> {
            this.ps.setBoolean(parameterIndex, x);
            return null;
        });
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        Util.invokePgxApi(() -> {
            this.ps.setInt(parameterIndex, x);
            return null;
        });
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        Util.invokePgxApi(() -> {
            this.ps.setLong(parameterIndex, x);
            return null;
        });
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        Util.invokePgxApi(() -> {
            this.ps.setFloat(parameterIndex, x);
            return null;
        });
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        Util.invokePgxApi(() -> {
            this.ps.setDouble(parameterIndex, x);
            return null;
        });
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        Util.invokePgxApi(() -> {
            this.ps.setString(parameterIndex, x);
            return null;
        });
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        Util.invokePgxApi(() -> {
            LocalDate date = null;
            if (x != null) {
                date = x.toLocalDate();
            }
            this.ps.setDate(parameterIndex, date);
            return null;
        });
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        Util.invokePgxApi(() -> {
            LocalTime time = null;
            if (x != null) {
                time = x.toLocalTime();
            }
            this.ps.setTime(parameterIndex, time);
            return null;
        });
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        Util.invokePgxApi(() -> {
            LocalDateTime dateTime = null;
            if (x != null) {
                dateTime = x.toLocalDateTime();
            }
            this.ps.setTimestamp(parameterIndex, dateTime);
            return null;
        });
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (x == null) {
            throw new SQLException("NULL not supported");
        }
        if (x.getClass() == String.class) {
            this.setString(parameterIndex, (String)x);
            return;
        }
        if (x.getClass() == Boolean.class) {
            this.setBoolean(parameterIndex, (Boolean)x);
            return;
        }
        if (x.getClass() == Integer.class) {
            this.setInt(parameterIndex, (Integer)x);
            return;
        }
        if (x.getClass() == Float.class) {
            this.setFloat(parameterIndex, ((Float)x).floatValue());
            return;
        }
        if (x.getClass() == Long.class) {
            this.setLong(parameterIndex, (Long)x);
            return;
        }
        if (x.getClass() == Double.class) {
            this.setDouble(parameterIndex, (Double)x);
            return;
        }
        if (x.getClass() == BigDecimal.class) {
            this.setDouble(parameterIndex, ((BigDecimal)x).doubleValue());
            return;
        }
        if (x.getClass() == Date.class) {
            this.setDate(parameterIndex, (Date)x);
            return;
        }
        if (x.getClass() == LocalDate.class) {
            Util.invokePgxApi(() -> {
                this.ps.setDate(parameterIndex, (LocalDate)x);
                return null;
            });
            return;
        }
        if (x.getClass() == Time.class) {
            this.setTime(parameterIndex, (Time)x);
            return;
        }
        if (x.getClass() == LocalTime.class) {
            Util.invokePgxApi(() -> {
                this.ps.setTime(parameterIndex, (LocalTime)x);
                return null;
            });
            return;
        }
        if (x.getClass() == OffsetTime.class) {
            Util.invokePgxApi(() -> {
                this.ps.setTimeWithTimezone(parameterIndex, (OffsetTime)x);
                return null;
            });
            return;
        }
        if (x.getClass() == Timestamp.class) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
            return;
        }
        if (x.getClass() == LocalDateTime.class) {
            Util.invokePgxApi(() -> {
                this.ps.setTimestamp(parameterIndex, (LocalDateTime)x);
                return null;
            });
            return;
        }
        if (x.getClass() == TIMESTAMP.class) {
            this.setTimestamp(parameterIndex, ((TIMESTAMP)x).timestampValue());
            return;
        }
        if (x.getClass() == OffsetDateTime.class) {
            Util.invokePgxApi(() -> {
                this.ps.setTimestampWithTimezone(parameterIndex, (OffsetDateTime)x);
                return null;
            });
            return;
        }
        if (x.getClass() == TIMESTAMPTZ.class) {
            Util.invokePgxApi(() -> {
                TIMESTAMPTZ ts = (TIMESTAMPTZ)x;
                OffsetDateTime dateTime = Util.toOffsetDateTime(ts.toBytes());
                this.ps.setTimestampWithTimezone(parameterIndex, dateTime);
                return null;
            });
            return;
        }
        throw new SQLException("unsupported type: " + x.getClass());
    }

    @Override
    public void close() throws SQLException {
        super.close();
        Util.invokePgxApi(() -> {
            this.ps.close();
            if (this.resultSet != null && !this.resultSet.isClosed()) {
                this.resultSet.close();
            }
            return null;
        });
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface == PgxPreparedStatement.class || iface == PgxSession.class;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface == PgxPreparedStatement.class) {
            return (T)this.ps;
        }
        if (iface == PgxSession.class) {
            return (T)this.wrapped;
        }
        return null;
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void clearParameters() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void addBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

