/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.sqlpgq;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import oracle.pg.rdbms.sqlpgq.SqlPgqMetadata;
import oracle.pgx.graphviz.formatter.Property;
import oracle.pgx.graphviz.library.graph.Edge;
import oracle.pgx.graphviz.library.graph.Graph;
import oracle.pgx.graphviz.library.graph.Vertex;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlPgqGraphBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(SqlPgqGraphBuilder.class);
    @Nonnull
    private SqlPgqMetadata metadata;
    @Nonnull
    private Set<oracle.pgx.graphviz.formatter.Vertex> vertices = Collections.emptySet();
    @Nonnull
    private Set<oracle.pgx.graphviz.formatter.Edge> edges = Collections.emptySet();
    private Map<String, oracle.pgx.graphviz.formatter.Vertex> cacheForVertices = new HashMap<String, oracle.pgx.graphviz.formatter.Vertex>();
    private Map<String, oracle.pgx.graphviz.formatter.Edge> cacheForEdges = new HashMap<String, oracle.pgx.graphviz.formatter.Edge>();
    private Set<String> allVertexProperties;
    private Set<String> allEdgeProperties;

    public SqlPgqGraphBuilder(SqlPgqMetadata metadata) {
        this.metadata = metadata;
        this.allVertexProperties = metadata.getAllVertexProperties();
        this.allEdgeProperties = metadata.getAllEdgeProperties();
    }

    public oracle.pgx.graphviz.formatter.Graph build() throws SQLException {
        this.createVertices();
        this.createEdges();
        return new Graph(this.vertices, this.edges, Collections.emptySet());
    }

    private List<Property> getProperties(ResultSet rs, Set<String> entityProperties) throws SQLException {
        ArrayList<Property> properties = new ArrayList<Property>();
        for (String property : entityProperties) {
            String value = rs.getString(property);
            if (value == null || property.startsWith("ID_") || value.equals("null")) continue;
            properties.add((Property)new oracle.pgx.graphviz.library.graph.Property(property, (Object)value, false));
        }
        return properties;
    }

    private void createVertex(ResultSet rs, String vertexName) throws SQLException {
        String id = rs.getString(vertexName);
        ArrayList<Property> properties = new ArrayList<Property>();
        HashSet<String> labels = new HashSet<String>();
        HashSet<String> groups = new HashSet<String>();
        if (this.cacheForVertices.containsKey(id)) {
            oracle.pgx.graphviz.formatter.Vertex originalVertex = this.cacheForVertices.get(id);
            properties.addAll(originalVertex.getProperties());
            labels.addAll(originalVertex.getLabels());
            groups.addAll(originalVertex.getGroups());
        }
        properties.addAll(this.getProperties(rs, this.allVertexProperties));
        labels.add(rs.getString("label"));
        groups.add(vertexName);
        Vertex vertex = new Vertex((Object)id, labels, properties, groups);
        this.cacheForVertices.put(id, (oracle.pgx.graphviz.formatter.Vertex)vertex);
    }

    public void createVertices() throws SQLException {
        Map<String, String> vertexQueries = this.metadata.getVertexQueries();
        for (Map.Entry<String, String> entry : vertexQueries.entrySet()) {
            String vertexName = entry.getKey();
            String query = entry.getValue();
            LOG.debug("Vertex query: {} = {}", (Object)vertexName, (Object)query);
            Connection conn = this.metadata.getConnection();
            PreparedStatement preparedStatement = conn.prepareStatement(query);
            try {
                ResultSet rs = preparedStatement.executeQuery();
                try {
                    while (rs.next()) {
                        this.createVertex(rs, vertexName);
                    }
                }
                finally {
                    if (rs == null) continue;
                    rs.close();
                }
            }
            finally {
                if (preparedStatement == null) continue;
                preparedStatement.close();
            }
        }
        this.vertices = new HashSet<oracle.pgx.graphviz.formatter.Vertex>(this.cacheForVertices.values());
    }

    private void createEdge(ResultSet rs, String edgeName) throws SQLException {
        String id = "";
        try {
            Object value = rs.getObject(edgeName);
            if (value instanceof InputStream) {
                id = IOUtils.toString((InputStream)((InputStream)value), (Charset)StandardCharsets.UTF_8);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        HashSet<String> labels = new HashSet<String>();
        HashSet<String> groups = new HashSet<String>();
        List<Property> properties = this.getProperties(rs, this.allEdgeProperties);
        String sourceId = rs.getString("srcid");
        String destinationId = rs.getString("dstid");
        if (this.cacheForVertices.containsKey(sourceId) && this.cacheForVertices.containsKey(destinationId)) {
            labels.add(rs.getString("label"));
            groups.add(edgeName);
            Edge edge = new Edge((Object)id, (Object)sourceId, (Object)destinationId, false, labels, properties, groups);
            this.cacheForEdges.put(id, (oracle.pgx.graphviz.formatter.Edge)edge);
        }
    }

    public void createEdges() throws SQLException {
        Map<String, String> edgeQueries = this.metadata.getEdgeQueries();
        for (Map.Entry<String, String> entry : edgeQueries.entrySet()) {
            String edgeName = entry.getKey();
            String query = entry.getValue();
            Connection conn = this.metadata.getConnection();
            PreparedStatement preparedStatement = conn.prepareStatement(query);
            try {
                LOG.debug("Edge query: {} = {}", (Object)edgeName, (Object)query);
                ResultSet rs = preparedStatement.executeQuery();
                try {
                    while (rs.next()) {
                        this.createEdge(rs, edgeName);
                    }
                }
                finally {
                    if (rs == null) continue;
                    rs.close();
                }
            }
            finally {
                if (preparedStatement == null) continue;
                preparedStatement.close();
            }
        }
        this.edges = new HashSet<oracle.pgx.graphviz.formatter.Edge>(this.cacheForEdges.values());
    }
}

