/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal.synchronizer;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import oracle.pgx.api.internal.synchronizer.PartitionedDataSourceVersion;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.common.util.JsonUtil;

public class FlashbackScnData {
    private Map<String, Long> lastFetchedScnMapVertices;
    private Map<String, Long> lastFetchedScnMapEdges;
    private Map<String, Long> lastSuccessfulScnMapVertices = new HashMap<String, Long>();
    private Map<String, Long> lastSuccessfulScnMapEdges = new HashMap<String, Long>();

    public FlashbackScnData(Map<String, Long> lastFetchedScnMapVertices, Map<String, Long> lastFetchedScnMapEdges) {
        this.lastFetchedScnMapVertices = lastFetchedScnMapVertices;
        this.lastFetchedScnMapEdges = lastFetchedScnMapEdges;
    }

    public Map<String, Long> getLastFetchedScnMapVertices() {
        return this.lastFetchedScnMapVertices;
    }

    public Map<String, Long> getLastFetchedScnMapEdges() {
        return this.lastFetchedScnMapEdges;
    }

    public Map<String, Long> getLastSuccessfulScnMapVertices() {
        return this.lastSuccessfulScnMapVertices;
    }

    public Map<String, Long> getLastSuccessfulScnMapEdges() {
        return this.lastSuccessfulScnMapEdges;
    }

    public long getLastFetchedScnForVertexProvider(String provider) {
        return this.lastFetchedScnMapVertices.get(provider);
    }

    public long getLastFetchedScnForEdgeProvider(String provider) {
        return this.lastFetchedScnMapEdges.get(provider);
    }

    public void updateLastFetchedScnMaps(Long nextScn) {
        for (String key : this.lastFetchedScnMapEdges.keySet()) {
            this.lastFetchedScnMapEdges.put(key, nextScn);
        }
        for (String key : this.lastFetchedScnMapVertices.keySet()) {
            this.lastFetchedScnMapVertices.put(key, nextScn);
        }
    }

    public void updateLastSuccesfulScnMaps(Long nextScn) {
        for (String key : this.lastSuccessfulScnMapEdges.keySet()) {
            this.lastSuccessfulScnMapEdges.put(key, nextScn);
        }
        for (String key : this.lastSuccessfulScnMapVertices.keySet()) {
            this.lastSuccessfulScnMapVertices.put(key, nextScn);
        }
    }

    public void rollbackLastFetchedScnMaps() {
        this.lastFetchedScnMapEdges = new HashMap<String, Long>(this.lastSuccessfulScnMapEdges);
        this.lastFetchedScnMapVertices = new HashMap<String, Long>(this.lastSuccessfulScnMapVertices);
    }

    public void commitFetchedScn() {
        this.lastSuccessfulScnMapEdges = new HashMap<String, Long>(this.lastFetchedScnMapEdges);
        this.lastSuccessfulScnMapVertices = new HashMap<String, Long>(this.lastFetchedScnMapVertices);
    }

    public static FlashbackScnData getSynchronizerScnData(String dataSourceVersion) {
        try {
            PartitionedDataSourceVersion partitionedDataSourceVersion = (PartitionedDataSourceVersion)JsonUtil.readTopLevelJson((String)dataSourceVersion, PartitionedDataSourceVersion.class);
            if (partitionedDataSourceVersion == null) {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"GRAPH_NOT_SYNCHRONIZABLE_NO_SCN_DATA", (Object[])new Object[0]));
            }
            FlashbackScnData.validateDataSourceVersions(partitionedDataSourceVersion.getVertexProviders());
            FlashbackScnData.validateDataSourceVersions(partitionedDataSourceVersion.getEdgeProviders());
            return new FlashbackScnData(partitionedDataSourceVersion.getVertexProviders(), partitionedDataSourceVersion.getEdgeProviders());
        }
        catch (IOException e) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"CANNOT_READ_SCN_FROM_PROVIDER", (Object[])new Object[]{dataSourceVersion}), e);
        }
    }

    private static void validateDataSourceVersions(Map<String, Long> versions) {
        if (versions == null || versions.values().stream().anyMatch(Objects::isNull)) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"GRAPH_NOT_SYNCHRONIZABLE_NO_SCN_DATA", (Object[])new Object[0]));
        }
    }
}

