/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.executionenvironment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.PoolType;
import oracle.pgx.api.executionenvironment.ExecutionEnvironmentField;
import oracle.pgx.api.internal.ApiObject;
import oracle.pgx.api.internal.CoreSessionApi;

abstract class AbstractEnvironment
extends ApiObject {
    protected final PgxSession session;
    protected final PoolType poolType;
    private final CoreSessionApi coreSessionApi;

    AbstractEnvironment(PgxSession session, CoreSessionApi coreSessionApi, PoolType poolType) {
        this.session = session;
        this.coreSessionApi = coreSessionApi;
        this.poolType = poolType;
    }

    static <T, I> PgxFuture<T> withValueAsync(I updatedValue, Supplier<PgxFuture<I>> getOldValue, Function<I, PgxFuture<Void>> setter, Supplier<PgxFuture<T>> asyncSupplier) {
        AtomicReference oldValue = new AtomicReference();
        return ((PgxFuture)((PgxFuture)((PgxFuture)getOldValue.get().thenAccept(oldValue::set)).thenCompose(aVoid -> (CompletionStage)setter.apply(updatedValue))).thenCompose(aVoid -> (CompletionStage)asyncSupplier.get())).thenApply(result -> {
            setter.apply(oldValue.get());
            return result;
        });
    }

    protected abstract ExecutionEnvironmentField[] getRelevantFields();

    public final PgxFuture<Map<String, Object>> getValuesAsync() {
        Map values = Collections.synchronizedMap(new HashMap());
        ArrayList futures = new ArrayList();
        for (ExecutionEnvironmentField relevantField : this.getRelevantFields()) {
            String fieldName = relevantField.toString().toLowerCase();
            CompletableFuture valuesFuture = this.getEnvironmentAsync(relevantField, Object.class).thenAccept(value -> values.put(fieldName, value));
            futures.add(valuesFuture);
        }
        return PgxFuture.allOf(futures).thenApply(aVoid -> values);
    }

    final <T> PgxFuture<T> getEnvironmentAsync(ExecutionEnvironmentField field, Class<T> expectedClass) {
        return this.coreSessionApi.getExecutionEnvironment(this.session.getSessionContext(), this.poolType, field).thenApply(expectedClass::cast);
    }

    final <T> PgxFuture<Void> setEnvironmentAsync(ExecutionEnvironmentField field, T value) {
        field.verify(value);
        return this.coreSessionApi.updateExecutionEnvironment(this.session.getSessionContext(), this.poolType, field, value);
    }

    public final PgxFuture<Void> resetAsync() {
        LinkedList futureList = new LinkedList();
        for (ExecutionEnvironmentField executionEnvironmentField : this.getRelevantFields()) {
            futureList.add(this.setEnvironmentAsync(executionEnvironmentField, null));
        }
        return PgxFuture.allOf(futureList);
    }

    public final void reset() throws ExecutionException, InterruptedException {
        this.resetAsync().get();
    }

    public final Map<String, Object> getValues() throws ExecutionException, InterruptedException {
        return this.getValuesAsync().get();
    }

    public String toString() {
        return this.toString(AbstractEnvironment.entry("pool", (Object)this.poolType));
    }
}

