/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms.io.binary;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.nio.charset.Charset;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.ParseError;
import org.spoofax.terms.io.TAFTermReader;
import org.spoofax.terms.io.binary.BAFReader;
import org.spoofax.terms.io.binary.SAFReader;
import org.spoofax.terms.util.IOStreamExt;

public class TermReader
extends TAFTermReader {
    public TermReader(ITermFactory factory) {
        super(factory);
    }

    @Override
    public IStrategoTerm read(InputStream inputStream, Charset characterSet) throws IOException {
        BufferedInputStream bis = IOStreamExt.ensureBuffered(inputStream);
        if (BAFReader.isBinaryATerm(bis)) {
            return new BAFReader(this.factory, bis).readFromBinaryFile(true);
        }
        if (SAFReader.isStreamingATerm(bis)) {
            return SAFReader.readTermFromSAFStream(this.factory, bis);
        }
        PushbackReader pr = new PushbackReader(new InputStreamReader((InputStream)bis, characterSet));
        return super.parseFromStream(pr);
    }

    @Override
    public IStrategoTerm parseFromStream(InputStream inputStream) throws IOException, ParseError {
        try {
            IStrategoTerm iStrategoTerm = this.read(inputStream);
            return iStrategoTerm;
        }
        finally {
            inputStream.close();
        }
    }
}

