/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.log;

import java.io.IOException;
import java.io.OutputStream;
import java.util.regex.Pattern;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.Level;

public class LoggingOutputStream
extends OutputStream {
    private static final int initialBufferLength = 2048;
    private final ILogger logger;
    private final Level level;
    private final Pattern[] excludePatterns;
    private boolean closed = false;
    private byte[] buffer;
    private int count;

    public LoggingOutputStream(ILogger logger, Level level, String ... excludePatterns) throws IllegalArgumentException {
        this.level = level;
        this.logger = logger;
        this.excludePatterns = new Pattern[excludePatterns.length];
        int i = 0;
        while (i < excludePatterns.length) {
            this.excludePatterns[i] = Pattern.compile(excludePatterns[i], 32);
            ++i;
        }
        this.buffer = new byte[2048];
        this.count = 0;
    }

    @Override
    public void close() {
        this.flush();
        this.closed = true;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("The stream has been closed");
        }
        switch (b) {
            case 10: {
                this.doFlush();
                return;
            }
            case 0: 
            case 13: {
                return;
            }
        }
        if (this.count == this.buffer.length) {
            int newBufLength = this.buffer.length + 2048;
            byte[] newBuf = new byte[newBufLength];
            System.arraycopy(this.buffer, 0, newBuf, 0, this.buffer.length);
            this.buffer = newBuf;
        }
        this.buffer[this.count] = (byte)b;
        ++this.count;
    }

    @Override
    public void flush() {
    }

    private void doFlush() {
        try {
            String message = new String(this.buffer, 0, this.count);
            Pattern[] patternArray = this.excludePatterns;
            int n = this.excludePatterns.length;
            int n2 = 0;
            while (n2 < n) {
                Pattern pattern = patternArray[n2];
                if (pattern.matcher(message).matches()) {
                    return;
                }
                ++n2;
            }
            this.logger.log(this.level, message);
        }
        finally {
            this.count = 0;
        }
    }
}

