/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.collection;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class BiMap2<K, V>
implements Serializable {
    public static final long serialVersionUID = 1L;
    private final Map<K, V> fwd;
    private final Map<V, K> bwd;

    public BiMap2() {
        this(new LinkedHashMap(), new LinkedHashMap());
    }

    protected BiMap2(Map<K, V> fwd, Map<V, K> bwd) {
        this.fwd = fwd;
        this.bwd = bwd;
    }

    public BiMap2(BiMap2<K, V> toCopy) {
        this(new LinkedHashMap<K, V>(toCopy.fwd), new LinkedHashMap<V, K>(toCopy.bwd));
    }

    public boolean containsKey(K key) {
        return this.fwd.containsKey(key);
    }

    public boolean containsValue(V value) {
        return this.bwd.containsKey(value);
    }

    public boolean containsEntry(K key, V value) {
        return this.fwd.containsKey(key) && this.get(key).equals(value);
    }

    public int size() {
        return this.fwd.size();
    }

    public boolean isEmpty() {
        return this.fwd.isEmpty();
    }

    public V get(K key) {
        return this.getValue(key);
    }

    public K getKey(V value) {
        return this.bwd.get(value);
    }

    public V getValue(K key) {
        return this.fwd.get(key);
    }

    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.fwd.keySet());
    }

    public Set<V> valueSet() {
        return Collections.unmodifiableSet(this.bwd.keySet());
    }

    public Set<V> values() {
        return this.valueSet();
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return Collections.unmodifiableSet(this.fwd.entrySet());
    }

    public Map<K, V> asMap() {
        return Collections.unmodifiableMap(this.fwd);
    }

    public V remove(K key) {
        if (!this.containsKey(key)) {
            return null;
        }
        V removed = this.fwd.remove(key);
        K removedKey = this.bwd.remove(removed);
        assert (key.equals(removedKey)) : "BiMap2 maps got desynchronised.";
        return removed;
    }

    public boolean remove(K key, V value) {
        boolean fwdRemoval = this.fwd.remove(key, value);
        boolean bwdRemoval = this.bwd.remove(value, key);
        assert (fwdRemoval == bwdRemoval) : "BiMap2 maps got desynchronised.";
        return fwdRemoval;
    }

    public K removeValue(V value) {
        if (!this.containsValue(value)) {
            return null;
        }
        K removed = this.bwd.remove(value);
        V removedValue = this.fwd.remove(removed);
        assert (value.equals(removedValue)) : "BiMap2 maps got desynchronised.";
        return removed;
    }

    public V put(K key, V value) {
        if (this.containsEntry(key, value)) {
            return value;
        }
        if (this.bwd.containsKey(value)) {
            throw new IllegalArgumentException("Value already present.");
        }
        V oldValue = this.fwd.put(key, value);
        if (oldValue != null) {
            boolean removed = this.bwd.remove(oldValue, key);
            assert (removed) : "BiMap2 maps got desynchronised.";
        }
        this.bwd.put(value, key);
        return oldValue;
    }

    public boolean putAll(BiMap2<K, V> other) {
        return this.putAll(other.entrySet());
    }

    public boolean putAll(Iterable<Map.Entry<K, V>> entries) {
        boolean changed = false;
        for (Map.Entry<K, V> e : entries) {
            changed |= this.put(e.getKey(), e.getValue()) != null;
        }
        return changed;
    }

    public V replace(K key, V value) {
        if (!this.fwd.containsKey(key)) {
            return null;
        }
        return this.put(key, value);
    }

    public BiMap2<V, K> inverse() {
        return new BiMap2<V, K>(this.bwd, this.fwd);
    }

    public void clear() {
        this.fwd.clear();
        this.bwd.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BiMap2 biMap2 = (BiMap2)o;
        return this.fwd.equals(biMap2.fwd);
    }

    public int hashCode() {
        return this.fwd.hashCode();
    }

    public String toString() {
        return this.fwd.toString();
    }
}

