/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.context;

import com.google.inject.Injector;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.core.context.ContextException;
import org.metaborg.core.context.ContextFacet;
import org.metaborg.core.context.ContextIdentifier;
import org.metaborg.core.context.IContext;
import org.metaborg.core.context.IContextFactory;
import org.metaborg.core.context.IContextInternal;
import org.metaborg.core.context.IContextProcessor;
import org.metaborg.core.context.IContextService;
import org.metaborg.core.context.ITemporaryContext;
import org.metaborg.core.context.ITemporaryContextInternal;
import org.metaborg.core.context.NullContext;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.language.LanguageImplChange;
import org.metaborg.core.project.IProject;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;

public class ContextService
implements IContextService,
IContextProcessor {
    private static final ILogger logger = LoggerUtils.logger(ContextService.class);
    private final Injector injector;
    private final ConcurrentMap<ContextIdentifier, IContextInternal> idToContext = new ConcurrentHashMap<ContextIdentifier, IContextInternal>();
    private final ConcurrentMap<ILanguageImpl, ContextIdentifier> langToContextId = new ConcurrentHashMap<ILanguageImpl, ContextIdentifier>();
    private final ConcurrentMap<ILanguageImpl, Set<ContextIdentifier>> langToDownstreamContextIds = new ConcurrentHashMap<ILanguageImpl, Set<ContextIdentifier>>();

    @Inject
    public ContextService(Injector injector) {
        this.injector = injector;
    }

    @Override
    public IContext get(FileObject resource, IProject project, ILanguageImpl language) throws ContextException {
        if (this.available(language)) {
            ContextFacet facet = this.getFacet(resource, language);
            ContextIdentifier identifier = facet.strategy.get(resource, project, language);
            return this.getOrCreate(facet.factory, identifier);
        }
        return this.createNullContext(project, language);
    }

    @Override
    public ITemporaryContext getTemporary(FileObject resource, IProject project, ILanguageImpl language) throws ContextException {
        if (this.available(language)) {
            ContextIdentifier identifier;
            ContextFacet facet = this.getFacet(resource, language);
            try {
                identifier = facet.strategy.get(resource, project, language);
            }
            catch (ContextException e) {
                logger.debug("Could not create a context via context strategy of language {} (see exception), creating context with given resource {} instead", e, language, resource);
                identifier = new ContextIdentifier(resource, project, language);
            }
            return this.createTemporary(facet.factory, identifier);
        }
        return this.createNullContext(project, language);
    }

    @Override
    public void unload(IContext context) {
        IContextInternal contextInternal = (IContextInternal)context;
        contextInternal.unload();
        ContextIdentifier identifier = contextInternal.identifier();
        this.idToContext.remove(identifier);
        this.langToContextId.remove(identifier.language);
    }

    @Override
    public void update(LanguageImplChange change) {
        switch (change.kind) {
            case Remove: {
                IContextInternal removed;
                ContextIdentifier removedId = (ContextIdentifier)this.langToContextId.remove(change.impl);
                if (removedId == null || (removed = (IContextInternal)this.idToContext.remove(removedId)) == null) break;
                removed.unload();
                logger.debug("Removing {}", removed);
                break;
            }
            case Reload: {
                for (ContextIdentifier reloadedId : this.getLangToDownstreamContextId(change)) {
                    IContextInternal reloaded = (IContextInternal)this.idToContext.remove(reloadedId);
                    if (reloaded == null) continue;
                    try {
                        reloaded.reset();
                        logger.debug("Resetting {}", reloaded);
                    }
                    catch (IOException e) {
                        logger.debug("Resetting {} failed.", e, reloaded);
                    }
                }
                break;
            }
        }
    }

    private boolean available(ILanguageImpl language) {
        ContextFacet facet = language.facet(ContextFacet.class);
        return facet != null;
    }

    private ContextFacet getFacet(FileObject resource, ILanguageImpl language) throws ContextException {
        ContextFacet facet = language.facet(ContextFacet.class);
        if (facet == null) {
            String message = logger.format("Cannot get a context, {} does not have a context facet", language);
            throw new ContextException(resource, language, message);
        }
        return facet;
    }

    private IContextInternal getOrCreate(IContextFactory factory, ContextIdentifier identifier) {
        IContextInternal newContext = this.create(factory, identifier);
        IContextInternal prevContext = this.idToContext.putIfAbsent(identifier, newContext);
        this.langToContextId.putIfAbsent(identifier.language, identifier);
        this.putLangToDownstreamContextId(identifier, newContext.language());
        if (prevContext == null) {
            return newContext;
        }
        if (!prevContext.getClass().equals(newContext.getClass())) {
            logger.info("Context for {} changed type, ignoring existing context.", identifier);
            if (this.idToContext.replace(identifier, prevContext, newContext)) {
                try {
                    prevContext.reset();
                }
                catch (IOException e) {
                    logger.warn("Error occurred while resetting {}", prevContext, e);
                }
            } else {
                logger.warn("Race condition while replacing context {} with {}", prevContext, newContext);
            }
            this.removeLangToDownstreamContextId(identifier, prevContext.language());
            return newContext;
        }
        return prevContext;
    }

    private Collection<ContextIdentifier> getLangToDownstreamContextId(LanguageImplChange change) {
        return Collections.unmodifiableSet(this.langToDownstreamContextIds.getOrDefault(change.impl, Collections.emptySet()));
    }

    private boolean putLangToDownstreamContextId(ContextIdentifier identifier, ILanguageImpl language) {
        return this.langToDownstreamContextIds.computeIfAbsent(language, k -> ConcurrentHashMap.newKeySet()).add(identifier);
    }

    private boolean removeLangToDownstreamContextId(ContextIdentifier identifier, ILanguageImpl language) {
        AtomicBoolean wasPresent = new AtomicBoolean(false);
        this.langToDownstreamContextIds.computeIfPresent(language, (k, v) -> {
            wasPresent.set(v.remove(identifier));
            return v;
        });
        return wasPresent.get();
    }

    private IContextInternal create(IContextFactory factory, ContextIdentifier identifier) {
        return factory.create(identifier);
    }

    private ITemporaryContextInternal createTemporary(IContextFactory factory, ContextIdentifier identifier) {
        return factory.createTemporary(identifier);
    }

    private NullContext createNullContext(IProject project, ILanguageImpl language) {
        return new NullContext(project.location(), project, language, this.injector);
    }
}

