/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.spoofax;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.matching.TermMatch;
import mb.nabl2.terms.stratego.StrategoTerms;
import mb.statix.solver.log.IDebugContext;
import mb.statix.solver.log.LoggerDebugContext;
import mb.statix.solver.log.NullDebugContext;
import mb.statix.solver.persistent.SolverResult;
import mb.statix.spec.Rule;
import mb.statix.spec.Spec;
import mb.statix.spoofax.IStatixProjectConfig;
import org.metaborg.util.collection.ImList;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.Level;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.task.ICancel;
import org.metaborg.util.task.IProgress;
import org.metaborg.util.task.NullCancel;
import org.metaborg.util.task.NullProgress;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.library.AbstractPrimitive;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;

public abstract class StatixPrimitive
extends AbstractPrimitive {
    protected static final ILogger logger = LoggerUtils.logger(StatixPrimitive.class);
    protected static final String WITH_CONFIG_OP = "WithConfig";
    protected final int tvars;

    public StatixPrimitive(String name) {
        this(name, 0);
    }

    public StatixPrimitive(String name, int tvars) {
        super(name, 0, tvars);
        this.tvars = tvars;
    }

    @Override
    public final boolean call(IContext env, Strategy[] svars, IStrategoTerm[] tvars) throws InterpreterException {
        List<IStrategoTerm> termArgs = Arrays.asList(tvars);
        return this.call(env, env.current(), termArgs, env.getFactory()).map(t -> {
            env.setCurrent((IStrategoTerm)t);
            return true;
        }).orElse(false);
    }

    private final Optional<? extends IStrategoTerm> call(IContext env, IStrategoTerm sterm, List<IStrategoTerm> sterms, ITermFactory factory) throws InterpreterException {
        if (sterms.size() != this.tvars) {
            throw new InterpreterException("Expected " + this.tvars + " term arguments, but got " + sterms.size());
        }
        StrategoTerms strategoTerms = new StrategoTerms(factory);
        ITerm term = strategoTerms.fromStratego(sterm);
        List terms = sterms.stream().map(strategoTerms::fromStratego).collect(ImList.Immutable.toImmutableList());
        Optional<? extends ITerm> result = this.call(env, term, terms);
        return result.map(strategoTerms::toStratego);
    }

    protected abstract Optional<? extends ITerm> call(IContext var1, ITerm var2, List<ITerm> var3) throws InterpreterException;

    protected void reportOverlappingRules(Spec spec) {
        Map<String, Set<Rule>> rulesWithEquivalentPatterns = spec.rules().getAllEquivalentRules();
        if (!rulesWithEquivalentPatterns.isEmpty()) {
            logger.error("+--------------------------------------+");
            logger.error("| FOUND RULES WITH EQUIVALENT PATTERNS |");
            logger.error("+--------------------------------------+");
            for (Map.Entry<String, Set<Rule>> entry : rulesWithEquivalentPatterns.entrySet()) {
                logger.error("| Overlapping rules for: {}", entry.getKey());
                for (Rule rule : entry.getValue()) {
                    logger.error("| * {}", rule);
                }
            }
            logger.error("+--------------------------------------+");
        }
    }

    protected void reportInvalidDataLabel(SolverResult<?> analysis, ITerm label) {
        if (!analysis.spec().dataLabels().contains((Object)label)) {
            logger.warn("{} is not a valid relation in this specification. Available relations are {}.", label, analysis.spec().dataLabels());
        }
    }

    protected void reportInvalidEdgeLabel(SolverResult<?> analysis, ITerm label) {
        if (!analysis.spec().edgeLabels().contains((Object)label)) {
            logger.warn("{} is not a valid data label in this specification. Available labels are {}.", label, analysis.spec().edgeLabels());
        }
    }

    protected IDebugContext getDebugContext(ITerm levelTerm) throws InterpreterException {
        String levelString = TermMatch.M.stringValue().match(levelTerm).orElseThrow(() -> new InterpreterException("Expected log level."));
        Level level = levelString.equalsIgnoreCase("None") ? null : Level.parse(levelString);
        IDebugContext debug = level != null ? new LoggerDebugContext(this.getLogger(), level) : new NullDebugContext();
        return debug;
    }

    protected IProgress getProgress(ITerm progressTerm) throws InterpreterException {
        return (IProgress)TermMatch.M.cases(TermMatch.M.tuple0(t -> new NullProgress()), TermMatch.M.blobValue(IProgress.class)).match(progressTerm).orElseThrow(() -> new InterpreterException("Expected progress."));
    }

    protected ICancel getCancel(ITerm cancelTerm) throws InterpreterException {
        return (ICancel)TermMatch.M.cases(TermMatch.M.tuple0(t -> new NullCancel()), TermMatch.M.blobValue(ICancel.class)).match(cancelTerm).orElseThrow(() -> new InterpreterException("Expected cancel."));
    }

    protected ILogger getLogger() {
        return logger;
    }

    protected static SolverResult<?> getResult(ITerm current) throws InterpreterException {
        return (SolverResult)TermMatch.M.cases(TermMatch.M.appl2(WITH_CONFIG_OP, TermMatch.M.term(), TermMatch.M.blobValue(SolverResult.class), (t, c, r) -> r), TermMatch.M.blobValue(SolverResult.class)).match(current).orElseThrow(() -> new InterpreterException("Expected solver result."));
    }

    protected static IStatixProjectConfig getConfig(ITerm current) throws InterpreterException {
        return TermMatch.M.appl2(WITH_CONFIG_OP, TermMatch.M.blobValue(IStatixProjectConfig.class), TermMatch.M.term(), (t, c, r) -> c).match(current).orElse(IStatixProjectConfig.NULL);
    }
}

