/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.spoofax;

import io.usethesource.capsule.Set;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.TermMatch;
import mb.nabl2.terms.unification.u.IUnifier;
import mb.p_raffrayi.IUnitResult;
import mb.p_raffrayi.impl.Result;
import mb.p_raffrayi.impl.diagnostics.AmbigousEdgeMatch;
import mb.p_raffrayi.impl.diff.IDifferOps;
import mb.scopegraph.oopsla20.IScopeGraph;
import mb.statix.concurrent.IStatixResult;
import mb.statix.concurrent.nameresolution.ScopeImpl;
import mb.statix.scopegraph.Scope;
import mb.statix.spoofax.StatixPrimitive;
import org.metaborg.util.collection.BiMap;
import org.metaborg.util.future.IFuture;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;

public class STX_incremental_diagnostics
extends StatixPrimitive {
    @Inject
    public STX_incremental_diagnostics() {
        super(STX_incremental_diagnostics.class.getSimpleName(), 1);
    }

    @Override
    protected Optional<? extends ITerm> call(IContext env, ITerm term, List<ITerm> terms) throws InterpreterException {
        IUnitResult analysis = TermMatch.M.blobValue(IUnitResult.class).match(terms.get(0)).orElseThrow(() -> new InterpreterException("Expected solver result."));
        AnalyticsDifferOps differOps = new AnalyticsDifferOps(analysis.scopes());
        ExplicatedScopeGraph scopeGraph = new ExplicatedScopeGraph(analysis.scopeGraph(), ((IStatixResult)((Result)analysis.result()).analysis()).solveResult().state().unifier());
        AmbigousEdgeMatch<Scope, ITerm, ITerm> aemDiagnostics = new AmbigousEdgeMatch<Scope, ITerm, ITerm>(scopeGraph, analysis.rootScopes(), differOps);
        AmbigousEdgeMatch.Report<Scope, ITerm, ITerm> report = aemDiagnostics.analyze();
        ArrayList<ITerm> matchEntries = new ArrayList<ITerm>();
        for (Scope scope : report.scopes()) {
            ArrayList<ITerm> labels = new ArrayList<ITerm>();
            for (ITerm label : report.labels(scope)) {
                ArrayList<ITerm> matches = new ArrayList<ITerm>();
                for (AmbigousEdgeMatch.Match<Scope, ITerm> match : report.matches(scope, label)) {
                    ITerm d1 = match.getDatum1().map(d -> TermBuild.B.newAppl("Some", (ITerm)d)).orElse(TermBuild.B.newAppl("None", new ITerm[0]));
                    ITerm d2 = match.getDatum2().map(d -> TermBuild.B.newAppl("Some", (ITerm)d)).orElse(TermBuild.B.newAppl("None", new ITerm[0]));
                    matches.add(TermBuild.B.newTuple(match.getScope1(), d1, match.getScope2(), d2));
                }
                labels.add(TermBuild.B.newTuple(label, TermBuild.B.newList(matches)));
            }
            matchEntries.add(TermBuild.B.newTuple(scope, TermBuild.B.newList(labels)));
        }
        return Optional.of(TermBuild.B.newAppl("Diagnostics", TermBuild.B.newList(TermBuild.B.newList(matchEntries))));
    }

    private static class AnalyticsDifferOps
    implements IDifferOps<Scope, ITerm, ITerm> {
        private static final ScopeImpl scopeImpl = new ScopeImpl();
        private final Collection<Scope> ownScopes;

        public AnalyticsDifferOps(Collection<Scope> ownScopes) {
            this.ownScopes = ownScopes;
        }

        @Override
        public boolean isMatchAllowed(Scope currentScope, Scope previousScope) {
            return currentScope.getResource().equals(previousScope.getResource());
        }

        @Override
        public Optional<BiMap.Immutable<Scope>> matchDatums(ITerm currentDatum, ITerm previousDatum) {
            return scopeImpl.matchDatums(currentDatum, previousDatum);
        }

        @Override
        public Collection<Scope> getScopes(ITerm d) {
            return scopeImpl.getScopes(d);
        }

        @Override
        public ITerm embed(Scope scope) {
            return scopeImpl.embed(scope);
        }

        @Override
        public boolean ownScope(Scope scope) {
            return this.ownScopes.contains(scope);
        }

        @Override
        public boolean ownOrSharedScope(Scope currentScope) {
            throw new UnsupportedOperationException();
        }

        @Override
        public IFuture<Optional<Scope>> externalMatch(Scope previousScope) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class ExplicatedScopeGraph
    implements IScopeGraph.Immutable<Scope, ITerm, ITerm> {
        private final IScopeGraph.Immutable<Scope, ITerm, ITerm> scopeGraph;
        private final IUnifier.Immutable unifier;

        public ExplicatedScopeGraph(IScopeGraph.Immutable<Scope, ITerm, ITerm> scopeGraph, IUnifier.Immutable unifier) {
            this.scopeGraph = scopeGraph;
            this.unifier = unifier;
        }

        @Override
        public Map<? extends Map.Entry<Scope, ITerm>, ? extends Collection<Scope>> getEdges() {
            return this.scopeGraph.getEdges();
        }

        @Override
        public Collection<Scope> getEdges(Scope scope, ITerm label) {
            return this.scopeGraph.getEdges(scope, label);
        }

        @Override
        public Map<Scope, ITerm> getData() {
            return this.scopeGraph.getData().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.unifier.findRecursive((ITerm)e.getValue())));
        }

        @Override
        public Optional<ITerm> getData(Scope scope) {
            return this.scopeGraph.getData(scope).map(this.unifier::findRecursive);
        }

        @Override
        public Set.Immutable<ITerm> getLabels() {
            return this.scopeGraph.getLabels();
        }

        @Override
        public IScopeGraph.Immutable<Scope, ITerm, ITerm> addEdge(Scope sourceScope, ITerm label, Scope targetScope) {
            return new ExplicatedScopeGraph(this.scopeGraph.addEdge(sourceScope, label, targetScope), this.unifier);
        }

        @Override
        public IScopeGraph.Immutable<Scope, ITerm, ITerm> setDatum(Scope scope, ITerm datum) {
            return new ExplicatedScopeGraph(this.scopeGraph.setDatum(scope, datum), this.unifier);
        }

        @Override
        public IScopeGraph.Immutable<Scope, ITerm, ITerm> addAll(IScopeGraph<Scope, ITerm, ITerm> other) {
            return new ExplicatedScopeGraph(this.scopeGraph.addAll(other), this.unifier);
        }

        @Override
        public IScopeGraph.Transient<Scope, ITerm, ITerm> melt() {
            throw new UnsupportedOperationException("Cannot melt scope graph with accompanied unifier.");
        }
    }
}

