/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.persistent;

import io.usethesource.capsule.Map;
import io.usethesource.capsule.Set;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import mb.nabl2.terms.ITermVar;
import mb.statix.constraints.messages.IMessage;
import mb.statix.solver.CriticalEdge;
import mb.statix.solver.Delay;
import mb.statix.solver.IConstraint;
import mb.statix.solver.IState;
import mb.statix.solver.completeness.ICompleteness;
import mb.statix.solver.persistent.ASolverResult;
import mb.statix.solver.tracer.SolverTracer;
import mb.statix.spec.Spec;

public final class SolverResult<TR extends SolverTracer.IResult<TR>>
extends ASolverResult<TR>
implements Serializable {
    private final Spec spec;
    private final IState.Immutable state;
    @Nullable
    private final TR traceResult;
    private final Map.Immutable<IConstraint, IMessage> messages;
    private final Map.Immutable<IConstraint, Delay> delays;
    private final Map.Immutable<ITermVar, ITermVar> existentials;
    private final Set.Immutable<ITermVar> updatedVars;
    private final Set.Immutable<CriticalEdge> removedEdges;
    private final ICompleteness.Immutable completeness;
    private final int totalSolved;
    private final int totalCriticalEdges;
    private transient int hashCode;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final long serialVersionUID = 42L;

    private SolverResult(Spec spec, IState.Immutable state, @Nullable TR traceResult, Map.Immutable<IConstraint, IMessage> messages, Map.Immutable<IConstraint, Delay> delays, Map.Immutable<ITermVar, ITermVar> existentials, Set.Immutable<ITermVar> updatedVars, Set.Immutable<CriticalEdge> removedEdges, ICompleteness.Immutable completeness) {
        this.spec = Objects.requireNonNull(spec, "spec");
        this.state = Objects.requireNonNull(state, "state");
        this.traceResult = traceResult;
        this.messages = Objects.requireNonNull(messages, "messages");
        this.delays = Objects.requireNonNull(delays, "delays");
        this.existentials = Objects.requireNonNull(existentials, "existentials");
        this.updatedVars = Objects.requireNonNull(updatedVars, "updatedVars");
        this.removedEdges = Objects.requireNonNull(removedEdges, "removedEdges");
        this.completeness = Objects.requireNonNull(completeness, "completeness");
        this.totalSolved = this.initShim.totalSolved();
        this.totalCriticalEdges = this.initShim.totalCriticalEdges();
        this.initShim = null;
    }

    private SolverResult(Builder<TR> builder) {
        this.spec = ((Builder)builder).spec;
        this.state = ((Builder)builder).state;
        this.traceResult = ((Builder)builder).traceResult;
        this.messages = ((Builder)builder).messages;
        this.delays = ((Builder)builder).delays;
        this.existentials = ((Builder)builder).existentials;
        this.updatedVars = ((Builder)builder).updatedVars;
        this.removedEdges = ((Builder)builder).removedEdges;
        this.completeness = ((Builder)builder).completeness;
        if (((Builder)builder).totalSolvedIsSet()) {
            this.initShim.totalSolved(((Builder)builder).totalSolved);
        }
        if (((Builder)builder).totalCriticalEdgesIsSet()) {
            this.initShim.totalCriticalEdges(((Builder)builder).totalCriticalEdges);
        }
        this.totalSolved = this.initShim.totalSolved();
        this.totalCriticalEdges = this.initShim.totalCriticalEdges();
        this.initShim = null;
    }

    private SolverResult(Spec spec, IState.Immutable state, @Nullable TR traceResult, Map.Immutable<IConstraint, IMessage> messages, Map.Immutable<IConstraint, Delay> delays, Map.Immutable<ITermVar, ITermVar> existentials, Set.Immutable<ITermVar> updatedVars, Set.Immutable<CriticalEdge> removedEdges, ICompleteness.Immutable completeness, int totalSolved, int totalCriticalEdges) {
        this.spec = spec;
        this.state = state;
        this.traceResult = traceResult;
        this.messages = messages;
        this.delays = delays;
        this.existentials = existentials;
        this.updatedVars = updatedVars;
        this.removedEdges = removedEdges;
        this.completeness = completeness;
        this.totalSolved = totalSolved;
        this.totalCriticalEdges = totalCriticalEdges;
        this.initShim = null;
    }

    @Override
    public Spec spec() {
        return this.spec;
    }

    @Override
    public IState.Immutable state() {
        return this.state;
    }

    @Override
    @Nullable
    public TR traceResult() {
        return this.traceResult;
    }

    @Override
    public Map.Immutable<IConstraint, IMessage> messages() {
        return this.messages;
    }

    @Override
    public Map.Immutable<IConstraint, Delay> delays() {
        return this.delays;
    }

    @Override
    public Map.Immutable<ITermVar, ITermVar> existentials() {
        return this.existentials;
    }

    @Override
    public Set.Immutable<ITermVar> updatedVars() {
        return this.updatedVars;
    }

    @Override
    public Set.Immutable<CriticalEdge> removedEdges() {
        return this.removedEdges;
    }

    @Override
    public ICompleteness.Immutable completeness() {
        return this.completeness;
    }

    @Override
    public int totalSolved() {
        InitShim shim = this.initShim;
        return shim != null ? shim.totalSolved() : this.totalSolved;
    }

    @Override
    public int totalCriticalEdges() {
        InitShim shim = this.initShim;
        return shim != null ? shim.totalCriticalEdges() : this.totalCriticalEdges;
    }

    public final SolverResult<TR> withSpec(Spec value) {
        if (this.spec == value) {
            return this;
        }
        Spec newValue = Objects.requireNonNull(value, "spec");
        return new SolverResult<TR>(newValue, this.state, this.traceResult, this.messages, this.delays, this.existentials, this.updatedVars, this.removedEdges, this.completeness, this.totalSolved, this.totalCriticalEdges);
    }

    public final SolverResult<TR> withState(IState.Immutable value) {
        if (this.state == value) {
            return this;
        }
        IState.Immutable newValue = Objects.requireNonNull(value, "state");
        return new SolverResult<TR>(this.spec, newValue, this.traceResult, this.messages, this.delays, this.existentials, this.updatedVars, this.removedEdges, this.completeness, this.totalSolved, this.totalCriticalEdges);
    }

    public final SolverResult<TR> withTraceResult(@Nullable TR value) {
        if (this.traceResult == value) {
            return this;
        }
        return new SolverResult<TR>(this.spec, this.state, value, this.messages, this.delays, this.existentials, this.updatedVars, this.removedEdges, this.completeness, this.totalSolved, this.totalCriticalEdges);
    }

    public final SolverResult<TR> withMessages(Map.Immutable<IConstraint, IMessage> value) {
        if (this.messages == value) {
            return this;
        }
        Map.Immutable<IConstraint, IMessage> newValue = Objects.requireNonNull(value, "messages");
        return new SolverResult<TR>(this.spec, this.state, this.traceResult, newValue, this.delays, this.existentials, this.updatedVars, this.removedEdges, this.completeness, this.totalSolved, this.totalCriticalEdges);
    }

    public final SolverResult<TR> withDelays(Map.Immutable<IConstraint, Delay> value) {
        if (this.delays == value) {
            return this;
        }
        Map.Immutable<IConstraint, Delay> newValue = Objects.requireNonNull(value, "delays");
        return new SolverResult<TR>(this.spec, this.state, this.traceResult, this.messages, newValue, this.existentials, this.updatedVars, this.removedEdges, this.completeness, this.totalSolved, this.totalCriticalEdges);
    }

    public final SolverResult<TR> withExistentials(Map.Immutable<ITermVar, ITermVar> value) {
        if (this.existentials == value) {
            return this;
        }
        Map.Immutable<ITermVar, ITermVar> newValue = Objects.requireNonNull(value, "existentials");
        return new SolverResult<TR>(this.spec, this.state, this.traceResult, this.messages, this.delays, newValue, this.updatedVars, this.removedEdges, this.completeness, this.totalSolved, this.totalCriticalEdges);
    }

    public final SolverResult<TR> withUpdatedVars(Set.Immutable<ITermVar> value) {
        if (this.updatedVars == value) {
            return this;
        }
        Set.Immutable<ITermVar> newValue = Objects.requireNonNull(value, "updatedVars");
        return new SolverResult<TR>(this.spec, this.state, this.traceResult, this.messages, this.delays, this.existentials, newValue, this.removedEdges, this.completeness, this.totalSolved, this.totalCriticalEdges);
    }

    public final SolverResult<TR> withRemovedEdges(Set.Immutable<CriticalEdge> value) {
        if (this.removedEdges == value) {
            return this;
        }
        Set.Immutable<CriticalEdge> newValue = Objects.requireNonNull(value, "removedEdges");
        return new SolverResult<TR>(this.spec, this.state, this.traceResult, this.messages, this.delays, this.existentials, this.updatedVars, newValue, this.completeness, this.totalSolved, this.totalCriticalEdges);
    }

    public final SolverResult<TR> withCompleteness(ICompleteness.Immutable value) {
        if (this.completeness == value) {
            return this;
        }
        ICompleteness.Immutable newValue = Objects.requireNonNull(value, "completeness");
        return new SolverResult<TR>(this.spec, this.state, this.traceResult, this.messages, this.delays, this.existentials, this.updatedVars, this.removedEdges, newValue, this.totalSolved, this.totalCriticalEdges);
    }

    public final SolverResult<TR> withTotalSolved(int value) {
        if (this.totalSolved == value) {
            return this;
        }
        return new SolverResult<TR>(this.spec, this.state, this.traceResult, this.messages, this.delays, this.existentials, this.updatedVars, this.removedEdges, this.completeness, value, this.totalCriticalEdges);
    }

    public final SolverResult<TR> withTotalCriticalEdges(int value) {
        if (this.totalCriticalEdges == value) {
            return this;
        }
        return new SolverResult<TR>(this.spec, this.state, this.traceResult, this.messages, this.delays, this.existentials, this.updatedVars, this.removedEdges, this.completeness, this.totalSolved, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SolverResult && this.equalTo(0, (SolverResult)another);
    }

    private boolean equalTo(int synthetic, SolverResult<?> another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.spec.equals(another.spec) && this.state.equals(another.state) && Objects.equals(this.traceResult, another.traceResult) && this.messages.equals(another.messages) && this.delays.equals(another.delays) && this.existentials.equals(another.existentials) && this.updatedVars.equals(another.updatedVars) && this.removedEdges.equals(another.removedEdges) && this.completeness.equals(another.completeness) && this.totalSolved == another.totalSolved && this.totalCriticalEdges == another.totalCriticalEdges;
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.spec.hashCode();
        h += (h << 5) + this.state.hashCode();
        h += (h << 5) + Objects.hashCode(this.traceResult);
        h += (h << 5) + this.messages.hashCode();
        h += (h << 5) + this.delays.hashCode();
        h += (h << 5) + this.existentials.hashCode();
        h += (h << 5) + this.updatedVars.hashCode();
        h += (h << 5) + this.removedEdges.hashCode();
        h += (h << 5) + this.completeness.hashCode();
        h += (h << 5) + this.totalSolved;
        h += (h << 5) + this.totalCriticalEdges;
        return h;
    }

    public String toString() {
        return "SolverResult{spec=" + this.spec + ", state=" + this.state + ", traceResult=" + this.traceResult + ", messages=" + this.messages + ", delays=" + this.delays + ", existentials=" + this.existentials + ", updatedVars=" + this.updatedVars + ", removedEdges=" + this.removedEdges + ", completeness=" + this.completeness + ", totalSolved=" + this.totalSolved + ", totalCriticalEdges=" + this.totalCriticalEdges + "}";
    }

    public static <TR extends SolverTracer.IResult<TR>> SolverResult<TR> of(Spec spec, IState.Immutable state, @Nullable TR traceResult, Map.Immutable<IConstraint, IMessage> messages, Map.Immutable<IConstraint, Delay> delays, Map.Immutable<ITermVar, ITermVar> existentials, Set.Immutable<ITermVar> updatedVars, Set.Immutable<CriticalEdge> removedEdges, ICompleteness.Immutable completeness) {
        return new SolverResult<TR>(spec, state, traceResult, messages, delays, existentials, updatedVars, removedEdges, completeness);
    }

    public static <TR extends SolverTracer.IResult<TR>> SolverResult<TR> copyOf(ASolverResult<TR> instance) {
        if (instance instanceof SolverResult) {
            return (SolverResult)instance;
        }
        return SolverResult.builder().from(instance).build();
    }

    public static <TR extends SolverTracer.IResult<TR>> Builder<TR> builder() {
        return new Builder();
    }

    /* synthetic */ SolverResult(Builder builder, SolverResult solverResult) {
        this(builder);
    }

    public static final class Builder<TR extends SolverTracer.IResult<TR>> {
        private static final long INIT_BIT_SPEC = 1L;
        private static final long INIT_BIT_STATE = 2L;
        private static final long INIT_BIT_MESSAGES = 4L;
        private static final long INIT_BIT_DELAYS = 8L;
        private static final long INIT_BIT_EXISTENTIALS = 16L;
        private static final long INIT_BIT_UPDATED_VARS = 32L;
        private static final long INIT_BIT_REMOVED_EDGES = 64L;
        private static final long INIT_BIT_COMPLETENESS = 128L;
        private static final long OPT_BIT_TOTAL_SOLVED = 1L;
        private static final long OPT_BIT_TOTAL_CRITICAL_EDGES = 2L;
        private long initBits = 255L;
        private long optBits;
        private Spec spec;
        private IState.Immutable state;
        private TR traceResult;
        private Map.Immutable<IConstraint, IMessage> messages;
        private Map.Immutable<IConstraint, Delay> delays;
        private Map.Immutable<ITermVar, ITermVar> existentials;
        private Set.Immutable<ITermVar> updatedVars;
        private Set.Immutable<CriticalEdge> removedEdges;
        private ICompleteness.Immutable completeness;
        private int totalSolved;
        private int totalCriticalEdges;

        private Builder() {
        }

        public final Builder<TR> from(ASolverResult<TR> instance) {
            Objects.requireNonNull(instance, "instance");
            this.spec(instance.spec());
            this.state(instance.state());
            TR traceResultValue = instance.traceResult();
            if (traceResultValue != null) {
                this.traceResult(traceResultValue);
            }
            this.messages(instance.messages());
            this.delays(instance.delays());
            this.existentials(instance.existentials());
            this.updatedVars(instance.updatedVars());
            this.removedEdges(instance.removedEdges());
            this.completeness(instance.completeness());
            this.totalSolved(instance.totalSolved());
            this.totalCriticalEdges(instance.totalCriticalEdges());
            return this;
        }

        public final Builder<TR> spec(Spec spec) {
            this.spec = Objects.requireNonNull(spec, "spec");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<TR> state(IState.Immutable state) {
            this.state = Objects.requireNonNull(state, "state");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder<TR> traceResult(@Nullable TR traceResult) {
            this.traceResult = traceResult;
            return this;
        }

        public final Builder<TR> messages(Map.Immutable<IConstraint, IMessage> messages) {
            this.messages = Objects.requireNonNull(messages, "messages");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder<TR> delays(Map.Immutable<IConstraint, Delay> delays) {
            this.delays = Objects.requireNonNull(delays, "delays");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder<TR> existentials(Map.Immutable<ITermVar, ITermVar> existentials) {
            this.existentials = Objects.requireNonNull(existentials, "existentials");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder<TR> updatedVars(Set.Immutable<ITermVar> updatedVars) {
            this.updatedVars = Objects.requireNonNull(updatedVars, "updatedVars");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder<TR> removedEdges(Set.Immutable<CriticalEdge> removedEdges) {
            this.removedEdges = Objects.requireNonNull(removedEdges, "removedEdges");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder<TR> completeness(ICompleteness.Immutable completeness) {
            this.completeness = Objects.requireNonNull(completeness, "completeness");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public final Builder<TR> totalSolved(int totalSolved) {
            this.totalSolved = totalSolved;
            this.optBits |= 1L;
            return this;
        }

        public final Builder<TR> totalCriticalEdges(int totalCriticalEdges) {
            this.totalCriticalEdges = totalCriticalEdges;
            this.optBits |= 2L;
            return this;
        }

        public SolverResult<TR> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new SolverResult(this, null);
        }

        private boolean totalSolvedIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean totalCriticalEdgesIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("spec");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("state");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("messages");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("delays");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("existentials");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("updatedVars");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("removedEdges");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("completeness");
            }
            return "Cannot build SolverResult, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte totalSolvedBuildStage = 0;
        private int totalSolved;
        private byte totalCriticalEdgesBuildStage = 0;
        private int totalCriticalEdges;

        private InitShim() {
        }

        int totalSolved() {
            if (this.totalSolvedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.totalSolvedBuildStage == 0) {
                this.totalSolvedBuildStage = (byte)-1;
                this.totalSolved = SolverResult.super.totalSolved();
                this.totalSolvedBuildStage = 1;
            }
            return this.totalSolved;
        }

        void totalSolved(int totalSolved) {
            this.totalSolved = totalSolved;
            this.totalSolvedBuildStage = 1;
        }

        int totalCriticalEdges() {
            if (this.totalCriticalEdgesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.totalCriticalEdgesBuildStage == 0) {
                this.totalCriticalEdgesBuildStage = (byte)-1;
                this.totalCriticalEdges = SolverResult.super.totalCriticalEdges();
                this.totalCriticalEdgesBuildStage = 1;
            }
            return this.totalCriticalEdges;
        }

        void totalCriticalEdges(int totalCriticalEdges) {
            this.totalCriticalEdges = totalCriticalEdges;
            this.totalCriticalEdgesBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.totalSolvedBuildStage == -1) {
                attributes.add("totalSolved");
            }
            if (this.totalCriticalEdgesBuildStage == -1) {
                attributes.add("totalCriticalEdges");
            }
            return "Cannot build SolverResult, attribute initializers form cycle " + attributes;
        }
    }
}

