/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.oopsla20;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import mb.scopegraph.oopsla20.IScopeGraph;
import org.metaborg.util.collection.Sets;
import org.metaborg.util.functions.Function1;
import org.metaborg.util.functions.PartialFunction1;

public final class ScopeGraphUtil {
    private ScopeGraphUtil() {
    }

    public static <S, L, D> String toString(IScopeGraph<S, L, D> scopeGraph, Function1<D, D> instantiateData) {
        return ScopeGraphUtil.toString(scopeGraph, instantiateData, PartialFunction1.never());
    }

    public static <S, L, D> String toString(IScopeGraph<S, L, D> scopeGraph, Function1<D, D> instantiateData, PartialFunction1<D, D> getAuxData) {
        Map<Map.Entry<S, L>, Collection<S>> sgEdges = scopeGraph.getEdges();
        Map groupedScopes = sgEdges.entrySet().stream().collect(Collectors.groupingBy(t -> ((Map.Entry)t.getKey()).getKey(), Collectors.mapping(t -> {
            AbstractMap.SimpleImmutableEntry result = new AbstractMap.SimpleImmutableEntry(((Map.Entry)t.getKey()).getValue(), (Iterable)t.getValue());
            return result;
        }, Collectors.toSet())));
        StringBuilder sb = new StringBuilder();
        for (Object source : Sets.union(groupedScopes.keySet(), scopeGraph.getData().keySet())) {
            sb.append(source);
            if (scopeGraph.getData(source).isPresent()) {
                sb.append(" : ");
                D data = scopeGraph.getData(source).get();
                D instantatedData = instantiateData.apply(data);
                sb.append(instantatedData);
                ((Optional)getAuxData.apply(instantatedData)).ifPresent(a -> {
                    sb.append("{");
                    sb.append(a);
                    sb.append("}");
                });
            }
            if (!groupedScopes.containsKey(source)) {
                sb.append("\n");
                continue;
            }
            sb.append(" {\n");
            for (Map.Entry edges : groupedScopes.get(source)) {
                sb.append("  ");
                sb.append(edges.getKey());
                sb.append(": ");
                int indent = edges.getKey().toString().length() + 6;
                boolean first = true;
                for (Object target : (Iterable)edges.getValue()) {
                    if (first) {
                        sb.append("[ ");
                        first = false;
                    } else {
                        sb.append(",\n");
                        sb.append(String.join((CharSequence)"", Collections.nCopies(indent, " ")));
                    }
                    sb.append(target);
                }
                sb.append("]\n");
            }
            sb.append("}\n");
        }
        return sb.toString();
    }
}

