/*
 * Decompiled with CFR 0.152.
 */
package mb.resource.hierarchical.match;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import mb.resource.hierarchical.HierarchicalResource;
import mb.resource.hierarchical.match.ResourceMatcher;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AnyResourceMatcher
implements ResourceMatcher {
    private final List<ResourceMatcher> matchers;

    public AnyResourceMatcher(ArrayList<ResourceMatcher> matchers) {
        this.matchers = matchers;
    }

    public AnyResourceMatcher(ResourceMatcher ... matchers) {
        this.matchers = Arrays.asList(matchers);
    }

    @Override
    public boolean matches(HierarchicalResource resource, HierarchicalResource rootDirectory) throws IOException {
        for (ResourceMatcher matcher : this.matchers) {
            if (!matcher.matches(resource, rootDirectory)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AnyResourceMatcher other = (AnyResourceMatcher)obj;
        return this.matchers.equals(other.matchers);
    }

    public int hashCode() {
        return Objects.hash(this.matchers);
    }

    public String toString() {
        return "any(" + this.matchers + ")";
    }
}

