/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.util.collections;

import io.usethesource.capsule.Map;
import io.usethesource.capsule.SetMultimap;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import mb.nabl2.util.collections.IProperties;
import org.metaborg.util.functions.Function1;
import org.metaborg.util.tuple.Tuple2;
import org.metaborg.util.tuple.Tuple3;

public abstract class Properties<I, K, V>
implements IProperties<I, K, V> {
    protected abstract SetMultimap<I, K> keys();

    protected abstract Map<Tuple2<I, K>, V> values();

    @Override
    public Set<I> getIndices() {
        return this.keys().keySet();
    }

    @Override
    public io.usethesource.capsule.Set<K> getDefinedKeys(I index) {
        return this.keys().get(index);
    }

    @Override
    public Optional<V> getValue(I index, K key) {
        return Optional.ofNullable(this.values().get(Tuple2.of(index, key)));
    }

    @Override
    public boolean contains(I index) {
        return this.keys().containsKey(index);
    }

    @Override
    public boolean contains(I index, K key) {
        return this.values().containsKey(Tuple2.of(index, key));
    }

    @Override
    public Stream<Tuple3<I, K, V>> stream() {
        return this.values().entrySet().stream().map(entry -> Tuple3.of(((Tuple2)entry.getKey())._1(), ((Tuple2)entry.getKey())._2(), entry.getValue()));
    }

    public String toString() {
        return this.values().toString();
    }

    public static class Immutable<I, K, V>
    extends Properties<I, K, V>
    implements IProperties.Immutable<I, K, V>,
    Serializable {
        private static final long serialVersionUID = 42L;
        private final SetMultimap.Immutable<I, K> keys;
        private final Map.Immutable<Tuple2<I, K>, V> values;

        private Immutable(SetMultimap.Immutable<I, K> keys, Map.Immutable<Tuple2<I, K>, V> values) {
            this.keys = keys;
            this.values = values;
        }

        @Override
        protected SetMultimap<I, K> keys() {
            return this.keys;
        }

        @Override
        protected Map<Tuple2<I, K>, V> values() {
            return this.values;
        }

        public static <I, K, V> Immutable<I, K, V> of() {
            return new Immutable<I, K, V>(SetMultimap.Immutable.of(), Map.Immutable.of());
        }

        @Override
        public Transient<I, K, V> melt() {
            return new Transient(this.keys.asTransient(), this.values.asTransient());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.keys.hashCode();
            result = 31 * result + this.values.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Immutable other = (Immutable)obj;
            if (!this.keys.equals(other.keys)) {
                return false;
            }
            return this.values.equals(other.values);
        }
    }

    public static class Transient<I, K, V>
    extends Properties<I, K, V>
    implements IProperties.Transient<I, K, V> {
        private final SetMultimap.Transient<I, K> keys;
        private final Map.Transient<Tuple2<I, K>, V> values;

        private Transient(SetMultimap.Transient<I, K> keys, Map.Transient<Tuple2<I, K>, V> values) {
            this.keys = keys;
            this.values = values;
        }

        @Override
        protected SetMultimap<I, K> keys() {
            return this.keys;
        }

        @Override
        protected Map<Tuple2<I, K>, V> values() {
            return this.values;
        }

        @Override
        public Optional<V> putValue(I index, K key, V value) {
            Object prev = this.values.__put(Tuple2.of(index, key), value);
            if (!value.equals(prev)) {
                this.keys.__insert(index, key);
                return Optional.ofNullable(prev);
            }
            return Optional.empty();
        }

        @Override
        public boolean mapValues(Function1<V, V> mapper) {
            boolean change = false;
            for (Map.Entry entry : this.values.entrySet()) {
                Object curr = entry.getValue();
                V next = mapper.apply(curr);
                if (next.equals(curr)) continue;
                this.values.__put((Object)((Tuple2)entry.getKey()), next);
                change |= true;
            }
            return change;
        }

        @Override
        public Immutable<I, K, V> freeze() {
            return new Immutable(this.keys.freeze(), this.values.freeze());
        }

        public static <I, K, V> Transient<I, K, V> of() {
            return new Transient<I, K, V>(SetMultimap.Transient.of(), Map.Transient.of());
        }
    }
}

