/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import oracle.pgx.api.keys.KeyColumnDescriptor;
import oracle.pgx.common.NotImplementedException;
import oracle.pgx.common.types.EntityType;
import oracle.pgx.common.types.IdStrategy;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.DbConnectionConfig;
import oracle.pgx.config.EntityProviderConfig;
import oracle.pgx.config.EsConnectionConfig;
import oracle.pgx.config.ExternalStoreConfig;
import oracle.pgx.config.Format;
import oracle.pgx.config.GraphConfig;
import oracle.pgx.config.GraphLoadingConfig;
import oracle.pgx.config.GraphPropertyConfig;
import oracle.pgx.config.OnMissingVertex;
import oracle.pgx.config.PartitionWhileLoading;
import oracle.pgx.config.PartitionedGraphConfig;
import oracle.pgx.config.PartitionedGraphConfigBuilder;
import oracle.pgx.config.PgxRedactionRuleConfig;
import oracle.pgx.config.PgxRedactionRuleMappingConfig;

public abstract class AbstractPartitionedGraphConfig
extends GraphConfig
implements DbConnectionConfig,
EsConnectionConfig {
    private static final Set<GraphLoadingConfig.Field> VALID_LOADING_FIELDS = Stream.of(GraphLoadingConfig.Field.SKIP_VERTICES, GraphLoadingConfig.Field.SKIP_EDGES, GraphLoadingConfig.Field.CREATE_LABEL_HISTOGRAM, GraphLoadingConfig.Field.SNAPSHOTS_SOURCE, GraphLoadingConfig.Field.AUTO_REFRESH, GraphLoadingConfig.Field.UPDATE_INTERVAL_SEC, GraphLoadingConfig.Field.LOADING_PROGRESS_REPORTING_FREQUENCY).collect(Collectors.toSet());

    @Override
    public PartitionedGraphConfigBuilder toGraphConfigBuilder() {
        return new PartitionedGraphConfigBuilder().copyFrom((PartitionedGraphConfig)this);
    }

    @Override
    public PartitionWhileLoading getPartitionWhileLoading() {
        return null;
    }

    @Override
    public IdStrategy getValidatedVertexIdStrategy() {
        IdStrategy idStrategy = this.getVertexIdStrategy();
        boolean loadingKeys = this.isLoadingKeys(this.getVertexProviders(), idStrategy);
        return this.getValidatedIdStrategy(EntityType.VERTEX, loadingKeys, idStrategy);
    }

    @Override
    public IdStrategy getValidatedEdgeIdStrategy() {
        IdStrategy idStrategy = this.getEdgeIdStrategy();
        boolean loadingKeys = this.isLoadingKeys(this.getEdgeProviders(), idStrategy);
        return this.getValidatedIdStrategy(EntityType.EDGE, loadingKeys, idStrategy);
    }

    private boolean isLoadingKeys(List<EntityProviderConfig> entityProviders, IdStrategy idStrategy) {
        if (entityProviders.isEmpty()) {
            if (idStrategy == null) {
                return false;
            }
            switch (idStrategy) {
                case NO_IDS: 
                case UNSTABLE_GENERATED_IDS: {
                    return false;
                }
                case PARTITIONED_IDS: 
                case KEYS_AS_IDS: {
                    return true;
                }
            }
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"UNSUPPORTED_ID_STRATEGY", (Object[])new Object[]{idStrategy}));
        }
        return entityProviders.stream().allMatch(EntityProviderConfig::isKeyMappingEnabled);
    }

    @Override
    public IdType getValidatedVertexIdType() {
        if (this.getVertexIdType() == null) {
            IdStrategy validatedVertexIdStrategy = this.getValidatedVertexIdStrategy();
            if (validatedVertexIdStrategy == IdStrategy.PARTITIONED_IDS) {
                return IdType.STRING;
            }
            return this.getIdTypeFromProviders(validatedVertexIdStrategy, IdType.INTEGER, this.getVertexProviders());
        }
        return super.getValidatedVertexIdType();
    }

    @Override
    public IdType getValidatedEdgeIdType() {
        if (this.getEdgeIdType() == null) {
            IdStrategy validatedEdgeIdStrategy = this.getValidatedEdgeIdStrategy();
            if (validatedEdgeIdStrategy == IdStrategy.PARTITIONED_IDS) {
                return IdType.STRING;
            }
            return this.getIdTypeFromProviders(validatedEdgeIdStrategy, IdType.LONG, this.getEdgeProviders());
        }
        return super.getValidatedEdgeIdType();
    }

    public abstract List<PgxRedactionRuleConfig> getRedactionRules();

    public abstract List<PgxRedactionRuleMappingConfig> getRulesMapping();

    public abstract List<EntityProviderConfig> getVertexProviders();

    public abstract List<EntityProviderConfig> getEdgeProviders();

    public abstract Integer getNumConnections();

    public abstract boolean hasDefaultValue(PartitionedGraphConfig.Field var1);

    @Override
    protected void validate() {
        for (GraphLoadingConfig.Field loadingField : this.getLoading().getValuesWithoutDefaults().keySet()) {
            if (VALID_LOADING_FIELDS.contains(loadingField)) continue;
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"FOUND_INVALID_CONFIG_FIELDS", (Object[])new Object[]{loadingField}));
        }
        OnMissingVertex onMissingVertex = this.getErrorHandling().getOnMissingVertex();
        if (onMissingVertex == OnMissingVertex.CREATE_VERTEX || onMissingVertex == OnMissingVertex.CREATE_VERTEX_LOG || onMissingVertex == OnMissingVertex.CREATE_VERTEX_LOG_ONCE) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"CREATE_VERTEX_NOT_ALLOWED", (Object[])new Object[0]));
        }
        this.validateUpdateOptimizedGraphParameters();
        this.validateEmptyGraph();
        this.validatePartitionedIdType();
        this.validateVertexProviders();
        this.validateEdgeProviders();
        this.validateSrcDestinationVertexProviders();
    }

    private void validateEmptyGraph() {
        if (this.isEmptyList(this.getVertexProviders()) && this.isEmptyList(this.getEdgeProviders())) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"CANNOT_SKIP_BOTH_EDGES_VERTICES", (Object[])new Object[0]));
        }
        if (this.isEmptyList(this.getVertexProviders()) && this.skipEdgeLoading()) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"CANNOT_SKIP_BOTH_EDGES_VERTICES", (Object[])new Object[0]));
        }
        if (this.isEmptyList(this.getEdgeProviders()) && this.skipVertexLoading()) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"CANNOT_SKIP_BOTH_EDGES_VERTICES", (Object[])new Object[0]));
        }
    }

    private void validatePartitionedIdType() {
        if (this.getValidatedVertexIdStrategy() == IdStrategy.PARTITIONED_IDS && this.getValidatedVertexIdType() != IdType.STRING) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"ILLEGAL_PARTITIONED_ID_TYPE", (Object[])new Object[]{this.getValidatedVertexIdType()}));
        }
        if (this.getValidatedEdgeIdStrategy() == IdStrategy.PARTITIONED_IDS && this.getValidatedEdgeIdType() != IdType.STRING) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"ILLEGAL_PARTITIONED_ID_TYPE", (Object[])new Object[]{this.getValidatedEdgeIdType()}));
        }
    }

    private void validateVertexProviders() {
        if (!this.isEmptyList(this.getVertexProviders()) && !this.skipVertexLoading()) {
            this.validateTableNames(this.getVertexProviders());
            this.validateLabels(this.getVertexProviders());
            this.validateNoSrcDestVertexProviders();
            this.getVertexProviders().forEach(providerConfig -> providerConfig.validate(this));
        }
        this.validateNoConflictingProperties(this.getVertexProviders());
        IdStrategy idStrategy = this.getValidatedVertexIdStrategy();
        switch (idStrategy) {
            case NO_IDS: 
            case UNSTABLE_GENERATED_IDS: 
            case PARTITIONED_IDS: {
                break;
            }
            case KEYS_AS_IDS: {
                IdType vertexIdType = this.getVertexIdType();
                this.validateNoConflictingKeyTypes(idStrategy, vertexIdType, IdType.INTEGER, this.getVertexProviders());
                break;
            }
            default: {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"UNSUPPORTED_ID_STRATEGY", (Object[])new Object[]{idStrategy}));
            }
        }
    }

    private void validateEdgeProviders() {
        if (!this.isEmptyList(this.getEdgeProviders()) && !this.skipEdgeLoading()) {
            this.validateTableNames(this.getEdgeProviders());
            this.validateLabels(this.getEdgeProviders());
            this.validateContainsSrcDestVertexProviders();
            this.validateOnMissingVertexAction(this.getEdgeProviders());
            this.getEdgeProviders().forEach(providerConfig -> providerConfig.validate(this));
        }
        this.validateNoConflictingProperties(this.getEdgeProviders());
        IdStrategy idStrategy = this.getValidatedEdgeIdStrategy();
        switch (idStrategy) {
            case NO_IDS: 
            case UNSTABLE_GENERATED_IDS: 
            case PARTITIONED_IDS: {
                break;
            }
            case KEYS_AS_IDS: {
                IdType edgeIdType = this.getEdgeIdType();
                this.validateNoConflictingKeyTypes(idStrategy, edgeIdType, IdType.LONG, this.getEdgeProviders());
                break;
            }
            default: {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"UNSUPPORTED_ID_STRATEGY", (Object[])new Object[]{idStrategy}));
            }
        }
    }

    private void validateNoConflictingProperties(Collection<EntityProviderConfig> providerConfigs) {
        HashMap<String, Set> propertyNamesWithTypes = new HashMap<String, Set>();
        for (EntityProviderConfig providerConfig : providerConfigs) {
            for (GraphPropertyConfig propertyConfig : providerConfig.getProps()) {
                Set propertyConfigs = propertyNamesWithTypes.computeIfAbsent(propertyConfig.getName(), n -> new HashSet());
                propertyConfigs.add(propertyConfig);
            }
        }
        propertyNamesWithTypes.forEach((propertyName, definitions) -> {
            if (definitions.size() > 1) {
                Set types = definitions.stream().map(GraphPropertyConfig::getType).collect(Collectors.toSet());
                if (types.size() > 1) {
                    throw new IllegalArgumentException(ErrorMessages.getMessage((String)"CONFLICTING_PROPERTY_TYPES", (Object[])new Object[]{propertyName, types}));
                }
                Set dimensions = definitions.stream().map(GraphPropertyConfig::getDimension).collect(Collectors.toSet());
                if (dimensions.size() > 1) {
                    throw new IllegalArgumentException(ErrorMessages.getMessage((String)"CONFLICTING_PROPERTY_DIMENSIONS", (Object[])new Object[]{propertyName, dimensions}));
                }
            }
        });
    }

    private void validateNoConflictingKeyTypes(IdStrategy idStrategy, IdType expectedIdType, IdType droppedIdType, Collection<EntityProviderConfig> providerConfigs) {
        if (expectedIdType == null) {
            return;
        }
        if (providerConfigs.isEmpty()) {
            return;
        }
        IdType providersIdType = this.getIdTypeFromProviders(idStrategy, droppedIdType, providerConfigs);
        if (providersIdType != expectedIdType) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"CONFLICTING_KEY_TYPES", (Object[])new Object[]{Arrays.asList(providersIdType, expectedIdType)}));
        }
    }

    private IdType getIdTypeFromProviders(IdStrategy idStrategy, IdType droppedIdType, Collection<EntityProviderConfig> providerConfigs) {
        if (idStrategy == IdStrategy.PARTITIONED_IDS) {
            return IdType.STRING;
        }
        if (providerConfigs.isEmpty()) {
            return droppedIdType;
        }
        Set keyTypes = providerConfigs.stream().map(providerConfig -> {
            if (providerConfig.isKeyMappingEnabled()) {
                return providerConfig.getKeyType();
            }
            return droppedIdType;
        }).collect(Collectors.toSet());
        if (keyTypes.size() > 1) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"CONFLICTING_KEY_TYPES", (Object[])new Object[]{keyTypes}));
        }
        return (IdType)keyTypes.iterator().next();
    }

    private void validateOnMissingVertexAction(List<EntityProviderConfig> providerConfigs) {
        providerConfigs.forEach(edgeTable -> {
            OnMissingVertex onMissingVertex = edgeTable.getErrorHandling().getOnMissingVertex();
            if (onMissingVertex == OnMissingVertex.CREATE_VERTEX || onMissingVertex == OnMissingVertex.CREATE_VERTEX_LOG || onMissingVertex == OnMissingVertex.CREATE_VERTEX_LOG_ONCE) {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"CREATE_VERTEX_NOT_ALLOWED", (Object[])new Object[0]));
            }
        });
    }

    private boolean compatibleForSameLabel(EntityProviderConfig provider, EntityProviderConfig otherProvider) {
        List<GraphPropertyConfig> props = provider.getProps();
        List<GraphPropertyConfig> otherProps = otherProvider.getProps();
        if (props.size() != otherProps.size()) {
            return false;
        }
        HashMap propNameToType = new HashMap();
        otherProps.forEach(prop -> propNameToType.put(prop.getName(), prop.getType()));
        for (GraphPropertyConfig prop2 : props) {
            PropertyType otherType = (PropertyType)propNameToType.get(prop2.getName());
            if (otherType != null && otherType.equals((Object)prop2.getType())) continue;
            return false;
        }
        return true;
    }

    private void validateLabels(List<EntityProviderConfig> providerConfigs) {
        HashMap<String, EntityProviderConfig> labelToConfig = new HashMap<String, EntityProviderConfig>();
        for (EntityProviderConfig providerConfig : providerConfigs) {
            String label = providerConfig.getValidatedLabel();
            if (labelToConfig.containsKey(label)) {
                EntityProviderConfig otherProvider = (EntityProviderConfig)labelToConfig.get(label);
                if (this.compatibleForSameLabel(providerConfig, otherProvider)) continue;
                String name = providerConfig.getName();
                String otherName = otherProvider.getName();
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INCOMPATIBLE_PROVIDERS", (Object[])new Object[]{name, otherName}));
            }
            labelToConfig.put(label, providerConfig);
        }
    }

    private void validateTableNames(List<EntityProviderConfig> providerConfigs) {
        HashSet<String> uniqueTableNames = new HashSet<String>();
        for (EntityProviderConfig providerConfig : providerConfigs) {
            if (uniqueTableNames.add(providerConfig.getName())) continue;
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"GRAPH_TABLE_NAMES_MUST_BE_UNIQUE", (Object[])new Object[]{providerConfig.getName()}));
        }
    }

    private void validateNoSrcDestVertexProviders() {
        for (EntityProviderConfig providerConfig : this.getVertexProviders()) {
            String srcTableName = providerConfig.getSourceVertexProvider();
            if (srcTableName != null && !srcTableName.isEmpty()) {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"GRAPH_VERTEX_TABLE_CONTAINS_SRC_DEST", (Object[])new Object[0]));
            }
            String destTableName = providerConfig.getDestinationVertexProvider();
            if (destTableName == null || destTableName.isEmpty()) continue;
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"GRAPH_VERTEX_TABLE_CONTAINS_SRC_DEST", (Object[])new Object[0]));
        }
    }

    private void validateContainsSrcDestVertexProviders() {
        for (EntityProviderConfig providerConfig : this.getEdgeProviders()) {
            String srcTableName = providerConfig.getSourceVertexProvider();
            if (srcTableName == null || srcTableName.isEmpty()) {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"GRAPH_EDGE_TABLE_MISSING_SRC_DEST", (Object[])new Object[0]));
            }
            String destTableName = providerConfig.getDestinationVertexProvider();
            if (destTableName != null && !destTableName.isEmpty()) continue;
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"GRAPH_EDGE_TABLE_MISSING_SRC_DEST", (Object[])new Object[0]));
        }
    }

    private void validateSrcDestinationVertexProviders() {
        Map<String, IdType> vertexTableIdTypes = this.getVertexProviders().stream().collect(Collectors.toMap(EntityProviderConfig::getName, AbstractPartitionedGraphConfig::getSingleKeyTypeOrDefault));
        for (EntityProviderConfig edgeTableConfig : this.getEdgeProviders()) {
            String sourceVertexProviderName = edgeTableConfig.getSourceVertexProvider();
            String destinationVertexProviderName = edgeTableConfig.getDestinationVertexProvider();
            IdType sourceVertexIdType = vertexTableIdTypes.get(sourceVertexProviderName);
            IdType destinationVertexIdType = vertexTableIdTypes.get(destinationVertexProviderName);
            if (sourceVertexIdType == null) {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"GRAPH_EDGE_TABLE_WRONG_SRC_TABLE_NAME", (Object[])new Object[]{edgeTableConfig.getName(), sourceVertexProviderName}));
            }
            if (destinationVertexIdType == null) {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"GRAPH_EDGE_TABLE_WRONG_DEST_TABLE_NAME", (Object[])new Object[]{edgeTableConfig.getName(), destinationVertexProviderName}));
            }
            edgeTableConfig.setSourceVertexKeyType(sourceVertexIdType);
            edgeTableConfig.setDestinationVertexKeyType(destinationVertexIdType);
        }
    }

    private static IdType getSingleKeyTypeOrDefault(EntityProviderConfig providerConfig) {
        List<? extends KeyColumnDescriptor> keyColumns = providerConfig.getValidatedKeyColumns();
        if (keyColumns.size() == 1) {
            return keyColumns.get(0).getType();
        }
        return IdType.LONG;
    }

    private boolean isEmptyList(List<?> list) {
        return list == null || list.isEmpty();
    }

    private boolean areDefaultDatabaseConnectionSettingsEqual(AbstractPartitionedGraphConfig other) {
        if (!Objects.equals(this.getJdbcUrl(), other.getJdbcUrl())) {
            return false;
        }
        if (!Objects.equals(this.getUsername(), other.getUsername())) {
            return false;
        }
        if (!Objects.equals(this.getKeystoreAlias(), other.getKeystoreAlias())) {
            return false;
        }
        if (!Objects.equals(this.getMaxPrefetchedRows(), other.getMaxPrefetchedRows())) {
            return false;
        }
        if (!Objects.equals(this.getNumConnections(), other.getNumConnections())) {
            return false;
        }
        if (!Objects.equals(this.getDataSourceId(), other.getDataSourceId())) {
            return false;
        }
        return Objects.equals(this.getSchema(), other.getSchema());
    }

    private boolean equalsTableList(List<EntityProviderConfig> list1, List<EntityProviderConfig> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        return new HashSet<EntityProviderConfig>(list1).containsAll(new HashSet<EntityProviderConfig>(list2));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractPartitionedGraphConfig that = (AbstractPartitionedGraphConfig)o;
        if (!super.equals(that)) {
            return false;
        }
        if (!Objects.equals(this.getVertexProviders(), that.getVertexProviders())) {
            return false;
        }
        return Objects.equals(this.getEdgeProviders(), that.getEdgeProviders());
    }

    @Override
    public int hashCode() {
        int code = super.hashCode();
        if (!this.isEmptyList(this.getVertexProviders())) {
            for (EntityProviderConfig providerConfig : this.getVertexProviders()) {
                code += providerConfig.hashCode();
            }
        }
        if (!this.isEmptyList(this.getEdgeProviders())) {
            for (EntityProviderConfig providerConfig : this.getEdgeProviders()) {
                code += providerConfig.hashCode();
            }
        }
        return code;
    }

    @Override
    public Format getFormat() {
        return null;
    }

    @Override
    public List<GraphPropertyConfig> getVertexProps() {
        return Collections.emptyList();
    }

    @Override
    public List<GraphPropertyConfig> getEdgeProps() {
        return Collections.emptyList();
    }

    @Override
    public List<ExternalStoreConfig> getExternalStores() {
        throw new NotImplementedException(ErrorMessages.getMessage((String)"NOT_IMPLEMENTED", (Object[])new Object[0]));
    }

    public Integer getNumConnections(int machineCount, int defaultNumConnectionsTotal) {
        if (this.hasDefaultValue(PartitionedGraphConfig.Field.NUM_CONNECTIONS)) {
            return defaultNumConnectionsTotal;
        }
        return this.getNumConnections() * machineCount;
    }
}

