/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.internal;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import oracle.pgx.realm.client.RealmClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRealmClient
implements RealmClient {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractRealmClient.class);
    private String token;
    private long refreshTimeBeforeTokenExpiry;
    private Date tokenExpirationDate;

    public AbstractRealmClient(String token) {
        this.setToken(token);
        LOG.debug("Creating RealmClient with tokenExpirationDate = {} and refreshTimeBeforeTokenExpiry = {}s", (Object)this.tokenExpirationDate, (Object)this.refreshTimeBeforeTokenExpiry);
    }

    private final JWT parseToken(String token) {
        try {
            return JWTParser.parse((String)token);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Could not parse token: " + e.getMessage(), e);
        }
    }

    private final Date getTokenExpirationDate(JWT jwt) {
        try {
            return jwt.getJWTClaimsSet().getExpirationTime();
        }
        catch (NullPointerException | ParseException e) {
            throw new IllegalArgumentException("Could not retrieve expiration time from token: ", e);
        }
    }

    public void setToken(String token) {
        JWT jwt = this.parseToken(token);
        this.token = token;
        this.tokenExpirationDate = this.getTokenExpirationDate(jwt);
        this.refreshTimeBeforeTokenExpiry = this.getRefreshTimeBeforeTokenExpiry(jwt);
    }

    public String getToken() {
        try {
            Date actualDatePlusMargin = new Date(new Date().getTime() + this.refreshTimeBeforeTokenExpiry * 1000L);
            if (actualDatePlusMargin.after(this.tokenExpirationDate)) {
                LOG.debug("Refresh time before token expiry already met, refreshing token");
                this.setToken(this.refreshToken(this.token));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return this.token;
    }

    protected abstract String refreshToken(String var1) throws IOException;

    protected abstract long getRefreshTimeBeforeTokenExpiry(JWT var1);
}

