/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.vfs;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.pgx.common.AbstractPlugin;
import oracle.pgx.common.UserContext;
import oracle.pgx.vfs.HttpVirtualFile;
import oracle.pgx.vfs.VirtualFile;
import oracle.pgx.vfs.VirtualFileProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpsVirtualFileProvider
extends AbstractPlugin
implements VirtualFileProvider {
    private static final Logger LOG = LoggerFactory.getLogger(HttpsVirtualFileProvider.class);

    @Override
    public boolean schemePerformsNetworkCommunications(String scheme) {
        return true;
    }

    @Override
    public boolean schemeRequiresDirectoryWhiteListing(String scheme) {
        return false;
    }

    @Override
    public boolean schemePerformsInsecureRemoteLoading(String scheme) {
        return true;
    }

    @Override
    public List<String> getSchemes() {
        return Collections.singletonList("https");
    }

    @Override
    public VirtualFile resolve(String path, Map<String, String> attributes, UserContext userContext) throws IOException {
        if (LOG.isWarnEnabled() && attributes != null && !attributes.isEmpty()) {
            LOG.warn("ignoring unsupported attributes: {}", attributes);
        }
        return new HttpVirtualFile(path);
    }

    @Override
    public VirtualFile resolve(String parent, String relative, UserContext userContext) throws IOException {
        return new HttpVirtualFile(parent, relative);
    }
}

