/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.python;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import net.razorvine.pickle.objects.ClassDict;
import net.razorvine.pickle.objects.ClassDictConstructor;
import org.jpmml.model.ReflectionUtil;
import org.jpmml.python.Identifiable;

public class ClassDictConstructorUtil {
    private static final Field FIELD_MODULE = ReflectionUtil.getField(ClassDictConstructor.class, (String)"module");
    private static final Field FIELD_NAME = ReflectionUtil.getField(ClassDictConstructor.class, (String)"name");

    private ClassDictConstructorUtil() {
    }

    public static <C extends ClassDict> C construct(ClassDictConstructor dictConstructor, Class<? extends C> clazz) {
        String module = ClassDictConstructorUtil.getModule(dictConstructor);
        String name = ClassDictConstructorUtil.getName(dictConstructor);
        try {
            Constructor<C> constructor = clazz.getDeclaredConstructor(String.class, String.class);
            return (C)((ClassDict)clazz.cast(constructor.newInstance(module, name)));
        }
        catch (ReflectiveOperationException roe) {
            throw new RuntimeException(roe);
        }
    }

    public static Identifiable toIdentifiable(final ClassDictConstructor dictConstructor) {
        Identifiable result = new Identifiable(){

            @Override
            public String getModule() {
                return ClassDictConstructorUtil.getModule(dictConstructor);
            }

            @Override
            public String getName() {
                return ClassDictConstructorUtil.getName(dictConstructor);
            }
        };
        return result;
    }

    public static String getClassName(ClassDictConstructor dictConstructor) {
        return ClassDictConstructorUtil.getModule(dictConstructor) + "." + ClassDictConstructorUtil.getName(dictConstructor);
    }

    public static String getModule(ClassDictConstructor dictConstructor) {
        return (String)ReflectionUtil.getFieldValue((Field)FIELD_MODULE, (Object)dictConstructor);
    }

    public static String getName(ClassDictConstructor dictConstructor) {
        return (String)ReflectionUtil.getFieldValue((Field)FIELD_NAME, (Object)dictConstructor);
    }
}

