/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.text;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.text.TextDocument;
import org.jpmml.model.annotations.CollectionElementType;

@XmlRootElement(name="TextCorpus", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "textDocuments"})
@JsonRootName(value="TextCorpus")
@JsonPropertyOrder(value={"extensions", "textDocuments"})
public class TextCorpus
extends PMMLObject
implements HasExtensions<TextCorpus> {
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    @CollectionElementType(value=Extension.class)
    private List<Extension> extensions;
    @XmlElement(name="TextDocument", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="TextDocument")
    @CollectionElementType(value=TextDocument.class)
    private List<TextDocument> textDocuments;
    private static final long serialVersionUID = 67371272L;

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public TextCorpus addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasTextDocuments() {
        return this.textDocuments != null && !this.textDocuments.isEmpty();
    }

    public List<TextDocument> getTextDocuments() {
        if (this.textDocuments == null) {
            this.textDocuments = new ArrayList<TextDocument>();
        }
        return this.textDocuments;
    }

    public TextCorpus addTextDocuments(TextDocument ... textDocuments) {
        this.getTextDocuments().addAll(Arrays.asList(textDocuments));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE && this.hasTextDocuments()) {
                status = PMMLObject.traverse(visitor, this.getTextDocuments());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

