/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator.tree;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JVar;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jpmml.translator.JBlockUtil;
import org.jpmml.translator.JIfStatement;
import org.jpmml.translator.Scope;

public class NodeScope
extends Scope {
    public NodeScope(JIfStatement ifStatement) {
        super(ifStatement._then());
    }

    public int reInit() {
        JBlock block = this.getBlock();
        List objects = block.getContents();
        this.cleanVariableInfo();
        for (Object object : objects) {
            if (!(object instanceof JVar)) continue;
            JVar variable = (JVar)object;
            this.putVariable(variable);
        }
        return objects.size();
    }

    Object chainContent() {
        return this.chainContent(0);
    }

    Object chainContent(int offset) {
        JBlock block = this.getBlock();
        ArrayList objects = block.getContents();
        List passiveObjects = Collections.emptyList();
        ArrayList activeObjects = objects;
        if (offset > 0) {
            passiveObjects = new ArrayList(objects.subList(0, offset));
            activeObjects = new ArrayList(objects.subList(offset, activeObjects.size()));
        }
        if (activeObjects.size() == 0) {
            throw new IllegalStateException();
        }
        if (activeObjects.size() == 1) {
            return activeObjects.get(0);
        }
        Object result = activeObjects.get(activeObjects.size() - 1);
        List<Object> chainedActiveObjects = NodeScope.chainContent(activeObjects);
        JBlockUtil.clear(block);
        JBlockUtil.insertAll(block, passiveObjects);
        JBlockUtil.insertAll(block, chainedActiveObjects);
        return result;
    }

    static List<Object> chainContent(List<?> objects) {
        JIfStatement ifStatement;
        Object object;
        ArrayList<Object> result = new ArrayList<Object>();
        JIfStatement prevIfStatement = null;
        Iterator<?> objectIt = objects.iterator();
        while (prevIfStatement == null && objectIt.hasNext()) {
            object = objectIt.next();
            if (object instanceof JIfStatement) {
                ifStatement = (JIfStatement)object;
                result.add(ifStatement);
                prevIfStatement = ifStatement;
                continue;
            }
            result.add(object);
        }
        while (objectIt.hasNext()) {
            object = objectIt.next();
            if (object instanceof JIfStatement) {
                ifStatement = (JIfStatement)object;
                if (prevIfStatement.hasElse()) {
                    JBlock elseBlock = prevIfStatement._else();
                    elseBlock.add((JStatement)ifStatement);
                    prevIfStatement = ifStatement;
                    continue;
                }
                prevIfStatement = prevIfStatement._elseif(ifStatement);
                continue;
            }
            JBlock elseBlock = prevIfStatement._else();
            JBlockUtil.insert(elseBlock, object);
        }
        return result;
    }
}

