/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import org.jpmml.translator.TranslationContext;

public class JVarBuilder {
    private TranslationContext context = null;
    private JVar variable = null;

    public JVarBuilder(TranslationContext context) {
        this.setContext(context);
    }

    public JVarBuilder construct(Class<?> type, String name, Object ... args) {
        TranslationContext context = this.getContext();
        return this.construct(context.ref(type), name, args);
    }

    public JVarBuilder construct(JClass type, String name, Object ... args) {
        TranslationContext context = this.getContext();
        JInvocation invocation = context._new(type, args);
        return this.declare(type, name, (JExpression)invocation);
    }

    public JVarBuilder declare(Class<?> type, String name, JExpression init) {
        TranslationContext context = this.getContext();
        return this.declare(context.ref(type), name, init);
    }

    public JVarBuilder declare(JClass type, String name, JExpression init) {
        TranslationContext context = this.getContext();
        JVar variable = context.declare((JType)type, name, init);
        this.setVariable(variable);
        return this;
    }

    public JVarBuilder update(String method, Object ... args) {
        TranslationContext context = this.getContext();
        JVar variable = this.ensureVariable();
        JInvocation invocation = context.invoke(variable, method, args);
        context.add((JStatement)invocation);
        return this;
    }

    public JVarBuilder staticUpdate(Class<?> type, String method, Object ... args) {
        TranslationContext context = this.getContext();
        JVar variable = this.ensureVariable();
        JInvocation invocation = context.staticInvoke(type, method, args).arg((JExpression)variable);
        context.add((JStatement)invocation);
        return this;
    }

    public JVar ensureVariable() {
        JVar variable = this.getVariable();
        if (variable == null) {
            throw new IllegalStateException();
        }
        return variable;
    }

    public TranslationContext getContext() {
        return this.context;
    }

    private void setContext(TranslationContext context) {
        this.context = context;
    }

    public JVar getVariable() {
        return this.variable;
    }

    private void setVariable(JVar variable) {
        this.variable = variable;
    }
}

