/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator;

import com.sun.codemodel.JArray;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jpmml.translator.ArrayManager;

public abstract class ArraySetManager<E>
extends ArrayManager<E> {
    private Map<E, Integer> indices = new LinkedHashMap<E, Integer>();

    public ArraySetManager(JType componentType, String name) {
        super(componentType, name);
    }

    public abstract JExpression createExpression(E var1);

    @Override
    public List<E> getElements() {
        ArrayList<E> elements = new ArrayList<E>(this.indices.keySet());
        return elements;
    }

    @Override
    public int size() {
        return this.indices.size();
    }

    @Override
    public void initArray() {
        super.initArray();
        JArray array = this.getArray();
        Set<Map.Entry<E, Integer>> entries = this.indices.entrySet();
        for (Map.Entry entry : entries) {
            Object element = entry.getKey();
            array.add(this.createExpression(element));
        }
    }

    public JExpression getComponent(int index) {
        return this.getComponent(JExpr.lit((int)index));
    }

    public JExpression getComponent(JExpression indexExpr) {
        JFieldVar arrayVar = this.getArrayVar();
        if (arrayVar == null) {
            throw new IllegalStateException();
        }
        return arrayVar.component(indexExpr);
    }

    public int getOrInsert(E element) {
        Integer index = this.indices.get(element);
        if (index == null) {
            JArray array = this.getArray();
            if (array != null) {
                array.add(this.createExpression(element));
            }
            index = this.indices.size();
            this.indices.put(element, index);
        }
        return index;
    }
}

