/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.mining;

import com.google.common.collect.BiMap;
import com.google.common.collect.ForwardingMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.dmg.pmml.mining.Segment;
import org.jpmml.evaluator.HasEntityRegistry;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.mining.HasSegmentResults;
import org.jpmml.evaluator.mining.SegmentResult;

public abstract class SegmentationResult
extends ForwardingMap<String, Object>
implements HasEntityRegistry<Segment>,
HasSegmentResults {
    private Map<String, ?> results = null;

    SegmentationResult(Map<String, ?> results) {
        this.setResults(results);
    }

    public Map<String, Object> delegate() {
        Map<String, Object> results = this.getResults();
        return results;
    }

    public Map<String, ?> getResults(Iterable<String> segmentIds) {
        Iterator<String> it = segmentIds.iterator();
        String segmentId = it.next();
        SegmentResult segmentResult = this.getSegmentResult(segmentId);
        if (segmentResult == null) {
            return null;
        }
        while (it.hasNext()) {
            SegmentationResult segmentationResult = TypeUtil.cast(SegmentationResult.class, segmentResult.getResults());
            if ((segmentResult = segmentationResult.getSegmentResult(segmentId = it.next())) != null) continue;
            return null;
        }
        return segmentResult.getResults();
    }

    SegmentResult getSegmentResult(String id) {
        BiMap entityRegistry = this.getEntityRegistry();
        if (!entityRegistry.containsKey((Object)id)) {
            throw new IllegalArgumentException(id);
        }
        Collection segmentResults = this.getSegmentResults();
        if (segmentResults != null && !segmentResults.isEmpty()) {
            for (SegmentResult segmentResult : segmentResults) {
                if (!Objects.equals(segmentResult.getEntityId(), id)) continue;
                return segmentResult;
            }
        }
        return null;
    }

    public Map<String, ?> getResults() {
        return this.results;
    }

    void setResults(Map<String, ?> results) {
        this.results = Objects.requireNonNull(results);
    }
}

