/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.general_regression;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.DataType;
import org.dmg.pmml.HasValue;
import org.dmg.pmml.Matrix;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.general_regression.BaseCumHazardTables;
import org.dmg.pmml.general_regression.BaselineCell;
import org.dmg.pmml.general_regression.BaselineStratum;
import org.dmg.pmml.general_regression.Categories;
import org.dmg.pmml.general_regression.Category;
import org.dmg.pmml.general_regression.CovariateList;
import org.dmg.pmml.general_regression.FactorList;
import org.dmg.pmml.general_regression.GeneralRegressionModel;
import org.dmg.pmml.general_regression.PCell;
import org.dmg.pmml.general_regression.PMMLAttributes;
import org.dmg.pmml.general_regression.PPCell;
import org.dmg.pmml.general_regression.PPMatrix;
import org.dmg.pmml.general_regression.ParamMatrix;
import org.dmg.pmml.general_regression.Parameter;
import org.dmg.pmml.general_regression.ParameterCell;
import org.dmg.pmml.general_regression.ParameterList;
import org.dmg.pmml.general_regression.Predictor;
import org.dmg.pmml.general_regression.PredictorList;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.MapHolder;
import org.jpmml.evaluator.MatrixUtil;
import org.jpmml.evaluator.MissingFieldValueException;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.NumberUtil;
import org.jpmml.evaluator.Numbers;
import org.jpmml.evaluator.PMMLUtil;
import org.jpmml.evaluator.TargetField;
import org.jpmml.evaluator.TargetUtil;
import org.jpmml.evaluator.TypeInfo;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueFactory;
import org.jpmml.evaluator.ValueMap;
import org.jpmml.evaluator.ValueUtil;
import org.jpmml.evaluator.general_regression.GeneralRegressionModelUtil;
import org.jpmml.model.InvalidAttributeException;
import org.jpmml.model.InvalidElementException;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.UnsupportedAttributeException;
import org.jpmml.model.UnsupportedElementException;

public class GeneralRegressionModelEvaluator
extends ModelEvaluator<GeneralRegressionModel> {
    private BiMap<String, Parameter> parameterRegistry = ImmutableBiMap.of();
    private Map<Object, Map<String, Row>> ppMatrixMap = Collections.emptyMap();
    private Map<Object, List<PCell>> paramMatrixMap = Collections.emptyMap();
    private List<Object> targetCategories = null;

    private GeneralRegressionModelEvaluator() {
    }

    public GeneralRegressionModelEvaluator(PMML pmml) {
        this(pmml, PMMLUtil.findModel(pmml, GeneralRegressionModel.class));
    }

    public GeneralRegressionModelEvaluator(PMML pmml, GeneralRegressionModel generalRegressionModel) {
        super(pmml, generalRegressionModel);
        CovariateList covariateList;
        GeneralRegressionModel.ModelType modelType = generalRegressionModel.requireModelType();
        BiMap<String, Predictor> factorRegistry = ImmutableBiMap.of();
        BiMap<String, Predictor> covariateRegistry = ImmutableBiMap.of();
        ParameterList parameterList = generalRegressionModel.requireParameterList();
        this.parameterRegistry = ImmutableBiMap.copyOf(GeneralRegressionModelEvaluator.parseParameterRegistry(parameterList));
        FactorList factorList = generalRegressionModel.getFactorList();
        if (factorList != null && factorList.hasPredictors()) {
            factorRegistry = GeneralRegressionModelEvaluator.parsePredictorRegistry((PredictorList)factorList);
        }
        if ((covariateList = generalRegressionModel.getCovariateList()) != null && covariateList.hasPredictors()) {
            covariateRegistry = GeneralRegressionModelEvaluator.parsePredictorRegistry((PredictorList)covariateList);
        }
        PPMatrix ppMatrix = generalRegressionModel.requirePPMatrix();
        this.ppMatrixMap = Collections.unmodifiableMap(new LinkedHashMap<Object, Map<String, Row>>(GeneralRegressionModelEvaluator.toImmutableMapMap(GeneralRegressionModelEvaluator.parsePPMatrix(ppMatrix, factorRegistry, covariateRegistry))));
        ParamMatrix paramMatrix = generalRegressionModel.requireParamMatrix();
        this.paramMatrixMap = Collections.unmodifiableMap(new LinkedHashMap<Object, List<PCell>>(GeneralRegressionModelEvaluator.toImmutableListMap(GeneralRegressionModelEvaluator.parseParamMatrix(paramMatrix))));
    }

    @Override
    public String getSummary() {
        GeneralRegressionModel generalRegressionModel = (GeneralRegressionModel)this.getModel();
        GeneralRegressionModel.ModelType modelType = generalRegressionModel.requireModelType();
        switch (modelType) {
            case COX_REGRESSION: {
                return "Cox regression";
            }
        }
        return "General regression";
    }

    @Override
    protected <V extends Number> Map<String, ?> evaluateRegression(ValueFactory<V> valueFactory, EvaluationContext context) {
        GeneralRegressionModel generalRegressionModel = (GeneralRegressionModel)this.getModel();
        GeneralRegressionModel.ModelType modelType = generalRegressionModel.requireModelType();
        switch (modelType) {
            case COX_REGRESSION: {
                return this.evaluateCoxRegression(valueFactory, context);
            }
        }
        return this.evaluateGeneralRegression(valueFactory, context);
    }

    private <V extends Number> Map<String, ?> evaluateCoxRegression(ValueFactory<V> valueFactory, EvaluationContext context) {
        Number maxTime;
        List baselineCells;
        GeneralRegressionModel generalRegressionModel = (GeneralRegressionModel)this.getModel();
        TargetField targetField = this.getTargetField();
        String startTimeVariable = generalRegressionModel.getStartTimeVariable();
        String endTimeVariable = generalRegressionModel.getEndTimeVariable();
        if (endTimeVariable == null) {
            throw new MissingAttributeException((PMMLObject)generalRegressionModel, PMMLAttributes.GENERALREGRESSIONMODEL_ENDTIMEVARIABLE);
        }
        BaseCumHazardTables baseCumHazardTables = generalRegressionModel.requireBaseCumHazardTables();
        String baselineStrataVariable = generalRegressionModel.getBaselineStrataVariable();
        if (baselineStrataVariable != null) {
            FieldValue value = GeneralRegressionModelEvaluator.getVariable(baselineStrataVariable, context);
            BaselineStratum baselineStratum = GeneralRegressionModelEvaluator.getBaselineStratum(baseCumHazardTables, value);
            if (baselineStratum == null) {
                return TargetUtil.evaluateRegressionDefault(valueFactory, targetField);
            }
            baselineCells = baselineStratum.requireBaselineCells();
            maxTime = baselineStratum.requireMaxTime();
        } else {
            baselineCells = baseCumHazardTables.requireBaselineCells();
            maxTime = baseCumHazardTables.requireMaxTime();
        }
        Comparator<BaselineCell> comparator = new Comparator<BaselineCell>(){

            @Override
            public int compare(BaselineCell left, BaselineCell right) {
                Number leftTime = left.requireTime();
                Number rightTime = right.requireTime();
                return NumberUtil.compare(leftTime, rightTime);
            }
        };
        BaselineCell minBaselineCell = Collections.min(baselineCells, comparator);
        Number minTime = minBaselineCell.getTime();
        FieldValue value = GeneralRegressionModelEvaluator.getVariable(endTimeVariable, context);
        if (value.compareToValue(maxTime) > 0) {
            return TargetUtil.evaluateRegressionDefault(valueFactory, targetField);
        }
        if (value.compareToValue(minTime) < 0) {
            Value<V> cumHazard = valueFactory.newValue(Numbers.DOUBLE_ZERO);
            return TargetUtil.evaluateRegression(targetField, cumHazard);
        }
        final Number time = value.asNumber();
        Predicate<BaselineCell> predicate = new Predicate<BaselineCell>(){

            public boolean apply(BaselineCell baselineCell) {
                return NumberUtil.compare(baselineCell.getTime(), time) <= 0;
            }
        };
        BaselineCell maxTimeBaselineCell = Collections.max(Lists.newArrayList((Iterable)Iterables.filter((Iterable)baselineCells, (Predicate)predicate)), comparator);
        Number maxTimeCumHazard = maxTimeBaselineCell.getCumHazard();
        if (maxTimeCumHazard == null) {
            throw new MissingAttributeException((PMMLObject)maxTimeBaselineCell, PMMLAttributes.BASELINECELL_CUMHAZARD);
        }
        Value<V> r = this.computeDotProduct(valueFactory, context);
        Value<V> s = this.computeReferencePoint(valueFactory);
        if (r == null || s == null) {
            return TargetUtil.evaluateRegressionDefault(valueFactory, targetField);
        }
        Value<V> cumHazard = r.subtract(s).exp().multiply(maxTimeCumHazard);
        return TargetUtil.evaluateRegression(targetField, cumHazard);
    }

    private <V extends Number> Map<String, ?> evaluateGeneralRegression(ValueFactory<V> valueFactory, EvaluationContext context) {
        GeneralRegressionModel generalRegressionModel = (GeneralRegressionModel)this.getModel();
        TargetField targetField = this.getTargetField();
        Value<V> result = this.computeDotProduct(valueFactory, context);
        if (result == null) {
            return TargetUtil.evaluateRegressionDefault(valueFactory, targetField);
        }
        GeneralRegressionModel.ModelType modelType = generalRegressionModel.requireModelType();
        switch (modelType) {
            case REGRESSION: 
            case GENERAL_LINEAR: {
                break;
            }
            case GENERALIZED_LINEAR: {
                result = this.computeLink(result, context);
                break;
            }
            case COX_REGRESSION: 
            case MULTINOMIAL_LOGISTIC: 
            case ORDINAL_MULTINOMIAL: {
                throw new InvalidAttributeException((PMMLObject)generalRegressionModel, (Enum)modelType);
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)generalRegressionModel, (Enum)modelType);
            }
        }
        return TargetUtil.evaluateRegression(targetField, result);
    }

    @Override
    protected <V extends Number> Map<String, ? extends Classification<?, V>> evaluateClassification(ValueFactory<V> valueFactory, EvaluationContext context) {
        GeneralRegressionModel generalRegressionModel = (GeneralRegressionModel)this.getModel();
        TargetField targetField = this.getTargetField();
        List<Object> targetCategories = this.getTargetCategories();
        GeneralRegressionModel.ModelType modelType = generalRegressionModel.requireModelType();
        Map<Object, Map<String, Row>> ppMatrixMap = this.getPPMatrixMap();
        Map<Object, List<PCell>> paramMatrixMap = this.getParamMatrixMap();
        ValueMap<Object, Value<V>> values = new ValueMap<Object, Value<V>>(2 * targetCategories.size());
        Value<V> previousLinkValue = null;
        Value<V> previousCumulativeLinkValue = null;
        int max = targetCategories.size();
        for (int i = 0; i < max; ++i) {
            Value<V> value;
            Object targetCategory = targetCategories.get(i);
            if (i < max - 1) {
                Object parameterCells;
                Map<String, Row> parameterPredictorRows;
                if (ppMatrixMap.isEmpty()) {
                    parameterPredictorRows = Collections.emptyMap();
                } else {
                    parameterPredictorRows = ppMatrixMap.get(targetCategory);
                    if (parameterPredictorRows == null) {
                        parameterPredictorRows = ppMatrixMap.get(null);
                    }
                    if (parameterPredictorRows == null) {
                        PPMatrix ppMatrix = generalRegressionModel.getPPMatrix();
                        throw new InvalidElementException((PMMLObject)ppMatrix);
                    }
                }
                switch (modelType) {
                    case GENERALIZED_LINEAR: 
                    case MULTINOMIAL_LOGISTIC: {
                        parameterCells = paramMatrixMap.get(targetCategory);
                        if (parameterCells == null && targetCategories.size() == 2) {
                            parameterCells = paramMatrixMap.get(null);
                        }
                        if (parameterCells != null) break;
                        ParamMatrix paramMatrix = generalRegressionModel.getParamMatrix();
                        throw new InvalidElementException((PMMLObject)paramMatrix);
                    }
                    case ORDINAL_MULTINOMIAL: {
                        List<PCell> interceptCells = paramMatrixMap.get(targetCategory);
                        if (interceptCells == null || interceptCells.size() != 1) {
                            ParamMatrix paramMatrix = generalRegressionModel.getParamMatrix();
                            throw new InvalidElementException((PMMLObject)paramMatrix);
                        }
                        parameterCells = paramMatrixMap.get(null);
                        if (parameterCells == null) {
                            ParamMatrix paramMatrix = generalRegressionModel.getParamMatrix();
                            throw new InvalidElementException((PMMLObject)paramMatrix);
                        }
                        parameterCells = ImmutableList.copyOf((Iterable)Iterables.concat(parameterCells, interceptCells));
                        break;
                    }
                    case COX_REGRESSION: 
                    case REGRESSION: 
                    case GENERAL_LINEAR: {
                        throw new InvalidAttributeException((PMMLObject)generalRegressionModel, (Enum)modelType);
                    }
                    default: {
                        throw new UnsupportedAttributeException((PMMLObject)generalRegressionModel, (Enum)modelType);
                    }
                }
                if ((value = this.computeDotProduct(valueFactory, (List<PCell>)parameterCells, parameterPredictorRows, context)) == null) {
                    return TargetUtil.evaluateClassificationDefault(valueFactory, targetField);
                }
                switch (modelType) {
                    case GENERALIZED_LINEAR: {
                        value = this.computeLink(value, context);
                        break;
                    }
                    case MULTINOMIAL_LOGISTIC: {
                        value.exp();
                        break;
                    }
                    case ORDINAL_MULTINOMIAL: {
                        value = this.computeCumulativeLink(value, context);
                        break;
                    }
                    case COX_REGRESSION: 
                    case REGRESSION: 
                    case GENERAL_LINEAR: {
                        throw new InvalidAttributeException((PMMLObject)generalRegressionModel, (Enum)modelType);
                    }
                    default: {
                        throw new UnsupportedAttributeException((PMMLObject)generalRegressionModel, (Enum)modelType);
                    }
                }
            } else {
                switch (modelType) {
                    case GENERALIZED_LINEAR: {
                        value = valueFactory.newValue(Numbers.DOUBLE_ONE);
                        if (previousLinkValue == null) break;
                        value.subtract(previousLinkValue);
                        break;
                    }
                    case MULTINOMIAL_LOGISTIC: {
                        value = valueFactory.newValue(Numbers.DOUBLE_ZERO).exp();
                        break;
                    }
                    case ORDINAL_MULTINOMIAL: {
                        value = valueFactory.newValue(Numbers.DOUBLE_ONE);
                        break;
                    }
                    case COX_REGRESSION: 
                    case REGRESSION: 
                    case GENERAL_LINEAR: {
                        throw new InvalidAttributeException((PMMLObject)generalRegressionModel, (Enum)modelType);
                    }
                    default: {
                        throw new UnsupportedAttributeException((PMMLObject)generalRegressionModel, (Enum)modelType);
                    }
                }
            }
            switch (modelType) {
                case GENERALIZED_LINEAR: {
                    previousLinkValue = value;
                    break;
                }
                case MULTINOMIAL_LOGISTIC: {
                    break;
                }
                case ORDINAL_MULTINOMIAL: {
                    Value<V> cumulativeLinkValue = value.copy();
                    if (previousCumulativeLinkValue != null) {
                        value.subtract(previousCumulativeLinkValue);
                    }
                    previousCumulativeLinkValue = cumulativeLinkValue;
                    break;
                }
                case COX_REGRESSION: 
                case REGRESSION: 
                case GENERAL_LINEAR: {
                    throw new InvalidAttributeException((PMMLObject)generalRegressionModel, (Enum)modelType);
                }
                default: {
                    throw new UnsupportedAttributeException((PMMLObject)generalRegressionModel, (Enum)modelType);
                }
            }
            values.put(targetCategory, value);
        }
        switch (modelType) {
            case GENERALIZED_LINEAR: {
                break;
            }
            case MULTINOMIAL_LOGISTIC: {
                ValueUtil.normalizeSimpleMax(values);
                break;
            }
            case ORDINAL_MULTINOMIAL: {
                break;
            }
            case COX_REGRESSION: 
            case REGRESSION: 
            case GENERAL_LINEAR: {
                throw new InvalidAttributeException((PMMLObject)generalRegressionModel, (Enum)modelType);
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)generalRegressionModel, (Enum)modelType);
            }
        }
        Classification result = this.createClassification(values);
        return TargetUtil.evaluateClassification(targetField, result);
    }

    private <V extends Number> Value<V> computeDotProduct(ValueFactory<V> valueFactory, EvaluationContext context) {
        Map<String, Row> parameterPredictorRows;
        GeneralRegressionModel generalRegressionModel = (GeneralRegressionModel)this.getModel();
        Map<Object, Map<String, Row>> ppMatrixMap = this.getPPMatrixMap();
        if (ppMatrixMap.isEmpty()) {
            parameterPredictorRows = Collections.emptyMap();
        } else {
            parameterPredictorRows = ppMatrixMap.get(null);
            if (parameterPredictorRows == null) {
                PPMatrix ppMatrix = generalRegressionModel.getPPMatrix();
                throw new InvalidElementException((PMMLObject)ppMatrix);
            }
        }
        Map<Object, List<PCell>> paramMatrixMap = this.getParamMatrixMap();
        List<PCell> parameterCells = paramMatrixMap.get(null);
        if (paramMatrixMap.size() != 1 || parameterCells == null) {
            ParamMatrix paramMatrix = generalRegressionModel.getParamMatrix();
            throw new InvalidElementException((PMMLObject)paramMatrix);
        }
        return this.computeDotProduct(valueFactory, parameterCells, parameterPredictorRows, context);
    }

    private <V extends Number> Value<V> computeDotProduct(ValueFactory<V> valueFactory, List<PCell> parameterCells, Map<String, Row> parameterPredictorRows, EvaluationContext context) {
        Value<V> result = null;
        int max = parameterCells.size();
        for (int i = 0; i < max; ++i) {
            Row parameterPredictorRow;
            PCell parameterCell = parameterCells.get(i);
            String parameterName = parameterCell.requireParameterName();
            Number beta = parameterCell.requireBeta();
            if (result == null) {
                result = valueFactory.newValue();
            }
            if ((parameterPredictorRow = parameterPredictorRows.get(parameterName)) != null) {
                Value<V> x = parameterPredictorRow.evaluate(valueFactory, context);
                if (x == null) {
                    return null;
                }
                result.add(beta, (Number)x.getValue());
                continue;
            }
            result.add(beta);
        }
        return result;
    }

    private <V extends Number> Value<V> computeReferencePoint(ValueFactory<V> valueFactory) {
        GeneralRegressionModel generalRegressionModel = (GeneralRegressionModel)this.getModel();
        BiMap<String, Parameter> parameters = this.getParameterRegistry();
        Map<Object, List<PCell>> paramMatrixMap = this.getParamMatrixMap();
        List<PCell> parameterCells = paramMatrixMap.get(null);
        if (paramMatrixMap.size() != 1 || parameterCells == null) {
            ParamMatrix paramMatrix = generalRegressionModel.getParamMatrix();
            throw new InvalidElementException((PMMLObject)paramMatrix);
        }
        Value<V> result = null;
        int max = parameterCells.size();
        for (int i = 0; i < max; ++i) {
            Parameter parameter;
            PCell parameterCell = parameterCells.get(i);
            String parameterName = parameterCell.requireParameterName();
            Number beta = parameterCell.requireBeta();
            if (result == null) {
                result = valueFactory.newValue();
            }
            if ((parameter = (Parameter)parameters.get((Object)parameterName)) == null) {
                return null;
            }
            result.add(beta, parameter.getReferencePoint());
        }
        return result;
    }

    private <V extends Number> Value<V> computeLink(Value<V> value, EvaluationContext context) {
        GeneralRegressionModel generalRegressionModel = (GeneralRegressionModel)this.getModel();
        Number distParameter = null;
        Number linkParameter = null;
        GeneralRegressionModel.LinkFunction linkFunction = generalRegressionModel.requireLinkFunction();
        switch (linkFunction) {
            case CLOGLOG: 
            case IDENTITY: 
            case LOG: 
            case LOGC: 
            case LOGIT: 
            case LOGLOG: {
                break;
            }
            case NEGBIN: {
                distParameter = generalRegressionModel.requireDistParameter();
                break;
            }
            case ODDSPOWER: 
            case POWER: {
                linkParameter = generalRegressionModel.requireLinkParameter();
                break;
            }
            case PROBIT: {
                break;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)generalRegressionModel, (Enum)linkFunction);
            }
        }
        Number offset = GeneralRegressionModelEvaluator.getOffset(generalRegressionModel, context);
        if (offset != null) {
            value.add(offset);
        }
        GeneralRegressionModelUtil.computeLink(linkFunction, distParameter, linkParameter, value);
        Integer trials = GeneralRegressionModelEvaluator.getTrials(generalRegressionModel, context);
        if (trials != null) {
            value.multiply(trials);
        }
        return value;
    }

    private <V extends Number> Value<V> computeCumulativeLink(Value<V> value, EvaluationContext context) {
        GeneralRegressionModel generalRegressionModel = (GeneralRegressionModel)this.getModel();
        Number offset = GeneralRegressionModelEvaluator.getOffset(generalRegressionModel, context);
        if (offset != null) {
            value.add(offset);
        }
        GeneralRegressionModel.CumulativeLinkFunction cumulativeLinkFunction = generalRegressionModel.requireCumulativeLinkFunction();
        switch (cumulativeLinkFunction) {
            case LOGIT: 
            case PROBIT: 
            case CLOGLOG: 
            case LOGLOG: 
            case CAUCHIT: {
                GeneralRegressionModelUtil.computeCumulativeLink(cumulativeLinkFunction, value);
                break;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)generalRegressionModel, (Enum)cumulativeLinkFunction);
            }
        }
        return value;
    }

    public BiMap<String, Parameter> getParameterRegistry() {
        return this.parameterRegistry;
    }

    private Map<Object, Map<String, Row>> getPPMatrixMap() {
        return this.ppMatrixMap;
    }

    private Map<Object, List<PCell>> getParamMatrixMap() {
        return this.paramMatrixMap;
    }

    private List<Object> getTargetCategories() {
        if (this.targetCategories == null) {
            this.targetCategories = ImmutableList.copyOf(this.parseTargetCategories());
        }
        return this.targetCategories;
    }

    private List<Object> parseTargetCategories() {
        GeneralRegressionModel generalRegressionModel = (GeneralRegressionModel)this.getModel();
        TargetField targetField = this.getTargetField();
        OpType opType = targetField.getOpType();
        switch (opType) {
            case CATEGORICAL: 
            case ORDINAL: {
                break;
            }
            default: {
                throw new InvalidElementException((PMMLObject)generalRegressionModel);
            }
        }
        List<Object> targetCategories = targetField.getCategories();
        if (targetCategories == null || targetCategories.size() < 2) {
            throw new InvalidElementException((PMMLObject)generalRegressionModel);
        }
        Object targetReferenceCategory = generalRegressionModel.getTargetReferenceCategory();
        GeneralRegressionModel.ModelType modelType = generalRegressionModel.requireModelType();
        switch (modelType) {
            case GENERALIZED_LINEAR: 
            case MULTINOMIAL_LOGISTIC: {
                if (targetReferenceCategory != null) break;
                final Map<Object, List<PCell>> paramMatrixMap = this.getParamMatrixMap();
                Predicate<Object> predicate = new Predicate<Object>(){

                    public boolean apply(Object targetCategory) {
                        return !paramMatrixMap.containsKey(targetCategory);
                    }
                };
                HashSet targetReferenceCategories = Sets.newHashSet((Iterable)Iterables.filter(targetCategories, (Predicate)predicate));
                if (targetReferenceCategories.size() != 1) {
                    ParamMatrix paramMatrix = generalRegressionModel.getParamMatrix();
                    throw new InvalidElementException((PMMLObject)paramMatrix);
                }
                targetReferenceCategory = Iterables.getOnlyElement((Iterable)targetReferenceCategories);
                break;
            }
            case ORDINAL_MULTINOMIAL: {
                break;
            }
            case COX_REGRESSION: 
            case REGRESSION: 
            case GENERAL_LINEAR: {
                throw new InvalidAttributeException((PMMLObject)generalRegressionModel, (Enum)modelType);
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)generalRegressionModel, (Enum)modelType);
            }
        }
        if (targetReferenceCategory != null && (targetCategories = new ArrayList<Object>(targetCategories)).remove(targetReferenceCategory)) {
            targetCategories.add(targetReferenceCategory);
        }
        return targetCategories;
    }

    private static Number getOffset(GeneralRegressionModel generalRegressionModel, EvaluationContext context) {
        String offsetVariable = generalRegressionModel.getOffsetVariable();
        if (offsetVariable != null) {
            FieldValue value = GeneralRegressionModelEvaluator.getVariable(offsetVariable, context);
            return value.asNumber();
        }
        return generalRegressionModel.getOffsetValue();
    }

    private static Integer getTrials(GeneralRegressionModel generalRegressionModel, EvaluationContext context) {
        String trialsVariable = generalRegressionModel.getTrialsVariable();
        if (trialsVariable != null) {
            FieldValue value = GeneralRegressionModelEvaluator.getVariable(trialsVariable, context);
            return value.asInteger();
        }
        return generalRegressionModel.getTrialsValue();
    }

    private static FieldValue getVariable(String name, EvaluationContext context) {
        FieldValue value = context.evaluate(name);
        if (FieldValueUtil.isMissing(value)) {
            throw new MissingFieldValueException(name);
        }
        return value;
    }

    private static BaselineStratum getBaselineStratum(BaseCumHazardTables baseCumHazardTables, FieldValue value) {
        if (baseCumHazardTables instanceof MapHolder) {
            MapHolder mapHolder = (MapHolder)baseCumHazardTables;
            return (BaselineStratum)mapHolder.get(value.getDataType(), value.getValue());
        }
        List baselineStrata = baseCumHazardTables.requireBaselineStrata();
        int max = baselineStrata.size();
        for (int i = 0; i < max; ++i) {
            BaselineStratum baselineStratum = (BaselineStratum)baselineStrata.get(i);
            Object category = baselineStratum.requireValue();
            if (!value.equalsValue(category)) continue;
            return baselineStratum;
        }
        return null;
    }

    private static BiMap<String, Parameter> parseParameterRegistry(ParameterList parameterList) {
        HashBiMap result = HashBiMap.create();
        if (!parameterList.hasParameters()) {
            return result;
        }
        List parameters = parameterList.getParameters();
        for (Parameter parameter : parameters) {
            result.put((Object)parameter.requireName(), (Object)parameter);
        }
        return result;
    }

    private static BiMap<String, Predictor> parsePredictorRegistry(PredictorList predictorList) {
        HashBiMap result = HashBiMap.create();
        List predictors = predictorList.getPredictors();
        for (Predictor predictor : predictors) {
            result.put((Object)predictor.requireField(), (Object)predictor);
        }
        return result;
    }

    private static Map<Object, Map<String, Row>> parsePPMatrix(PPMatrix ppMatrix, final BiMap<String, Predictor> factors, final BiMap<String, Predictor> covariates) {
        Function<List<PPCell>, Row> function = new Function<List<PPCell>, Row>(){

            public Row apply(List<PPCell> ppCells) {
                Row result = new Row();
                for (PPCell ppCell : ppCells) {
                    String fieldName = ppCell.requireField();
                    Predictor factor = (Predictor)factors.get((Object)fieldName);
                    if (factor != null) {
                        result.addFactor(ppCell, factor);
                        continue;
                    }
                    Predictor covariate = (Predictor)covariates.get((Object)fieldName);
                    if (covariate != null) {
                        result.addCovariate(ppCell);
                        continue;
                    }
                    throw new InvalidAttributeException((PMMLObject)ppCell, PMMLAttributes.PPCELL_FIELD, (Object)fieldName);
                }
                return result;
            }
        };
        ListMultimap targetCategoryMap = GeneralRegressionModelEvaluator.groupByTargetCategory(ppMatrix.getPPCells());
        LinkedHashMap<Object, Map<String, Row>> result = new LinkedHashMap<Object, Map<String, Row>>();
        Set targetCategoryEntries = Multimaps.asMap(targetCategoryMap).entrySet();
        for (Map.Entry entry : targetCategoryEntries) {
            LinkedHashMap<String, Row> predictorMap = new LinkedHashMap<String, Row>();
            ListMultimap parameterNameMap = GeneralRegressionModelEvaluator.groupByParameterName((List)entry.getValue());
            Set parameterNameEntries = Multimaps.asMap(parameterNameMap).entrySet();
            for (Map.Entry entry2 : parameterNameEntries) {
                predictorMap.put((String)entry2.getKey(), (Row)function.apply((Object)((List)entry2.getValue())));
            }
            result.put(entry.getKey(), predictorMap);
        }
        return result;
    }

    private static Map<Object, List<PCell>> parseParamMatrix(ParamMatrix paramMatrix) {
        ListMultimap targetCategoryCells = GeneralRegressionModelEvaluator.groupByTargetCategory(paramMatrix.getPCells());
        return new LinkedHashMap<Object, List<PCell>>(Multimaps.asMap(targetCategoryCells));
    }

    private static <C extends ParameterCell> ListMultimap<String, C> groupByParameterName(List<C> cells) {
        return GeneralRegressionModelEvaluator.groupCells(cells, ParameterCell::getParameterName);
    }

    private static <C extends ParameterCell> ListMultimap<Object, C> groupByTargetCategory(List<C> cells) {
        return GeneralRegressionModelEvaluator.groupCells(cells, ParameterCell::getTargetCategory);
    }

    private static <K, C extends ParameterCell> ListMultimap<K, C> groupCells(List<C> cells, Function<C, K> function) {
        ArrayListMultimap result = ArrayListMultimap.create();
        for (ParameterCell cell : cells) {
            result.put(function.apply((Object)cell), (Object)cell);
        }
        return result;
    }

    private static class Row
    implements Serializable {
        private List<FactorHandler> factorHandlers = new ArrayList<FactorHandler>();
        private List<CovariateHandler> covariateHandlers = new ArrayList<CovariateHandler>();

        private Row() {
        }

        public <V extends Number> Value<V> evaluate(ValueFactory<V> valueFactory, EvaluationContext context) {
            Value<V> result = valueFactory.newValue(Numbers.DOUBLE_ONE);
            List<FactorHandler> factorHandlers = this.getFactorHandlers();
            int max = factorHandlers.size();
            for (int i = 0; i < max; ++i) {
                FactorHandler factorHandler = factorHandlers.get(i);
                FieldValue value = context.evaluate(factorHandler.getField());
                if (FieldValueUtil.isMissing(value)) {
                    return null;
                }
                factorHandler.updateProduct(result, value);
            }
            if (result.isZero()) {
                return result;
            }
            List<CovariateHandler> covariateHandlers = this.getCovariateHandlers();
            int max2 = covariateHandlers.size();
            for (int i = 0; i < max2; ++i) {
                CovariateHandler covariateHandler = covariateHandlers.get(i);
                FieldValue value = context.evaluate(covariateHandler.getField());
                if (FieldValueUtil.isMissing(value)) {
                    return null;
                }
                covariateHandler.updateProduct(result, value);
            }
            return result;
        }

        public void addFactor(PPCell ppCell, Predictor predictor) {
            List<FactorHandler> factorHandlers = this.getFactorHandlers();
            Matrix matrix = predictor.getMatrix();
            if (matrix != null) {
                Categories categories = predictor.getCategories();
                if (categories == null) {
                    throw new UnsupportedElementException((PMMLObject)predictor);
                }
                ArrayList<Object> values = new ArrayList<Object>();
                for (Category category : categories) {
                    values.add(category.requireValue());
                }
                factorHandlers.add(new ContrastMatrixHandler(ppCell, matrix, values));
            } else {
                factorHandlers.add(new FactorHandler(ppCell));
            }
        }

        private void addCovariate(PPCell ppCell) {
            List<CovariateHandler> covariateHandlers = this.getCovariateHandlers();
            covariateHandlers.add(new CovariateHandler(ppCell));
        }

        public List<FactorHandler> getFactorHandlers() {
            return this.factorHandlers;
        }

        public List<CovariateHandler> getCovariateHandlers() {
            return this.covariateHandlers;
        }

        private static class CovariateHandler
        extends PredictorHandler {
            private Number exponent = null;

            private CovariateHandler() {
            }

            private CovariateHandler(PPCell ppCell) {
                super(ppCell);
                Object value = ppCell.requireValue();
                Number exponent = (Number)TypeUtil.parseOrCast(DataType.DOUBLE, value);
                if (exponent.doubleValue() == 1.0) {
                    exponent = null;
                }
                this.setExponent(exponent);
            }

            @Override
            public <V extends Number> Value<V> updateProduct(Value<V> product, FieldValue value) {
                Number exponent = this.getExponent();
                if (exponent != null) {
                    return product.multiply(value.asNumber(), exponent);
                }
                return product.multiply(value.asNumber());
            }

            public Number getExponent() {
                return this.exponent;
            }

            private void setExponent(Number exponent) {
                this.exponent = exponent;
            }
        }

        private static class ContrastMatrixHandler
        extends FactorHandler {
            private Matrix matrix = null;
            private List<Object> categories = null;
            private List<FieldValue> parsedCategories = null;

            private ContrastMatrixHandler() {
            }

            private ContrastMatrixHandler(PPCell ppCell, Matrix matrix, List<Object> categories) {
                super(ppCell);
                this.setMatrix(matrix);
                this.setCategories(categories);
            }

            @Override
            public <V extends Number> Value<V> updateProduct(Value<V> product, FieldValue value) {
                Matrix matrix = this.getMatrix();
                int row = this.getIndex(value);
                int column = this.getIndex(this.getCategory());
                if (row < 0 || column < 0) {
                    PPCell ppCell = this.getPPCell();
                    throw new InvalidElementException((PMMLObject)ppCell);
                }
                Number result = MatrixUtil.getElementAt(matrix, row + 1, column + 1);
                if (result == null) {
                    throw new InvalidElementException((PMMLObject)matrix);
                }
                return product.multiply(result);
            }

            public int getIndex(FieldValue value) {
                if (this.parsedCategories == null) {
                    this.parsedCategories = this.parseCategories(value);
                }
                return this.parsedCategories.indexOf(value);
            }

            public int getIndex(Object category) {
                List<Object> categories = this.getCategories();
                return categories.indexOf(category);
            }

            private List<FieldValue> parseCategories(TypeInfo typeInfo) {
                List<Object> categories = this.getCategories();
                return new ArrayList<FieldValue>(Lists.transform(categories, category -> FieldValueUtil.create(typeInfo, category)));
            }

            public Matrix getMatrix() {
                return this.matrix;
            }

            private void setMatrix(Matrix matrix) {
                this.matrix = matrix;
            }

            public List<Object> getCategories() {
                return this.categories;
            }

            private void setCategories(List<Object> categories) {
                this.categories = categories;
            }
        }

        private static class FactorHandler
        extends PredictorHandler {
            private Object category = null;

            private FactorHandler() {
            }

            private FactorHandler(PPCell ppCell) {
                super(ppCell);
                Object value = ppCell.requireValue();
                this.setCategory(value);
            }

            @Override
            public <V extends Number> Value<V> updateProduct(Value<V> product, FieldValue value) {
                PPCell ppCell = this.getPPCell();
                boolean equals = value.equals((HasValue<?>)ppCell);
                return equals ? product : product.multiply(Numbers.DOUBLE_ZERO);
            }

            public Object getCategory() {
                return this.category;
            }

            private void setCategory(Object category) {
                this.category = category;
            }
        }

        private static abstract class PredictorHandler
        implements Serializable {
            private PPCell ppCell = null;

            private PredictorHandler() {
            }

            private PredictorHandler(PPCell ppCell) {
                this.setPPCell(ppCell);
                String fieldName = ppCell.requireField();
            }

            public abstract <V extends Number> Value<V> updateProduct(Value<V> var1, FieldValue var2);

            public String getField() {
                PPCell ppCell = this.getPPCell();
                return ppCell.requireField();
            }

            public PPCell getPPCell() {
                return this.ppCell;
            }

            private void setPPCell(PPCell ppCell) {
                this.ppCell = ppCell;
            }
        }
    }
}

