/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import de.siegmar.fastcsv.writer.CsvWriter;
import de.siegmar.fastcsv.writer.LineDelimiter;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jpmml.evaluator.Table;

public class TableWriter {
    private CsvWriter.CsvWriterBuilder csvWriterBuilder = null;

    public TableWriter(char separator) {
        this(TableWriter.createCsvWriterBuilder(separator));
    }

    public TableWriter(CsvWriter.CsvWriterBuilder csvWriterBuilder) {
        this.setCsvWriterBuilder(csvWriterBuilder);
    }

    public void write(Table table, OutputStream os) throws IOException {
        this.write(table, new OutputStreamWriter(os, "UTF-8"));
    }

    public void write(Table table, Writer writer) throws IOException {
        CsvWriter.CsvWriterBuilder csvWriterBuilder = this.getCsvWriterBuilder();
        FilterWriter safeWriter = new FilterWriter(writer){

            @Override
            public void close() throws IOException {
                super.flush();
            }
        };
        try (CsvWriter csvWriter = csvWriterBuilder.build((Writer)safeWriter);){
            List<String> columns = table.getColumns();
            csvWriter.writeRecord(columns);
            int numberOfRows = table.getNumberOfRows();
            if (numberOfRows > 0) {
                Table.Row row = table.createWriterRow(0);
                for (int i = 0; i < numberOfRows; ++i) {
                    Collection cells = row.values();
                    csvWriter.writeRecord(cells);
                    row.advance();
                }
            }
        }
    }

    public CsvWriter.CsvWriterBuilder getCsvWriterBuilder() {
        return this.csvWriterBuilder;
    }

    private void setCsvWriterBuilder(CsvWriter.CsvWriterBuilder csvWriterBuilder) {
        this.csvWriterBuilder = Objects.requireNonNull(csvWriterBuilder);
    }

    public static CsvWriter.CsvWriterBuilder createCsvWriterBuilder(char separator) {
        CsvWriter.CsvWriterBuilder csvWriterBuilder = CsvWriter.builder().lineDelimiter(LineDelimiter.PLATFORM).fieldSeparator(separator);
        return csvWriterBuilder;
    }
}

