/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.ResultFeature;
import org.jpmml.evaluator.ModelEvaluatorBuilder;
import org.jpmml.evaluator.ModelEvaluatorFactory;
import org.jpmml.evaluator.OutputFilter;
import org.jpmml.evaluator.PMMLUtil;
import org.jpmml.evaluator.SymbolTable;
import org.jpmml.evaluator.ValueFactoryFactory;

public class ServiceLoadingModelEvaluatorBuilder
extends ModelEvaluatorBuilder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceLoadingModelEvaluatorBuilder loadService(URL url) throws IOException {
        URLClassLoader clazzLoader = new URLClassLoader(new URL[]{url});
        try {
            ServiceLoadingModelEvaluatorBuilder serviceLoadingModelEvaluatorBuilder = this.loadService(clazzLoader, (String)null);
            return serviceLoadingModelEvaluatorBuilder;
        }
        finally {
            if (clazzLoader instanceof Closeable) {
                URLClassLoader closeable = clazzLoader;
                closeable.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceLoadingModelEvaluatorBuilder loadService(URL url, String modelName) throws IOException {
        URLClassLoader clazzLoader = new URLClassLoader(new URL[]{url});
        try {
            ServiceLoadingModelEvaluatorBuilder serviceLoadingModelEvaluatorBuilder = this.loadService(clazzLoader, modelName);
            return serviceLoadingModelEvaluatorBuilder;
        }
        finally {
            if (clazzLoader instanceof Closeable) {
                URLClassLoader closeable = clazzLoader;
                closeable.close();
            }
        }
    }

    public ServiceLoadingModelEvaluatorBuilder loadService(ClassLoader clazzLoader, String modelName) {
        PMML pmml;
        Iterator<PMML> pmmlIt;
        try {
            ServiceLoader<PMML> serviceLoader = ServiceLoader.load(PMML.class, clazzLoader);
            pmmlIt = serviceLoader.iterator();
        }
        catch (ServiceConfigurationError sce) {
            throw new IllegalArgumentException("PMML service provider configuration is not loadable", sce);
        }
        if (pmmlIt.hasNext()) {
            try {
                pmml = pmmlIt.next();
            }
            catch (ServiceConfigurationError sce) {
                throw new IllegalArgumentException("PMML service provider is not instantiable", sce);
            }
            if (pmmlIt.hasNext()) {
                throw new IllegalArgumentException("Expected one PMML service provider, got more than one PMML service providers");
            }
        } else {
            throw new IllegalArgumentException("Expected one PMML service provider, got zero PMML service providers");
        }
        Model model = PMMLUtil.findModel(pmml, modelName);
        this.setPMML(pmml);
        this.setModel(model);
        return this;
    }

    @Override
    public ServiceLoadingModelEvaluatorBuilder clone() {
        return (ServiceLoadingModelEvaluatorBuilder)super.clone();
    }

    @Override
    protected ServiceLoadingModelEvaluatorBuilder setPMML(PMML pmml) {
        return (ServiceLoadingModelEvaluatorBuilder)super.setPMML(pmml);
    }

    @Override
    protected ServiceLoadingModelEvaluatorBuilder setModel(Model model) {
        return (ServiceLoadingModelEvaluatorBuilder)super.setModel(model);
    }

    @Override
    public ServiceLoadingModelEvaluatorBuilder setModelEvaluatorFactory(ModelEvaluatorFactory modelEvaluatorFactory) {
        return (ServiceLoadingModelEvaluatorBuilder)super.setModelEvaluatorFactory(modelEvaluatorFactory);
    }

    @Override
    public ServiceLoadingModelEvaluatorBuilder setValueFactoryFactory(ValueFactoryFactory valueFactoryFactory) {
        return (ServiceLoadingModelEvaluatorBuilder)super.setValueFactoryFactory(valueFactoryFactory);
    }

    @Override
    public ServiceLoadingModelEvaluatorBuilder setOutputFilter(OutputFilter outputFilter) {
        return (ServiceLoadingModelEvaluatorBuilder)super.setOutputFilter(outputFilter);
    }

    @Override
    public ServiceLoadingModelEvaluatorBuilder setDerivedFieldGuard(SymbolTable<String> derivedFieldGuard) {
        return (ServiceLoadingModelEvaluatorBuilder)super.setDerivedFieldGuard(derivedFieldGuard);
    }

    @Override
    public ServiceLoadingModelEvaluatorBuilder setFunctionGuard(SymbolTable<String> functionGuard) {
        return (ServiceLoadingModelEvaluatorBuilder)super.setFunctionGuard(functionGuard);
    }

    @Override
    public ServiceLoadingModelEvaluatorBuilder setExtraResultFeatures(Set<ResultFeature> extraResultFeatures) {
        return (ServiceLoadingModelEvaluatorBuilder)super.setExtraResultFeatures(extraResultFeatures);
    }

    @Override
    public ServiceLoadingModelEvaluatorBuilder setCheckSchema(boolean checkSchema) {
        return (ServiceLoadingModelEvaluatorBuilder)super.setCheckSchema(checkSchema);
    }
}

