/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import org.jpmml.evaluator.EvaluatorUtil;
import org.jpmml.evaluator.ModelField;
import org.jpmml.evaluator.ResultField;
import org.jpmml.evaluator.Table;
import org.jpmml.evaluator.TableCollector;

@IgnoreJRERequirement
public class ResultTableCollector
extends TableCollector {
    private List<? extends ResultField> resultFields = null;
    private boolean decode = false;

    public ResultTableCollector(List<? extends ResultField> resultFields) {
        this(resultFields, true);
    }

    public ResultTableCollector(List<? extends ResultField> resultFields, boolean decode) {
        this.setResultFields(resultFields);
        this.setDecode(decode);
    }

    @Override
    protected Table createFinisherTable(int initialSize) {
        List<? extends ResultField> resultFields = this.getResultFields();
        List<String> columns = resultFields.stream().map(ModelField::getName).collect(Collectors.toList());
        return new Table(columns, initialSize);
    }

    @Override
    protected Table.Row createFinisherRow(Table table) {
        final boolean decode = this.getDecode();
        final HashSet<String> columns = new HashSet<String>(table.getColumns());
        Table table2 = table;
        Objects.requireNonNull(table2);
        Table.Row result = new Table.Row(table2, 0, -1){
            {
                Table table = x0;
                Objects.requireNonNull(table);
                super(table, origin, fence);
            }

            @Override
            public Object put(String key, Object value) {
                if (!columns.contains(key)) {
                    return null;
                }
                if (decode) {
                    value = EvaluatorUtil.decode(value);
                }
                return super.put(key, value);
            }
        };
        return result;
    }

    public List<? extends ResultField> getResultFields() {
        return this.resultFields;
    }

    public void setResultFields(List<? extends ResultField> resultFields) {
        this.resultFields = Objects.requireNonNull(resultFields);
    }

    public boolean getDecode() {
        return this.decode;
    }

    private void setDecode(boolean decode) {
        this.decode = decode;
    }
}

