/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import org.jpmml.evaluator.AndroidFieldValueMap;
import org.jpmml.evaluator.FieldValue;

class FieldValueMap
extends HashMap<Object, FieldValue> {
    protected static boolean JDK8_API;

    FieldValueMap() {
    }

    FieldValueMap(int capacity) {
        super(capacity);
    }

    @Override
    @IgnoreJRERequirement
    public FieldValue getOrDefault(Object key, FieldValue defaultValue) {
        return super.getOrDefault(key, defaultValue);
    }

    @Override
    @IgnoreJRERequirement
    public FieldValue putIfAbsent(Object key, FieldValue value) {
        return super.putIfAbsent(key, value);
    }

    public static FieldValueMap create() {
        if (JDK8_API) {
            return new FieldValueMap();
        }
        return new AndroidFieldValueMap();
    }

    public static FieldValueMap create(int numberOfVisibleFields) {
        int initialCapacity = numberOfVisibleFields <= 256 ? Math.max(2 * numberOfVisibleFields, 16) : numberOfVisibleFields;
        if (JDK8_API) {
            return new FieldValueMap(initialCapacity);
        }
        return new AndroidFieldValueMap(initialCapacity);
    }

    static {
        boolean jdk8_api;
        try {
            Map.class.getMethod("getOrDefault", Object.class, Object.class);
            Map.class.getMethod("putIfAbsent", Object.class, Object.class);
            jdk8_api = true;
        }
        catch (ReflectiveOperationException roe) {
            jdk8_api = false;
        }
        JDK8_API = jdk8_api;
    }
}

