/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import org.jpmml.evaluator.NormalDistributionUtil;
import org.jpmml.evaluator.Operation;
import org.jpmml.evaluator.Value;

public class DoubleValue
extends Value<Double> {
    protected double value = 0.0;
    public static final double E = Math.E;
    public static final double PI = Math.PI;

    @Operation(value="${0}")
    public DoubleValue(double value) {
        this.value = value;
    }

    @Operation(value="${0}")
    public DoubleValue(Number value) {
        this.value = value.doubleValue();
    }

    @Override
    public int compareTo(Value<Double> that) {
        return Double.compare(this.doubleValue(), that.doubleValue());
    }

    public String toString() {
        return Double.toString(this.value);
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.value);
        return (int)(bits ^ bits >>> 32);
    }

    public boolean equals(Object object) {
        if (object instanceof DoubleValue) {
            DoubleValue that = (DoubleValue)object;
            return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(that.value);
        }
        return false;
    }

    public DoubleValue copy() {
        return new DoubleValue(this.value);
    }

    public DoubleValue reset(Number value) {
        this.value = value.doubleValue();
        return this;
    }

    public DoubleValue add(Number value) {
        this.value += value.doubleValue();
        return this;
    }

    public DoubleValue add(Value<? extends Number> value) {
        this.value += value.doubleValue();
        return this;
    }

    public DoubleValue add(Number coefficient, Number factor) {
        this.value += coefficient.doubleValue() * factor.doubleValue();
        return this;
    }

    public DoubleValue add(Number coefficient, Number firstFactor, Number secondFactor) {
        this.value += coefficient.doubleValue() * firstFactor.doubleValue() * secondFactor.doubleValue();
        return this;
    }

    public DoubleValue add(Number coefficient, Number ... factors) {
        double value = coefficient.doubleValue();
        for (Number factor : factors) {
            value *= factor.doubleValue();
        }
        this.value += value;
        return this;
    }

    public DoubleValue add(Number coefficient, Number factor, int exponent) {
        this.value += coefficient.doubleValue() * Math.pow(factor.doubleValue(), exponent);
        return this;
    }

    public DoubleValue subtract(Number value) {
        this.value -= value.doubleValue();
        return this;
    }

    public DoubleValue subtract(Value<? extends Number> value) {
        this.value -= value.doubleValue();
        return this;
    }

    public DoubleValue multiply(Number value) {
        this.value *= value.doubleValue();
        return this;
    }

    public DoubleValue multiply(Value<? extends Number> value) {
        this.value *= value.doubleValue();
        return this;
    }

    public DoubleValue multiply(Number factor, Number exponent) {
        this.value *= Math.pow(factor.doubleValue(), exponent.doubleValue());
        return this;
    }

    public DoubleValue divide(Number value) {
        this.value /= value.doubleValue();
        return this;
    }

    public DoubleValue divide(Value<? extends Number> value) {
        this.value /= value.doubleValue();
        return this;
    }

    public DoubleValue residual(Value<? extends Number> value) {
        this.value = 1.0 - value.doubleValue();
        return this;
    }

    public DoubleValue square() {
        this.value *= this.value;
        return this;
    }

    public DoubleValue power(Number value) {
        this.value = Math.pow(this.value, value.doubleValue());
        return this;
    }

    public DoubleValue reciprocal() {
        this.value = 1.0 / this.value;
        return this;
    }

    public DoubleValue elliott() {
        this.value /= 1.0 + Math.abs(this.value);
        return this;
    }

    public DoubleValue exp() {
        this.value = Math.exp(this.value);
        return this;
    }

    public DoubleValue ln() {
        this.value = Math.log(this.value);
        return this;
    }

    public DoubleValue gauss() {
        this.value = Math.exp(-(this.value * this.value));
        return this;
    }

    public DoubleValue inverseLogit() {
        this.value = 1.0 / (1.0 + Math.exp(-this.value));
        return this;
    }

    public DoubleValue inverseCloglog() {
        this.value = 1.0 - Math.exp(-Math.exp(this.value));
        return this;
    }

    public DoubleValue inverseLoglog() {
        this.value = Math.exp(-Math.exp(-this.value));
        return this;
    }

    public DoubleValue inverseLogc() {
        this.value = 1.0 - Math.exp(this.value);
        return this;
    }

    public DoubleValue inverseNegbin(Number value) {
        this.value = 1.0 / (value.doubleValue() * (Math.exp(-this.value) - 1.0));
        return this;
    }

    public DoubleValue inverseOddspower(Number value) {
        return this.inverseOddspowerInternal(value.doubleValue());
    }

    private DoubleValue inverseOddspowerInternal(double value) {
        this.value = value < 0.0 || value > 0.0 ? 1.0 / (1.0 + Math.pow(1.0 + value * this.value, -(1.0 / value))) : 1.0 / (1.0 + Math.exp(-this.value));
        return this;
    }

    public DoubleValue inversePower(Number value) {
        return this.inversePowerInternal(value.doubleValue());
    }

    private DoubleValue inversePowerInternal(double value) {
        this.value = value < 0.0 || value > 0.0 ? Math.pow(this.value, 1.0 / value) : Math.exp(this.value);
        return this;
    }

    public DoubleValue inverseCauchit() {
        this.value = 0.5 + 0.3183098861837907 * Math.atan(this.value);
        return this;
    }

    public DoubleValue inverseProbit() {
        this.value = NormalDistributionUtil.cumulativeProbability(this.value);
        return this;
    }

    public DoubleValue sin() {
        this.value = Math.sin(this.value);
        return this;
    }

    public DoubleValue cos() {
        this.value = Math.cos(this.value);
        return this;
    }

    public DoubleValue arctan() {
        this.value = 2.0 * Math.atan(this.value) / Math.PI;
        return this;
    }

    public DoubleValue tanh() {
        this.value = Math.tanh(this.value);
        return this;
    }

    public DoubleValue threshold(Number value) {
        this.value = this.value > value.doubleValue() ? 1.0 : 0.0;
        return this;
    }

    public DoubleValue relu() {
        this.value = Math.max(this.value, 0.0);
        return this;
    }

    public DoubleValue abs() {
        this.value = Math.abs(this.value);
        return this;
    }

    public DoubleValue gaussSim(Number value) {
        this.value = Math.exp(-Math.log(2.0) * this.value * this.value / (value.doubleValue() * value.doubleValue()));
        return this;
    }

    public DoubleValue restrict(Number lowValue, Number highValue) {
        this.value = Math.max(this.value, lowValue.doubleValue());
        this.value = Math.min(this.value, highValue.doubleValue());
        return this;
    }

    public DoubleValue round() {
        this.value = Math.round(this.value);
        return this;
    }

    public DoubleValue ceiling() {
        this.value = Math.ceil(this.value);
        return this;
    }

    public DoubleValue floor() {
        this.value = Math.floor(this.value);
        return this;
    }

    public DoubleValue normalize(Number leftOrig, Number leftNorm, Number rightOrig, Number rightNorm) {
        return this.normalizeInternal(leftOrig.doubleValue(), leftNorm.doubleValue(), rightOrig.doubleValue(), rightNorm.doubleValue());
    }

    private DoubleValue normalizeInternal(double leftOrig, double leftNorm, double rightOrig, double rightNorm) {
        this.value = leftNorm + (this.value - leftOrig) / (rightOrig - leftOrig) * (rightNorm - leftNorm);
        return this;
    }

    public DoubleValue denormalize(Number leftOrig, Number leftNorm, Number rightOrig, Number rightNorm) {
        return this.denormalizeInternal(leftOrig.doubleValue(), leftNorm.doubleValue(), rightOrig.doubleValue(), rightNorm.doubleValue());
    }

    private DoubleValue denormalizeInternal(double leftOrig, double leftNorm, double rightOrig, double rightNorm) {
        this.value = (this.value - leftNorm) / (rightNorm - leftNorm) * (rightOrig - leftOrig) + leftOrig;
        return this;
    }

    @Override
    public boolean isZero() {
        return this.value == 0.0;
    }

    @Override
    public boolean isOne() {
        return this.value == 1.0;
    }

    @Override
    public boolean equals(Number value) {
        return this.value == value.doubleValue();
    }

    @Override
    public int compareTo(Number value) {
        return Double.compare(this.value, value.doubleValue());
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public Double getValue() {
        return this.value;
    }
}

