/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.codemodel;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.SetMultimap;
import com.google.common.reflect.ClassPath;
import com.google.common.reflect.Reflection;
import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JResourceFile;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.tools.DiagnosticCollector;
import javax.tools.DiagnosticListener;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.jpmml.codemodel.ByteArrayClassFileObject;
import org.jpmml.codemodel.ClassPathClassFileObject;
import org.jpmml.codemodel.FileObjectUtil;
import org.jpmml.codemodel.JClassFile;
import org.jpmml.codemodel.NullCodeWriter;
import org.jpmml.codemodel.StringSourceFileObject;

public class CompilerUtil {
    private static Iterable<String> options = Arrays.asList("-source", "11", "-target", "11");

    private CompilerUtil() {
    }

    public static void compile(JCodeModel codeModel) throws IOException {
        CompilerUtil.compile(codeModel, null, null, null);
    }

    public static void compile(JCodeModel codeModel, JavaCompiler compiler, DiagnosticListener<? super JavaFileObject> diagnosticListener, ClassLoader classLoader) throws IOException {
        boolean success;
        if (compiler == null && (compiler = ToolProvider.getSystemJavaCompiler()) == null) {
            throw new IOException();
        }
        if (diagnosticListener == null) {
            diagnosticListener = new DiagnosticCollector<JavaFileObject>();
        }
        if (classLoader == null) {
            Thread thread = Thread.currentThread();
            classLoader = thread.getContextClassLoader();
        }
        ArrayList<StringSourceFileObject> sourceObjects = new ArrayList<StringSourceFileObject>();
        ArrayList<ByteArrayClassFileObject> classObjects = new ArrayList<ByteArrayClassFileObject>();
        CodeWriter sourceWriter = CompilerUtil.createSourceObjectCodeWriter(sourceObjects);
        CodeWriter resourceWriter = CompilerUtil.createResourceCodeWriter();
        codeModel.build(sourceWriter, resourceWriter);
        try (StandardJavaFileManager standardFileManager = compiler.getStandardFileManager(diagnosticListener, null, null);){
            standardFileManager.setLocation(StandardLocation.SOURCE_PATH, Collections.emptyList());
            try (JavaFileManager classObjectFileManager = CompilerUtil.createClassObjectJavaFileManager(standardFileManager, classLoader, classObjects);){
                JavaCompiler.CompilationTask task = compiler.getTask(null, classObjectFileManager, diagnosticListener, options, null, sourceObjects);
                success = task.call();
            }
        }
        if (!success) {
            throw new IOException();
        }
        for (ByteArrayClassFileObject classObject : classObjects) {
            JClassFile classFile = classObject.toClassFile();
            String packageName = classObject.getPackageName();
            JPackage _package = "".equals(packageName) ? codeModel.rootPackage() : codeModel._package(packageName);
            _package.addResourceFile((JResourceFile)classFile);
        }
    }

    public Iterable<String> getOptions() {
        return options;
    }

    public void setOptions(Iterable<String> options) {
        CompilerUtil.options = Objects.requireNonNull(options);
    }

    private static CodeWriter createSourceObjectCodeWriter(final List<StringSourceFileObject> sourceObjects) {
        CodeWriter codeWriter = new CodeWriter(){
            private StringSourceFileObject sourceObject = null;

            public OutputStream openBinary(JPackage _package, String name) {
                this.openSourceObject(FileObjectUtil.toResourceName(_package, name));
                FilterOutputStream result = new FilterOutputStream(this.sourceObject.openOutputStream()){

                    @Override
                    public void close() throws IOException {
                        super.close();
                        this.closeSourceObject();
                    }
                };
                return result;
            }

            public void close() {
            }

            private void openSourceObject(String name) {
                this.sourceObject = new StringSourceFileObject(name, this.encoding);
            }

            private void closeSourceObject() {
                sourceObjects.add(this.sourceObject);
                this.sourceObject = null;
            }
        };
        return codeWriter;
    }

    private static CodeWriter createResourceCodeWriter() {
        NullCodeWriter codeWriter = new NullCodeWriter();
        return codeWriter;
    }

    private static JavaFileManager createClassObjectJavaFileManager(StandardJavaFileManager standardFileManager, final ClassLoader classLoader, final List<ByteArrayClassFileObject> classObjects) {
        ForwardingJavaFileManager<StandardJavaFileManager> fileManager = new ForwardingJavaFileManager<StandardJavaFileManager>(standardFileManager){
            private SetMultimap<String, ClassPath.ClassInfo> classPathMap;
            {
                super(arg0);
                this.classPathMap = null;
            }

            @Override
            public boolean contains(JavaFileManager.Location location, FileObject fileObject) throws IOException {
                boolean result = super.contains(location, fileObject);
                if (StandardLocation.SOURCE_PATH.equals(location)) {
                    return fileObject instanceof StringSourceFileObject;
                }
                return result;
            }

            @Override
            public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
                Collection<ClassPathClassFileObject> classLoaderObjects;
                Iterable result = super.list(location, packageName, kinds, recurse);
                if (StandardLocation.CLASS_PATH.equals(location) && kinds.contains((Object)JavaFileObject.Kind.CLASS) && (classLoaderObjects = this.listClassFileObjects(packageName.replace('/', '.'), recurse)).size() > 0) {
                    result = Iterables.concat(result, classLoaderObjects);
                }
                return result;
            }

            @Override
            public String inferBinaryName(JavaFileManager.Location location, JavaFileObject fileObject) {
                if (StandardLocation.CLASS_PATH.equals(location) && fileObject instanceof ClassPathClassFileObject) {
                    ClassPathClassFileObject classObject = (ClassPathClassFileObject)fileObject;
                    return classObject.getBinaryName();
                }
                return super.inferBinaryName(location, fileObject);
            }

            @Override
            public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String name, JavaFileObject.Kind kind) throws IOException {
                ClassPathClassFileObject classLoaderObject;
                if (StandardLocation.CLASS_PATH.equals(location) && JavaFileObject.Kind.CLASS.equals((Object)kind) && (classLoaderObject = this.getClassFileObject(name.replace('/', '.'))) != null) {
                    return classLoaderObject;
                }
                return super.getJavaFileForInput(location, name, kind);
            }

            @Override
            public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String name, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
                if (StandardLocation.CLASS_OUTPUT.equals(location) && JavaFileObject.Kind.CLASS.equals((Object)kind)) {
                    ByteArrayClassFileObject classObject = new ByteArrayClassFileObject(name);
                    classObjects.add(classObject);
                    return classObject;
                }
                return super.getJavaFileForOutput(location, name, kind, sibling);
            }

            private Collection<ClassPathClassFileObject> listClassFileObjects(String packageName, boolean recurse) throws IOException {
                SetMultimap<String, ClassPath.ClassInfo> classPathMap = this.getClassPathMap();
                Set entries = classPathMap.asMap().entrySet();
                Set<ClassPathClassFileObject> result = entries.stream().filter(entry -> recurse ? ((String)entry.getKey()).startsWith(packageName + ".") : ((String)entry.getKey()).equals(packageName)).flatMap(entry -> ((Collection)entry.getValue()).stream()).map(classInfo -> new ClassPathClassFileObject((ClassPath.ClassInfo)classInfo)).collect(Collectors.toSet());
                return result;
            }

            private ClassPathClassFileObject getClassFileObject(String name) throws IOException {
                SetMultimap<String, ClassPath.ClassInfo> classPathMap = this.getClassPathMap();
                Set classInfos = classPathMap.get((Object)Reflection.getPackageName((String)name));
                if (classInfos != null) {
                    ClassPathClassFileObject result = classInfos.stream().filter(classInfo -> classInfo.getName().equals(name)).map(classInfo -> new ClassPathClassFileObject((ClassPath.ClassInfo)classInfo)).findFirst().orElse(null);
                    return result;
                }
                return null;
            }

            private SetMultimap<String, ClassPath.ClassInfo> getClassPathMap() throws IOException {
                if (this.classPathMap == null) {
                    this.classPathMap = this.createClassPathMap();
                }
                return this.classPathMap;
            }

            private SetMultimap<String, ClassPath.ClassInfo> createClassPathMap() throws IOException {
                ClassPath classPath = ClassPath.from((ClassLoader)classLoader);
                ImmutableSetMultimap.Builder resultBuilder = ImmutableSetMultimap.builder();
                ImmutableSet classInfos = classPath.getAllClasses();
                for (ClassPath.ClassInfo classInfo : classInfos) {
                    resultBuilder.put((Object)Reflection.getPackageName((String)classInfo.getName()), (Object)classInfo);
                }
                return resultBuilder.build();
            }
        };
        return fileManager;
    }
}

