/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.codemodel;

import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.jpmml.codemodel.ClassFileObject;

public class ClassPathClassFileObject
extends ClassFileObject {
    private ClassPath.ClassInfo classInfo = null;

    public ClassPathClassFileObject(ClassPath.ClassInfo classInfo) {
        super("classpath", classInfo != null ? classInfo.getName() : null);
        this.setClassInfo(classInfo);
    }

    @Override
    public InputStream openInputStream() throws IOException {
        ClassPath.ClassInfo classInfo = this.getClassInfo();
        return classInfo.url().openStream();
    }

    public String getBinaryName() {
        ClassPath.ClassInfo classInfo = this.getClassInfo();
        return classInfo.getName();
    }

    public ClassPath.ClassInfo getClassInfo() {
        return this.classInfo;
    }

    private void setClassInfo(ClassPath.ClassInfo classInfo) {
        this.classInfo = Objects.requireNonNull(classInfo);
    }
}

