# Copyright (C) 2021-2022 Greenbone Networks GmbH
#
# SPDX-License-Identifier: AGPL-3.0-or-later
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.

from dataclasses import dataclass
from typing import Dict

from ..models.advisory import Advisory
from .packages.package import Package


@dataclass
class PackageVulnerability:
    """Represents a vulnerable package on a host"""

    host_ip: str
    host_name: str
    packages: Dict[Package, Package]
    advisory: Advisory

    def __init__(
        self,
        host_ip: str,
        host_name: str,
        package: Package,
        fixed_package: Package,
        advisory: Advisory,
    ) -> None:
        self.host_ip = host_ip
        self.host_name = host_name
        self.packages = {}
        self.packages[package] = fixed_package
        self.advisory = advisory

    def add_package(self, package: Package, fixed_package: Package):
        self.packages[package] = fixed_package
