# Generated by Django 3.2.18 on 2024-05-02 16:05

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='recipient',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='Enter recipient name', max_length=200)),
                ('email_address', models.EmailField(help_text='Enter recipient Email ID', max_length=254, unique=True)),
            ],
        ),
        migrations.CreateModel(
            name='subject',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('subject', models.CharField(default='OpenLXP Conformance Alerts', help_text='Enter Subject for email', max_length=200)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='template',
            fields=[
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('template_id', models.BigAutoField(primary_key=True, serialize=False)),
                ('template_type', models.CharField(help_text='Enter Template Type', max_length=200, unique=True)),
                ('template_body', models.TextField(blank=True, help_text='Enter Email Message', null=True)),
                ('template_inputs', models.JSONField(blank=True, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='email',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('sender', models.EmailField(blank=True, max_length=254, null=True)),
                ('reference', models.CharField(help_text='Enter email reference', max_length=200, unique=True)),
                ('recipients', models.ManyToManyField(blank=True, related_name='email_recipients', to='openlxp_P1_notification.recipient')),
                ('subject', models.ForeignKey(blank=True, help_text='Select Email Subject', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='email_subject', to='openlxp_P1_notification.subject')),
                ('template_type', models.ForeignKey(blank=True, help_text='Select Email Template', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='email_template', to='openlxp_P1_notification.template')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
