# mypy-boto3-ssm

[![PyPI - mypy-boto3-ssm](https://img.shields.io/pypi/v/mypy-boto3-ssm.svg?color=blue)](https://pypi.org/project/mypy-boto3-ssm)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-ssm.svg?color=blue)](https://pypi.org/project/mypy-boto3-ssm)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.SSM 1.14.55](https://boto3.amazonaws.com/v1/documentation/api/1.14.55/reference/services/ssm.html#SSM) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 3.0.4](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-ssm](#mypy-boto3-ssm)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `SSM` service.

```bash
python -m pip install boto3-stubs[ssm]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[ssm]` in your environment: `python -m pip install 'boto3-stubs[ssm]'`

Both type checking and auto-complete should work for `SSM` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[ssm]` in your environment: `python -m pip install 'boto3-stubs[ssm]'`

Both type checking and auto-complete should work for `SSM` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[ssm]` in your environment: `python -m pip install 'boto3-stubs[ssm]'`
- Run `mypy` as usual

Type checking should work for `SSM` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[ssm]` in your environment: `python -m pip install 'boto3-stubs[ssm]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `SSM` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`SSMClient` provides annotations for `boto3.client("ssm")`.

```python
import boto3

from mypy_boto3_ssm import SSMClient

client: SSMClient = boto3.client("ssm")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: SSMClient = session.client("ssm")
```

### Paginators annotations

`mypy_boto3_ssm.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_ssm import SSMClient
from mypy_boto3_ssm.paginator import (
    DescribeActivationsPaginator,
    DescribeAssociationExecutionsPaginator,
    DescribeAssociationExecutionTargetsPaginator,
    DescribeAutomationExecutionsPaginator,
    DescribeAutomationStepExecutionsPaginator,
    DescribeAvailablePatchesPaginator,
    DescribeEffectiveInstanceAssociationsPaginator,
    DescribeEffectivePatchesForPatchBaselinePaginator,
    DescribeInstanceAssociationsStatusPaginator,
    DescribeInstanceInformationPaginator,
    DescribeInstancePatchesPaginator,
    DescribeInstancePatchStatesForPatchGroupPaginator,
    DescribeInstancePatchStatesPaginator,
    DescribeInventoryDeletionsPaginator,
    DescribeMaintenanceWindowExecutionsPaginator,
    DescribeMaintenanceWindowExecutionTaskInvocationsPaginator,
    DescribeMaintenanceWindowExecutionTasksPaginator,
    DescribeMaintenanceWindowSchedulePaginator,
    DescribeMaintenanceWindowsForTargetPaginator,
    DescribeMaintenanceWindowsPaginator,
    DescribeMaintenanceWindowTargetsPaginator,
    DescribeMaintenanceWindowTasksPaginator,
    DescribeOpsItemsPaginator,
    DescribeParametersPaginator,
    DescribePatchBaselinesPaginator,
    DescribePatchGroupsPaginator,
    DescribePatchPropertiesPaginator,
    DescribeSessionsPaginator,
    GetInventoryPaginator,
    GetInventorySchemaPaginator,
    GetOpsSummaryPaginator,
    GetParameterHistoryPaginator,
    GetParametersByPathPaginator,
    ListAssociationsPaginator,
    ListAssociationVersionsPaginator,
    ListCommandInvocationsPaginator,
    ListCommandsPaginator,
    ListComplianceItemsPaginator,
    ListComplianceSummariesPaginator,
    ListDocumentsPaginator,
    ListDocumentVersionsPaginator,
    ListResourceComplianceSummariesPaginator,
    ListResourceDataSyncPaginator,
)

client: SSMClient = boto3.client("ssm")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_activations_paginator: DescribeActivationsPaginator = client.get_paginator("describe_activations")
describe_association_execution_targets_paginator: DescribeAssociationExecutionTargetsPaginator = client.get_paginator("describe_association_execution_targets")
describe_association_executions_paginator: DescribeAssociationExecutionsPaginator = client.get_paginator("describe_association_executions")
describe_automation_executions_paginator: DescribeAutomationExecutionsPaginator = client.get_paginator("describe_automation_executions")
describe_automation_step_executions_paginator: DescribeAutomationStepExecutionsPaginator = client.get_paginator("describe_automation_step_executions")
describe_available_patches_paginator: DescribeAvailablePatchesPaginator = client.get_paginator("describe_available_patches")
describe_effective_instance_associations_paginator: DescribeEffectiveInstanceAssociationsPaginator = client.get_paginator("describe_effective_instance_associations")
describe_effective_patches_for_patch_baseline_paginator: DescribeEffectivePatchesForPatchBaselinePaginator = client.get_paginator("describe_effective_patches_for_patch_baseline")
describe_instance_associations_status_paginator: DescribeInstanceAssociationsStatusPaginator = client.get_paginator("describe_instance_associations_status")
describe_instance_information_paginator: DescribeInstanceInformationPaginator = client.get_paginator("describe_instance_information")
describe_instance_patch_states_paginator: DescribeInstancePatchStatesPaginator = client.get_paginator("describe_instance_patch_states")
describe_instance_patch_states_for_patch_group_paginator: DescribeInstancePatchStatesForPatchGroupPaginator = client.get_paginator("describe_instance_patch_states_for_patch_group")
describe_instance_patches_paginator: DescribeInstancePatchesPaginator = client.get_paginator("describe_instance_patches")
describe_inventory_deletions_paginator: DescribeInventoryDeletionsPaginator = client.get_paginator("describe_inventory_deletions")
describe_maintenance_window_execution_task_invocations_paginator: DescribeMaintenanceWindowExecutionTaskInvocationsPaginator = client.get_paginator("describe_maintenance_window_execution_task_invocations")
describe_maintenance_window_execution_tasks_paginator: DescribeMaintenanceWindowExecutionTasksPaginator = client.get_paginator("describe_maintenance_window_execution_tasks")
describe_maintenance_window_executions_paginator: DescribeMaintenanceWindowExecutionsPaginator = client.get_paginator("describe_maintenance_window_executions")
describe_maintenance_window_schedule_paginator: DescribeMaintenanceWindowSchedulePaginator = client.get_paginator("describe_maintenance_window_schedule")
describe_maintenance_window_targets_paginator: DescribeMaintenanceWindowTargetsPaginator = client.get_paginator("describe_maintenance_window_targets")
describe_maintenance_window_tasks_paginator: DescribeMaintenanceWindowTasksPaginator = client.get_paginator("describe_maintenance_window_tasks")
describe_maintenance_windows_paginator: DescribeMaintenanceWindowsPaginator = client.get_paginator("describe_maintenance_windows")
describe_maintenance_windows_for_target_paginator: DescribeMaintenanceWindowsForTargetPaginator = client.get_paginator("describe_maintenance_windows_for_target")
describe_ops_items_paginator: DescribeOpsItemsPaginator = client.get_paginator("describe_ops_items")
describe_parameters_paginator: DescribeParametersPaginator = client.get_paginator("describe_parameters")
describe_patch_baselines_paginator: DescribePatchBaselinesPaginator = client.get_paginator("describe_patch_baselines")
describe_patch_groups_paginator: DescribePatchGroupsPaginator = client.get_paginator("describe_patch_groups")
describe_patch_properties_paginator: DescribePatchPropertiesPaginator = client.get_paginator("describe_patch_properties")
describe_sessions_paginator: DescribeSessionsPaginator = client.get_paginator("describe_sessions")
get_inventory_paginator: GetInventoryPaginator = client.get_paginator("get_inventory")
get_inventory_schema_paginator: GetInventorySchemaPaginator = client.get_paginator("get_inventory_schema")
get_ops_summary_paginator: GetOpsSummaryPaginator = client.get_paginator("get_ops_summary")
get_parameter_history_paginator: GetParameterHistoryPaginator = client.get_paginator("get_parameter_history")
get_parameters_by_path_paginator: GetParametersByPathPaginator = client.get_paginator("get_parameters_by_path")
list_association_versions_paginator: ListAssociationVersionsPaginator = client.get_paginator("list_association_versions")
list_associations_paginator: ListAssociationsPaginator = client.get_paginator("list_associations")
list_command_invocations_paginator: ListCommandInvocationsPaginator = client.get_paginator("list_command_invocations")
list_commands_paginator: ListCommandsPaginator = client.get_paginator("list_commands")
list_compliance_items_paginator: ListComplianceItemsPaginator = client.get_paginator("list_compliance_items")
list_compliance_summaries_paginator: ListComplianceSummariesPaginator = client.get_paginator("list_compliance_summaries")
list_document_versions_paginator: ListDocumentVersionsPaginator = client.get_paginator("list_document_versions")
list_documents_paginator: ListDocumentsPaginator = client.get_paginator("list_documents")
list_resource_compliance_summaries_paginator: ListResourceComplianceSummariesPaginator = client.get_paginator("list_resource_compliance_summaries")
list_resource_data_sync_paginator: ListResourceDataSyncPaginator = client.get_paginator("list_resource_data_sync")
```


### Waiters annotations

`mypy_boto3_ssm.waiter` module contains type annotations for all waiters.

```python
from mypy_boto3_ssm import SSMClient
from mypy_boto3_ssm.waiter import CommandExecutedWaiter

client: SSMClient = boto3.client("ssm")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
command_executed_waiter: CommandExecutedWaiter = client.get_waiter("command_executed")
```





### Typed dictionations

`mypy_boto3_ssm.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_ssm.type_defs import (
    AccountSharingInfoTypeDef,
    ActivationTypeDef,
    AssociationDescriptionTypeDef,
    AssociationExecutionFilterTypeDef,
    AssociationExecutionTargetsFilterTypeDef,
    AssociationExecutionTargetTypeDef,
    AssociationExecutionTypeDef,
    AssociationFilterTypeDef,
    AssociationOverviewTypeDef,
    AssociationStatusTypeDef,
    AssociationTypeDef,
    AssociationVersionInfoTypeDef,
    AttachmentContentTypeDef,
    AttachmentInformationTypeDef,
    AttachmentsSourceTypeDef,
    AutomationExecutionFilterTypeDef,
    AutomationExecutionMetadataTypeDef,
    AutomationExecutionTypeDef,
    CancelMaintenanceWindowExecutionResultTypeDef,
    CloudWatchOutputConfigTypeDef,
    CommandFilterTypeDef,
    CommandInvocationTypeDef,
    CommandPluginTypeDef,
    CommandTypeDef,
    ComplianceExecutionSummaryTypeDef,
    ComplianceItemEntryTypeDef,
    ComplianceItemTypeDef,
    ComplianceStringFilterTypeDef,
    ComplianceSummaryItemTypeDef,
    CompliantSummaryTypeDef,
    CreateActivationResultTypeDef,
    CreateAssociationBatchRequestEntryTypeDef,
    CreateAssociationBatchResultTypeDef,
    CreateAssociationResultTypeDef,
    CreateDocumentResultTypeDef,
    CreateMaintenanceWindowResultTypeDef,
    CreateOpsItemResponseTypeDef,
    CreatePatchBaselineResultTypeDef,
    DeleteInventoryResultTypeDef,
    DeleteMaintenanceWindowResultTypeDef,
    DeleteParametersResultTypeDef,
    DeletePatchBaselineResultTypeDef,
    DeregisterPatchBaselineForPatchGroupResultTypeDef,
    DeregisterTargetFromMaintenanceWindowResultTypeDef,
    DeregisterTaskFromMaintenanceWindowResultTypeDef,
    DescribeActivationsFilterTypeDef,
    DescribeActivationsResultTypeDef,
    DescribeAssociationExecutionsResultTypeDef,
    DescribeAssociationExecutionTargetsResultTypeDef,
    DescribeAssociationResultTypeDef,
    DescribeAutomationExecutionsResultTypeDef,
    DescribeAutomationStepExecutionsResultTypeDef,
    DescribeAvailablePatchesResultTypeDef,
    DescribeDocumentPermissionResponseTypeDef,
    DescribeDocumentResultTypeDef,
    DescribeEffectiveInstanceAssociationsResultTypeDef,
    DescribeEffectivePatchesForPatchBaselineResultTypeDef,
    DescribeInstanceAssociationsStatusResultTypeDef,
    DescribeInstanceInformationResultTypeDef,
    DescribeInstancePatchesResultTypeDef,
    DescribeInstancePatchStatesForPatchGroupResultTypeDef,
    DescribeInstancePatchStatesResultTypeDef,
    DescribeInventoryDeletionsResultTypeDef,
    DescribeMaintenanceWindowExecutionsResultTypeDef,
    DescribeMaintenanceWindowExecutionTaskInvocationsResultTypeDef,
    DescribeMaintenanceWindowExecutionTasksResultTypeDef,
    DescribeMaintenanceWindowScheduleResultTypeDef,
    DescribeMaintenanceWindowsForTargetResultTypeDef,
    DescribeMaintenanceWindowsResultTypeDef,
    DescribeMaintenanceWindowTargetsResultTypeDef,
    DescribeMaintenanceWindowTasksResultTypeDef,
    DescribeOpsItemsResponseTypeDef,
    DescribeParametersResultTypeDef,
    DescribePatchBaselinesResultTypeDef,
    DescribePatchGroupsResultTypeDef,
    DescribePatchGroupStateResultTypeDef,
    DescribePatchPropertiesResultTypeDef,
    DescribeSessionsResponseTypeDef,
    DocumentDefaultVersionDescriptionTypeDef,
    DocumentDescriptionTypeDef,
    DocumentFilterTypeDef,
    DocumentIdentifierTypeDef,
    DocumentKeyValuesFilterTypeDef,
    DocumentParameterTypeDef,
    DocumentRequiresTypeDef,
    DocumentVersionInfoTypeDef,
    EffectivePatchTypeDef,
    FailedCreateAssociationTypeDef,
    FailureDetailsTypeDef,
    GetAutomationExecutionResultTypeDef,
    GetCalendarStateResponseTypeDef,
    GetCommandInvocationResultTypeDef,
    GetConnectionStatusResponseTypeDef,
    GetDefaultPatchBaselineResultTypeDef,
    GetDeployablePatchSnapshotForInstanceResultTypeDef,
    GetDocumentResultTypeDef,
    GetInventoryResultTypeDef,
    GetInventorySchemaResultTypeDef,
    GetMaintenanceWindowExecutionResultTypeDef,
    GetMaintenanceWindowExecutionTaskInvocationResultTypeDef,
    GetMaintenanceWindowExecutionTaskResultTypeDef,
    GetMaintenanceWindowResultTypeDef,
    GetMaintenanceWindowTaskResultTypeDef,
    GetOpsItemResponseTypeDef,
    GetOpsSummaryResultTypeDef,
    GetParameterHistoryResultTypeDef,
    GetParameterResultTypeDef,
    GetParametersByPathResultTypeDef,
    GetParametersResultTypeDef,
    GetPatchBaselineForPatchGroupResultTypeDef,
    GetPatchBaselineResultTypeDef,
    GetServiceSettingResultTypeDef,
    InstanceAggregatedAssociationOverviewTypeDef,
    InstanceAssociationOutputLocationTypeDef,
    InstanceAssociationOutputUrlTypeDef,
    InstanceAssociationStatusInfoTypeDef,
    InstanceAssociationTypeDef,
    InstanceInformationFilterTypeDef,
    InstanceInformationStringFilterTypeDef,
    InstanceInformationTypeDef,
    InstancePatchStateFilterTypeDef,
    InstancePatchStateTypeDef,
    InventoryAggregatorTypeDef,
    InventoryDeletionStatusItemTypeDef,
    InventoryDeletionSummaryItemTypeDef,
    InventoryDeletionSummaryTypeDef,
    InventoryFilterTypeDef,
    InventoryGroupTypeDef,
    InventoryItemAttributeTypeDef,
    InventoryItemSchemaTypeDef,
    InventoryItemTypeDef,
    InventoryResultEntityTypeDef,
    InventoryResultItemTypeDef,
    LabelParameterVersionResultTypeDef,
    ListAssociationsResultTypeDef,
    ListAssociationVersionsResultTypeDef,
    ListCommandInvocationsResultTypeDef,
    ListCommandsResultTypeDef,
    ListComplianceItemsResultTypeDef,
    ListComplianceSummariesResultTypeDef,
    ListDocumentsResultTypeDef,
    ListDocumentVersionsResultTypeDef,
    ListInventoryEntriesResultTypeDef,
    ListResourceComplianceSummariesResultTypeDef,
    ListResourceDataSyncResultTypeDef,
    ListTagsForResourceResultTypeDef,
    LoggingInfoTypeDef,
    MaintenanceWindowAutomationParametersTypeDef,
    MaintenanceWindowExecutionTaskIdentityTypeDef,
    MaintenanceWindowExecutionTaskInvocationIdentityTypeDef,
    MaintenanceWindowExecutionTypeDef,
    MaintenanceWindowFilterTypeDef,
    MaintenanceWindowIdentityForTargetTypeDef,
    MaintenanceWindowIdentityTypeDef,
    MaintenanceWindowLambdaParametersTypeDef,
    MaintenanceWindowRunCommandParametersTypeDef,
    MaintenanceWindowStepFunctionsParametersTypeDef,
    MaintenanceWindowTargetTypeDef,
    MaintenanceWindowTaskInvocationParametersTypeDef,
    MaintenanceWindowTaskParameterValueExpressionTypeDef,
    MaintenanceWindowTaskTypeDef,
    NonCompliantSummaryTypeDef,
    NotificationConfigTypeDef,
    OpsAggregatorTypeDef,
    OpsEntityItemTypeDef,
    OpsEntityTypeDef,
    OpsFilterTypeDef,
    OpsItemDataValueTypeDef,
    OpsItemFilterTypeDef,
    OpsItemNotificationTypeDef,
    OpsItemSummaryTypeDef,
    OpsItemTypeDef,
    OpsResultAttributeTypeDef,
    OutputSourceTypeDef,
    PaginatorConfigTypeDef,
    ParameterHistoryTypeDef,
    ParameterInlinePolicyTypeDef,
    ParameterMetadataTypeDef,
    ParametersFilterTypeDef,
    ParameterStringFilterTypeDef,
    ParameterTypeDef,
    PatchBaselineIdentityTypeDef,
    PatchComplianceDataTypeDef,
    PatchFilterGroupTypeDef,
    PatchFilterTypeDef,
    PatchGroupPatchBaselineMappingTypeDef,
    PatchOrchestratorFilterTypeDef,
    PatchRuleGroupTypeDef,
    PatchRuleTypeDef,
    PatchSourceTypeDef,
    PatchStatusTypeDef,
    PatchTypeDef,
    ProgressCountersTypeDef,
    PutInventoryResultTypeDef,
    PutParameterResultTypeDef,
    RegisterDefaultPatchBaselineResultTypeDef,
    RegisterPatchBaselineForPatchGroupResultTypeDef,
    RegisterTargetWithMaintenanceWindowResultTypeDef,
    RegisterTaskWithMaintenanceWindowResultTypeDef,
    RelatedOpsItemTypeDef,
    ResetServiceSettingResultTypeDef,
    ResolvedTargetsTypeDef,
    ResourceComplianceSummaryItemTypeDef,
    ResourceDataSyncAwsOrganizationsSourceTypeDef,
    ResourceDataSyncDestinationDataSharingTypeDef,
    ResourceDataSyncItemTypeDef,
    ResourceDataSyncOrganizationalUnitTypeDef,
    ResourceDataSyncS3DestinationTypeDef,
    ResourceDataSyncSourceTypeDef,
    ResourceDataSyncSourceWithStateTypeDef,
    ResultAttributeTypeDef,
    ResumeSessionResponseTypeDef,
    S3OutputLocationTypeDef,
    S3OutputUrlTypeDef,
    ScheduledWindowExecutionTypeDef,
    SendCommandResultTypeDef,
    ServiceSettingTypeDef,
    SessionFilterTypeDef,
    SessionManagerOutputUrlTypeDef,
    SessionTypeDef,
    SeveritySummaryTypeDef,
    StartAutomationExecutionResultTypeDef,
    StartSessionResponseTypeDef,
    StepExecutionFilterTypeDef,
    StepExecutionTypeDef,
    TagTypeDef,
    TargetLocationTypeDef,
    TargetTypeDef,
    TerminateSessionResponseTypeDef,
    UpdateAssociationResultTypeDef,
    UpdateAssociationStatusResultTypeDef,
    UpdateDocumentDefaultVersionResultTypeDef,
    UpdateDocumentResultTypeDef,
    UpdateMaintenanceWindowResultTypeDef,
    UpdateMaintenanceWindowTargetResultTypeDef,
    UpdateMaintenanceWindowTaskResultTypeDef,
    UpdatePatchBaselineResultTypeDef,
    WaiterConfigTypeDef,
)

def get_structure() -> AccountSharingInfoTypeDef:
    return {
      ...
    }
```
