"""Utility modules for the RAG system."""

from .device_utils import get_sentence_transformer_device
from .email_provider_factory import EmailProviderFactory, ProviderType
from .email_utils.base import EmailProvider
from .email_utils.graph_provider import GraphProvider
from .email_utils.imap_provider import IMAPProvider
from .email_utils.models import (
    EmailAddress,
    EmailAttachment,
    EmailDraft,
    EmailMessage,
    GraphCredentials,
    IMAPCredentials,
    MessageStatus,
)
from .latex_parser import LatexDocument, LatexParser
from .markdown_parser import (
    MarkdownChapter,
    MarkdownDocument,
    MarkdownParagraph,
    MarkdownParser,
    MarkdownSection,
)

__all__ = [
    "get_sentence_transformer_device",
    "LatexDocument",
    "LatexParser",
    "EmailMessage",
    "EmailDraft",
    "EmailAttachment",
    "EmailAddress",
    "EmailProvider",
    "IMAPProvider",
    "GraphProvider",
    "EmailProviderFactory",
    "ProviderType",
    "MessageStatus",
    "IMAPCredentials",
    "GraphCredentials",
    "MarkdownParser",
    "MarkdownDocument",
    "MarkdownChapter",
    "MarkdownSection",
    "MarkdownParagraph",
]
