# API Reference

This reference is generated automatically from the Ragora docstrings during the
release workflow. Each section below maps to a core module in the project. If
you add or update public APIs, make sure the corresponding docstrings stay in
sync so the published documentation reflects the latest release.

## CLI

::: ragora.cli.main
    options:
      heading_level: 3
## Core

### Knowledge Base Manager

::: ragora.core.knowledge_base_manager
    options:
      heading_level: 4

### Models

::: ragora.core.models
    options:
      heading_level: 4

### Retriever

::: ragora.core.retriever
    options:
      heading_level: 4

### Vector Store

::: ragora.core.vector_store
    options:
      heading_level: 4

### Database Manager

::: ragora.core.database_manager
    options:
      heading_level: 4

### Chunking

::: ragora.core.chunking
    options:
      heading_level: 4

### Document Preprocessor

::: ragora.core.document_preprocessor
    options:
      heading_level: 4

### Email Preprocessor

::: ragora.core.email_preprocessor
    options:
      heading_level: 4

### Embedding Engine

::: ragora.core.embedding_engine
    options:
      heading_level: 4

### Filters

::: ragora.core.filters
    options:
      heading_level: 4

## Exceptions

::: ragora.exceptions
    options:
      heading_level: 3

## Utilities

### Device Utilities

::: ragora.utils.device_utils
    options:
      heading_level: 4

### Email Provider Factory

::: ragora.utils.email_provider_factory
    options:
      heading_level: 4

### Email Utils

::: ragora.utils.email_utils.base
    options:
      heading_level: 4

::: ragora.utils.email_utils.graph_provider
    options:
      heading_level: 4

::: ragora.utils.email_utils.imap_provider
    options:
      heading_level: 4

::: ragora.utils.email_utils.models
    options:
      heading_level: 4

### LaTeX Parser

::: ragora.utils.latex_parser
    options:
      heading_level: 4

### Markdown Parser

::: ragora.utils.markdown_parser
    options:
      heading_level: 4

## Configuration

::: ragora.config.settings
    options:
      heading_level: 3
