from typing import List as _py_List
from typing import ClassVar as _py_ClassVar
from typing import overload
import java.math
import java.security
import java.security.spec


class DSAKey:
    def getParams(self) -> 'DSAParams': ...

class DSAKeyPairGenerator:
    @overload
    def initialize(self, int: int, boolean: bool, secureRandom: java.security.SecureRandom) -> None: ...
    @overload
    def initialize(self, dSAParams: 'DSAParams', secureRandom: java.security.SecureRandom) -> None: ...

class DSAParams:
    def getG(self) -> java.math.BigInteger: ...
    def getP(self) -> java.math.BigInteger: ...
    def getQ(self) -> java.math.BigInteger: ...

class ECKey:
    def getParams(self) -> java.security.spec.ECParameterSpec: ...

class RSAKey:
    def getModulus(self) -> java.math.BigInteger: ...

class DSAPrivateKey(DSAKey, java.security.PrivateKey):
    serialVersionUID: _py_ClassVar[int] = ...
    def getX(self) -> java.math.BigInteger: ...

class DSAPublicKey(DSAKey, java.security.PublicKey):
    serialVersionUID: _py_ClassVar[int] = ...
    def getY(self) -> java.math.BigInteger: ...

class ECPrivateKey(java.security.PrivateKey, ECKey):
    serialVersionUID: _py_ClassVar[int] = ...
    def getS(self) -> java.math.BigInteger: ...

class ECPublicKey(java.security.PublicKey, ECKey):
    serialVersionUID: _py_ClassVar[int] = ...
    def getW(self) -> java.security.spec.ECPoint: ...

class RSAPrivateKey(java.security.PrivateKey, RSAKey):
    serialVersionUID: _py_ClassVar[int] = ...
    def getPrivateExponent(self) -> java.math.BigInteger: ...

class RSAPublicKey(java.security.PublicKey, RSAKey):
    serialVersionUID: _py_ClassVar[int] = ...
    def getPublicExponent(self) -> java.math.BigInteger: ...

class RSAMultiPrimePrivateCrtKey(RSAPrivateKey):
    serialVersionUID: _py_ClassVar[int] = ...
    def getCrtCoefficient(self) -> java.math.BigInteger: ...
    def getOtherPrimeInfo(self) -> _py_List[java.security.spec.RSAOtherPrimeInfo]: ...
    def getPrimeExponentP(self) -> java.math.BigInteger: ...
    def getPrimeExponentQ(self) -> java.math.BigInteger: ...
    def getPrimeP(self) -> java.math.BigInteger: ...
    def getPrimeQ(self) -> java.math.BigInteger: ...
    def getPublicExponent(self) -> java.math.BigInteger: ...

class RSAPrivateCrtKey(RSAPrivateKey):
    serialVersionUID: _py_ClassVar[int] = ...
    def getCrtCoefficient(self) -> java.math.BigInteger: ...
    def getPrimeExponentP(self) -> java.math.BigInteger: ...
    def getPrimeExponentQ(self) -> java.math.BigInteger: ...
    def getPrimeP(self) -> java.math.BigInteger: ...
    def getPrimeQ(self) -> java.math.BigInteger: ...
    def getPublicExponent(self) -> java.math.BigInteger: ...
