from typing import Any as _py_Any
from typing import List as _py_List
from typing import Type as _py_Type
from typing import ClassVar as _py_ClassVar
from typing import overload
import java.io
import java.lang
import java.lang.reflect
import java.net
import java.rmi


class ExportException(java.rmi.RemoteException):
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, exception: java.lang.Exception): ...

class LoaderHandler:
    packagePrefix: _py_ClassVar[str] = ...
    def getSecurityContext(self, classLoader: java.lang.ClassLoader) -> _py_Any: ...
    @overload
    def loadClass(self, string: str) -> _py_Type[_py_Any]: ...
    @overload
    def loadClass(self, uRL: java.net.URL, string: str) -> _py_Type[_py_Any]: ...

class LogStream(java.io.PrintStream):
    SILENT: _py_ClassVar[int] = ...
    BRIEF: _py_ClassVar[int] = ...
    VERBOSE: _py_ClassVar[int] = ...
    @classmethod
    def getDefaultStream(cls) -> java.io.PrintStream: ...
    def getOutputStream(self) -> java.io.OutputStream: ...
    @classmethod
    def log(cls, string: str) -> 'LogStream': ...
    @classmethod
    def parseLevel(cls, string: str) -> int: ...
    @classmethod
    def setDefaultStream(cls, printStream: java.io.PrintStream) -> None: ...
    def setOutputStream(self, outputStream: java.io.OutputStream) -> None: ...
    def toString(self) -> str: ...
    @overload
    def write(self, byteArray: _py_List[int]) -> None: ...
    @overload
    def write(self, byteArray: _py_List[int], int: int, int2: int) -> None: ...
    @overload
    def write(self, int: int) -> None: ...

class ObjID(java.io.Serializable):
    REGISTRY_ID: _py_ClassVar[int] = ...
    ACTIVATOR_ID: _py_ClassVar[int] = ...
    DGC_ID: _py_ClassVar[int] = ...
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, int: int): ...
    def equals(self, object: _py_Any) -> bool: ...
    def hashCode(self) -> int: ...
    @classmethod
    def read(cls, objectInput: java.io.ObjectInput) -> 'ObjID': ...
    def toString(self) -> str: ...
    def write(self, objectOutput: java.io.ObjectOutput) -> None: ...

class Operation:
    def __init__(self, string: str): ...
    def getOperation(self) -> str: ...
    def toString(self) -> str: ...

class RMIClassLoader:
    @classmethod
    def getClassAnnotation(cls, class_: _py_Type[_py_Any]) -> str: ...
    @classmethod
    def getClassLoader(cls, string: str) -> java.lang.ClassLoader: ...
    @classmethod
    def getDefaultProviderInstance(cls) -> 'RMIClassLoaderSpi': ...
    @classmethod
    def getSecurityContext(cls, classLoader: java.lang.ClassLoader) -> _py_Any: ...
    @classmethod
    @overload
    def loadClass(cls, string: str) -> _py_Type[_py_Any]: ...
    @classmethod
    @overload
    def loadClass(cls, string: str, string2: str) -> _py_Type[_py_Any]: ...
    @classmethod
    @overload
    def loadClass(cls, string: str, string2: str, classLoader: java.lang.ClassLoader) -> _py_Type[_py_Any]: ...
    @classmethod
    @overload
    def loadClass(cls, uRL: java.net.URL, string: str) -> _py_Type[_py_Any]: ...
    @classmethod
    def loadProxyClass(cls, string: str, stringArray: _py_List[str], classLoader: java.lang.ClassLoader) -> _py_Type[_py_Any]: ...

class RMIClassLoaderSpi:
    def __init__(self): ...
    def getClassAnnotation(self, class_: _py_Type[_py_Any]) -> str: ...
    def getClassLoader(self, string: str) -> java.lang.ClassLoader: ...
    def loadClass(self, string: str, string2: str, classLoader: java.lang.ClassLoader) -> _py_Type[_py_Any]: ...
    def loadProxyClass(self, string: str, stringArray: _py_List[str], classLoader: java.lang.ClassLoader) -> _py_Type[_py_Any]: ...

class RMIClientSocketFactory:
    def createSocket(self, string: str, int: int) -> java.net.Socket: ...

class RMIFailureHandler:
    def failure(self, exception: java.lang.Exception) -> bool: ...

class RMIServerSocketFactory:
    def createServerSocket(self, int: int) -> java.net.ServerSocket: ...

class RemoteCall:
    def done(self) -> None: ...
    def executeCall(self) -> None: ...
    def getInputStream(self) -> java.io.ObjectInput: ...
    def getOutputStream(self) -> java.io.ObjectOutput: ...
    def getResultStream(self, boolean: bool) -> java.io.ObjectOutput: ...
    def releaseInputStream(self) -> None: ...
    def releaseOutputStream(self) -> None: ...

class RemoteObject(java.rmi.Remote, java.io.Serializable):
    def equals(self, object: _py_Any) -> bool: ...
    def getRef(self) -> 'RemoteRef': ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...
    @classmethod
    def toStub(cls, remote: java.rmi.Remote) -> java.rmi.Remote: ...

class RemoteRef(java.io.Externalizable):
    serialVersionUID: _py_ClassVar[int] = ...
    packagePrefix: _py_ClassVar[str] = ...
    def done(self, remoteCall: RemoteCall) -> None: ...
    def getRefClass(self, objectOutput: java.io.ObjectOutput) -> str: ...
    @overload
    def invoke(self, remote: java.rmi.Remote, method: java.lang.reflect.Method, objectArray: _py_List[_py_Any], long: int) -> _py_Any: ...
    @overload
    def invoke(self, remoteCall: RemoteCall) -> None: ...
    def newCall(self, remoteObject: RemoteObject, operationArray: _py_List[Operation], int: int, long: int) -> RemoteCall: ...
    def remoteEquals(self, remoteRef: 'RemoteRef') -> bool: ...
    def remoteHashCode(self) -> int: ...
    def remoteToString(self) -> str: ...

class ServerCloneException(java.lang.CloneNotSupportedException):
    detail: java.lang.Exception = ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, exception: java.lang.Exception): ...
    def getCause(self) -> java.lang.Throwable: ...
    def getMessage(self) -> str: ...

class ServerNotActiveException(java.lang.Exception):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...

class Skeleton:
    def dispatch(self, remote: java.rmi.Remote, remoteCall: RemoteCall, int: int, long: int) -> None: ...
    def getOperations(self) -> _py_List[Operation]: ...

class SkeletonMismatchException(java.rmi.RemoteException):
    def __init__(self, string: str): ...

class SkeletonNotFoundException(java.rmi.RemoteException):
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, exception: java.lang.Exception): ...

class UID(java.io.Serializable):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, short: int): ...
    def equals(self, object: _py_Any) -> bool: ...
    def hashCode(self) -> int: ...
    @classmethod
    def read(cls, dataInput: java.io.DataInput) -> 'UID': ...
    def toString(self) -> str: ...
    def write(self, dataOutput: java.io.DataOutput) -> None: ...

class Unreferenced:
    def unreferenced(self) -> None: ...

class RMISocketFactory(RMIClientSocketFactory, RMIServerSocketFactory):
    def __init__(self): ...
    def createServerSocket(self, int: int) -> java.net.ServerSocket: ...
    def createSocket(self, string: str, int: int) -> java.net.Socket: ...
    @classmethod
    def getDefaultSocketFactory(cls) -> 'RMISocketFactory': ...
    @classmethod
    def getFailureHandler(cls) -> RMIFailureHandler: ...
    @classmethod
    def getSocketFactory(cls) -> 'RMISocketFactory': ...
    @classmethod
    def setFailureHandler(cls, rMIFailureHandler: RMIFailureHandler) -> None: ...
    @classmethod
    def setSocketFactory(cls, rMISocketFactory: 'RMISocketFactory') -> None: ...

class RemoteObjectInvocationHandler(RemoteObject, java.lang.reflect.InvocationHandler):
    def __init__(self, remoteRef: RemoteRef): ...
    def invoke(self, object: _py_Any, method: java.lang.reflect.Method, objectArray: _py_List[_py_Any]) -> _py_Any: ...

class RemoteServer(RemoteObject):
    @classmethod
    def getClientHost(cls) -> str: ...
    @classmethod
    def getLog(cls) -> java.io.PrintStream: ...
    @classmethod
    def setLog(cls, outputStream: java.io.OutputStream) -> None: ...

class RemoteStub(RemoteObject): ...

class ServerRef(RemoteRef):
    serialVersionUID: _py_ClassVar[int] = ...
    def exportObject(self, remote: java.rmi.Remote, object: _py_Any) -> RemoteStub: ...
    def getClientHost(self) -> str: ...

class SocketSecurityException(ExportException):
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, exception: java.lang.Exception): ...

class UnicastRemoteObject(RemoteServer):
    def clone(self) -> _py_Any: ...
    @classmethod
    @overload
    def exportObject(cls, remote: java.rmi.Remote, int: int) -> java.rmi.Remote: ...
    @classmethod
    @overload
    def exportObject(cls, remote: java.rmi.Remote, int: int, rMIClientSocketFactory: RMIClientSocketFactory, rMIServerSocketFactory: RMIServerSocketFactory) -> java.rmi.Remote: ...
    @classmethod
    @overload
    def exportObject(cls, remote: java.rmi.Remote) -> RemoteStub: ...
    @classmethod
    def unexportObject(cls, remote: java.rmi.Remote, boolean: bool) -> bool: ...
